/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sagemaker.model.AssociationInfo;
import software.amazon.awssdk.services.sagemaker.model.AssociationInfoListCopier;
import software.amazon.awssdk.services.sagemaker.model.MapString2048Copier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LineageMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LineageMetadata> {
    private static final SdkField<Map<String, String>> ACTION_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ActionArns").getter(LineageMetadata.getter(LineageMetadata::actionArns)).setter(LineageMetadata.setter(Builder::actionArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionArns").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> ARTIFACT_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ArtifactArns").getter(LineageMetadata.getter(LineageMetadata::artifactArns)).setter(LineageMetadata.setter(Builder::artifactArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArtifactArns").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> CONTEXT_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ContextArns").getter(LineageMetadata.getter(LineageMetadata::contextArns)).setter(LineageMetadata.setter(Builder::contextArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContextArns").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<AssociationInfo>> ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Associations").getter(LineageMetadata.getter(LineageMetadata::associations)).setter(LineageMetadata.setter(Builder::associations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Associations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssociationInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_ARNS_FIELD, ARTIFACT_ARNS_FIELD, CONTEXT_ARNS_FIELD, ASSOCIATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LineageMetadata.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Map<String, String> actionArns;
    private final Map<String, String> artifactArns;
    private final Map<String, String> contextArns;
    private final List<AssociationInfo> associations;

    private LineageMetadata(BuilderImpl builder) {
        this.actionArns = builder.actionArns;
        this.artifactArns = builder.artifactArns;
        this.contextArns = builder.contextArns;
        this.associations = builder.associations;
    }

    public final boolean hasActionArns() {
        return this.actionArns != null && !(this.actionArns instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> actionArns() {
        return this.actionArns;
    }

    public final boolean hasArtifactArns() {
        return this.artifactArns != null && !(this.artifactArns instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> artifactArns() {
        return this.artifactArns;
    }

    public final boolean hasContextArns() {
        return this.contextArns != null && !(this.contextArns instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> contextArns() {
        return this.contextArns;
    }

    public final boolean hasAssociations() {
        return this.associations != null && !(this.associations instanceof SdkAutoConstructList);
    }

    public final List<AssociationInfo> associations() {
        return this.associations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActionArns() ? this.actionArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasArtifactArns() ? this.artifactArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContextArns() ? this.contextArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociations() ? this.associations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LineageMetadata)) {
            return false;
        }
        LineageMetadata other = (LineageMetadata)obj;
        return this.hasActionArns() == other.hasActionArns() && Objects.equals(this.actionArns(), other.actionArns()) && this.hasArtifactArns() == other.hasArtifactArns() && Objects.equals(this.artifactArns(), other.artifactArns()) && this.hasContextArns() == other.hasContextArns() && Objects.equals(this.contextArns(), other.contextArns()) && this.hasAssociations() == other.hasAssociations() && Objects.equals(this.associations(), other.associations());
    }

    public final String toString() {
        return ToString.builder((String)"LineageMetadata").add("ActionArns", this.hasActionArns() ? this.actionArns() : null).add("ArtifactArns", this.hasArtifactArns() ? this.artifactArns() : null).add("ContextArns", this.hasContextArns() ? this.contextArns() : null).add("Associations", this.hasAssociations() ? this.associations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActionArns": {
                return Optional.ofNullable(clazz.cast(this.actionArns()));
            }
            case "ArtifactArns": {
                return Optional.ofNullable(clazz.cast(this.artifactArns()));
            }
            case "ContextArns": {
                return Optional.ofNullable(clazz.cast(this.contextArns()));
            }
            case "Associations": {
                return Optional.ofNullable(clazz.cast(this.associations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ActionArns", ACTION_ARNS_FIELD);
        map.put("ArtifactArns", ARTIFACT_ARNS_FIELD);
        map.put("ContextArns", CONTEXT_ARNS_FIELD);
        map.put("Associations", ASSOCIATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LineageMetadata, T> g) {
        return obj -> g.apply((LineageMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> actionArns = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> artifactArns = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> contextArns = DefaultSdkAutoConstructMap.getInstance();
        private List<AssociationInfo> associations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LineageMetadata model) {
            this.actionArns(model.actionArns);
            this.artifactArns(model.artifactArns);
            this.contextArns(model.contextArns);
            this.associations(model.associations);
        }

        public final Map<String, String> getActionArns() {
            if (this.actionArns instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.actionArns;
        }

        public final void setActionArns(Map<String, String> actionArns) {
            this.actionArns = MapString2048Copier.copy(actionArns);
        }

        @Override
        public final Builder actionArns(Map<String, String> actionArns) {
            this.actionArns = MapString2048Copier.copy(actionArns);
            return this;
        }

        public final Map<String, String> getArtifactArns() {
            if (this.artifactArns instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.artifactArns;
        }

        public final void setArtifactArns(Map<String, String> artifactArns) {
            this.artifactArns = MapString2048Copier.copy(artifactArns);
        }

        @Override
        public final Builder artifactArns(Map<String, String> artifactArns) {
            this.artifactArns = MapString2048Copier.copy(artifactArns);
            return this;
        }

        public final Map<String, String> getContextArns() {
            if (this.contextArns instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.contextArns;
        }

        public final void setContextArns(Map<String, String> contextArns) {
            this.contextArns = MapString2048Copier.copy(contextArns);
        }

        @Override
        public final Builder contextArns(Map<String, String> contextArns) {
            this.contextArns = MapString2048Copier.copy(contextArns);
            return this;
        }

        public final List<AssociationInfo.Builder> getAssociations() {
            List<AssociationInfo.Builder> result = AssociationInfoListCopier.copyToBuilder(this.associations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssociations(Collection<AssociationInfo.BuilderImpl> associations) {
            this.associations = AssociationInfoListCopier.copyFromBuilder(associations);
        }

        @Override
        public final Builder associations(Collection<AssociationInfo> associations) {
            this.associations = AssociationInfoListCopier.copy(associations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associations(AssociationInfo ... associations) {
            this.associations(Arrays.asList(associations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associations(Consumer<AssociationInfo.Builder> ... associations) {
            this.associations(Stream.of(associations).map(c -> (AssociationInfo)((AssociationInfo.Builder)AssociationInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public LineageMetadata build() {
            return new LineageMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LineageMetadata> {
        public Builder actionArns(Map<String, String> var1);

        public Builder artifactArns(Map<String, String> var1);

        public Builder contextArns(Map<String, String> var1);

        public Builder associations(Collection<AssociationInfo> var1);

        public Builder associations(AssociationInfo ... var1);

        public Builder associations(Consumer<AssociationInfo.Builder> ... var1);
    }
}

