/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.PlacementSpecification;
import software.amazon.awssdk.services.sagemaker.model.PlacementSpecificationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstancePlacementConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstancePlacementConfig> {
    private static final SdkField<Boolean> ENABLE_MULTIPLE_JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableMultipleJobs").getter(InstancePlacementConfig.getter(InstancePlacementConfig::enableMultipleJobs)).setter(InstancePlacementConfig.setter(Builder::enableMultipleJobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableMultipleJobs").build()}).build();
    private static final SdkField<List<PlacementSpecification>> PLACEMENT_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PlacementSpecifications").getter(InstancePlacementConfig.getter(InstancePlacementConfig::placementSpecifications)).setter(InstancePlacementConfig.setter(Builder::placementSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlacementSpecifications").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PlacementSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLE_MULTIPLE_JOBS_FIELD, PLACEMENT_SPECIFICATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InstancePlacementConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean enableMultipleJobs;
    private final List<PlacementSpecification> placementSpecifications;

    private InstancePlacementConfig(BuilderImpl builder) {
        this.enableMultipleJobs = builder.enableMultipleJobs;
        this.placementSpecifications = builder.placementSpecifications;
    }

    public final Boolean enableMultipleJobs() {
        return this.enableMultipleJobs;
    }

    public final boolean hasPlacementSpecifications() {
        return this.placementSpecifications != null && !(this.placementSpecifications instanceof SdkAutoConstructList);
    }

    public final List<PlacementSpecification> placementSpecifications() {
        return this.placementSpecifications;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enableMultipleJobs());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPlacementSpecifications() ? this.placementSpecifications() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstancePlacementConfig)) {
            return false;
        }
        InstancePlacementConfig other = (InstancePlacementConfig)obj;
        return Objects.equals(this.enableMultipleJobs(), other.enableMultipleJobs()) && this.hasPlacementSpecifications() == other.hasPlacementSpecifications() && Objects.equals(this.placementSpecifications(), other.placementSpecifications());
    }

    public final String toString() {
        return ToString.builder((String)"InstancePlacementConfig").add("EnableMultipleJobs", (Object)this.enableMultipleJobs()).add("PlacementSpecifications", this.hasPlacementSpecifications() ? this.placementSpecifications() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EnableMultipleJobs": {
                return Optional.ofNullable(clazz.cast(this.enableMultipleJobs()));
            }
            case "PlacementSpecifications": {
                return Optional.ofNullable(clazz.cast(this.placementSpecifications()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EnableMultipleJobs", ENABLE_MULTIPLE_JOBS_FIELD);
        map.put("PlacementSpecifications", PLACEMENT_SPECIFICATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstancePlacementConfig, T> g) {
        return obj -> g.apply((InstancePlacementConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enableMultipleJobs;
        private List<PlacementSpecification> placementSpecifications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InstancePlacementConfig model) {
            this.enableMultipleJobs(model.enableMultipleJobs);
            this.placementSpecifications(model.placementSpecifications);
        }

        public final Boolean getEnableMultipleJobs() {
            return this.enableMultipleJobs;
        }

        public final void setEnableMultipleJobs(Boolean enableMultipleJobs) {
            this.enableMultipleJobs = enableMultipleJobs;
        }

        @Override
        public final Builder enableMultipleJobs(Boolean enableMultipleJobs) {
            this.enableMultipleJobs = enableMultipleJobs;
            return this;
        }

        public final List<PlacementSpecification.Builder> getPlacementSpecifications() {
            List<PlacementSpecification.Builder> result = PlacementSpecificationsCopier.copyToBuilder(this.placementSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPlacementSpecifications(Collection<PlacementSpecification.BuilderImpl> placementSpecifications) {
            this.placementSpecifications = PlacementSpecificationsCopier.copyFromBuilder(placementSpecifications);
        }

        @Override
        public final Builder placementSpecifications(Collection<PlacementSpecification> placementSpecifications) {
            this.placementSpecifications = PlacementSpecificationsCopier.copy(placementSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementSpecifications(PlacementSpecification ... placementSpecifications) {
            this.placementSpecifications(Arrays.asList(placementSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementSpecifications(Consumer<PlacementSpecification.Builder> ... placementSpecifications) {
            this.placementSpecifications(Stream.of(placementSpecifications).map(c -> (PlacementSpecification)((PlacementSpecification.Builder)PlacementSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public InstancePlacementConfig build() {
            return new InstancePlacementConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstancePlacementConfig> {
        public Builder enableMultipleJobs(Boolean var1);

        public Builder placementSpecifications(Collection<PlacementSpecification> var1);

        public Builder placementSpecifications(PlacementSpecification ... var1);

        public Builder placementSpecifications(Consumer<PlacementSpecification.Builder> ... var1);
    }
}

