/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.InferenceComponentComputeResourceRequirements;
import software.amazon.awssdk.services.sagemaker.model.InferenceComponentContainerSpecificationSummary;
import software.amazon.awssdk.services.sagemaker.model.InferenceComponentDataCacheConfigSummary;
import software.amazon.awssdk.services.sagemaker.model.InferenceComponentStartupParameters;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InferenceComponentSpecificationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InferenceComponentSpecificationSummary> {
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelName").getter(InferenceComponentSpecificationSummary.getter(InferenceComponentSpecificationSummary::modelName)).setter(InferenceComponentSpecificationSummary.setter(Builder::modelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()}).build();
    private static final SdkField<InferenceComponentContainerSpecificationSummary> CONTAINER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Container").getter(InferenceComponentSpecificationSummary.getter(InferenceComponentSpecificationSummary::container)).setter(InferenceComponentSpecificationSummary.setter(Builder::container)).constructor(InferenceComponentContainerSpecificationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Container").build()}).build();
    private static final SdkField<InferenceComponentStartupParameters> STARTUP_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StartupParameters").getter(InferenceComponentSpecificationSummary.getter(InferenceComponentSpecificationSummary::startupParameters)).setter(InferenceComponentSpecificationSummary.setter(Builder::startupParameters)).constructor(InferenceComponentStartupParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartupParameters").build()}).build();
    private static final SdkField<InferenceComponentComputeResourceRequirements> COMPUTE_RESOURCE_REQUIREMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ComputeResourceRequirements").getter(InferenceComponentSpecificationSummary.getter(InferenceComponentSpecificationSummary::computeResourceRequirements)).setter(InferenceComponentSpecificationSummary.setter(Builder::computeResourceRequirements)).constructor(InferenceComponentComputeResourceRequirements::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeResourceRequirements").build()}).build();
    private static final SdkField<String> BASE_INFERENCE_COMPONENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BaseInferenceComponentName").getter(InferenceComponentSpecificationSummary.getter(InferenceComponentSpecificationSummary::baseInferenceComponentName)).setter(InferenceComponentSpecificationSummary.setter(Builder::baseInferenceComponentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseInferenceComponentName").build()}).build();
    private static final SdkField<InferenceComponentDataCacheConfigSummary> DATA_CACHE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataCacheConfig").getter(InferenceComponentSpecificationSummary.getter(InferenceComponentSpecificationSummary::dataCacheConfig)).setter(InferenceComponentSpecificationSummary.setter(Builder::dataCacheConfig)).constructor(InferenceComponentDataCacheConfigSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataCacheConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_NAME_FIELD, CONTAINER_FIELD, STARTUP_PARAMETERS_FIELD, COMPUTE_RESOURCE_REQUIREMENTS_FIELD, BASE_INFERENCE_COMPONENT_NAME_FIELD, DATA_CACHE_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InferenceComponentSpecificationSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String modelName;
    private final InferenceComponentContainerSpecificationSummary container;
    private final InferenceComponentStartupParameters startupParameters;
    private final InferenceComponentComputeResourceRequirements computeResourceRequirements;
    private final String baseInferenceComponentName;
    private final InferenceComponentDataCacheConfigSummary dataCacheConfig;

    private InferenceComponentSpecificationSummary(BuilderImpl builder) {
        this.modelName = builder.modelName;
        this.container = builder.container;
        this.startupParameters = builder.startupParameters;
        this.computeResourceRequirements = builder.computeResourceRequirements;
        this.baseInferenceComponentName = builder.baseInferenceComponentName;
        this.dataCacheConfig = builder.dataCacheConfig;
    }

    public final String modelName() {
        return this.modelName;
    }

    public final InferenceComponentContainerSpecificationSummary container() {
        return this.container;
    }

    public final InferenceComponentStartupParameters startupParameters() {
        return this.startupParameters;
    }

    public final InferenceComponentComputeResourceRequirements computeResourceRequirements() {
        return this.computeResourceRequirements;
    }

    public final String baseInferenceComponentName() {
        return this.baseInferenceComponentName;
    }

    public final InferenceComponentDataCacheConfigSummary dataCacheConfig() {
        return this.dataCacheConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.container());
        hashCode = 31 * hashCode + Objects.hashCode(this.startupParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeResourceRequirements());
        hashCode = 31 * hashCode + Objects.hashCode(this.baseInferenceComponentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataCacheConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferenceComponentSpecificationSummary)) {
            return false;
        }
        InferenceComponentSpecificationSummary other = (InferenceComponentSpecificationSummary)obj;
        return Objects.equals(this.modelName(), other.modelName()) && Objects.equals(this.container(), other.container()) && Objects.equals(this.startupParameters(), other.startupParameters()) && Objects.equals(this.computeResourceRequirements(), other.computeResourceRequirements()) && Objects.equals(this.baseInferenceComponentName(), other.baseInferenceComponentName()) && Objects.equals(this.dataCacheConfig(), other.dataCacheConfig());
    }

    public final String toString() {
        return ToString.builder((String)"InferenceComponentSpecificationSummary").add("ModelName", (Object)this.modelName()).add("Container", (Object)this.container()).add("StartupParameters", (Object)this.startupParameters()).add("ComputeResourceRequirements", (Object)this.computeResourceRequirements()).add("BaseInferenceComponentName", (Object)this.baseInferenceComponentName()).add("DataCacheConfig", (Object)this.dataCacheConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelName": {
                return Optional.ofNullable(clazz.cast(this.modelName()));
            }
            case "Container": {
                return Optional.ofNullable(clazz.cast(this.container()));
            }
            case "StartupParameters": {
                return Optional.ofNullable(clazz.cast(this.startupParameters()));
            }
            case "ComputeResourceRequirements": {
                return Optional.ofNullable(clazz.cast(this.computeResourceRequirements()));
            }
            case "BaseInferenceComponentName": {
                return Optional.ofNullable(clazz.cast(this.baseInferenceComponentName()));
            }
            case "DataCacheConfig": {
                return Optional.ofNullable(clazz.cast(this.dataCacheConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ModelName", MODEL_NAME_FIELD);
        map.put("Container", CONTAINER_FIELD);
        map.put("StartupParameters", STARTUP_PARAMETERS_FIELD);
        map.put("ComputeResourceRequirements", COMPUTE_RESOURCE_REQUIREMENTS_FIELD);
        map.put("BaseInferenceComponentName", BASE_INFERENCE_COMPONENT_NAME_FIELD);
        map.put("DataCacheConfig", DATA_CACHE_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InferenceComponentSpecificationSummary, T> g) {
        return obj -> g.apply((InferenceComponentSpecificationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String modelName;
        private InferenceComponentContainerSpecificationSummary container;
        private InferenceComponentStartupParameters startupParameters;
        private InferenceComponentComputeResourceRequirements computeResourceRequirements;
        private String baseInferenceComponentName;
        private InferenceComponentDataCacheConfigSummary dataCacheConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(InferenceComponentSpecificationSummary model) {
            this.modelName(model.modelName);
            this.container(model.container);
            this.startupParameters(model.startupParameters);
            this.computeResourceRequirements(model.computeResourceRequirements);
            this.baseInferenceComponentName(model.baseInferenceComponentName);
            this.dataCacheConfig(model.dataCacheConfig);
        }

        public final String getModelName() {
            return this.modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final InferenceComponentContainerSpecificationSummary.Builder getContainer() {
            return this.container != null ? this.container.toBuilder() : null;
        }

        public final void setContainer(InferenceComponentContainerSpecificationSummary.BuilderImpl container) {
            this.container = container != null ? container.build() : null;
        }

        @Override
        public final Builder container(InferenceComponentContainerSpecificationSummary container) {
            this.container = container;
            return this;
        }

        public final InferenceComponentStartupParameters.Builder getStartupParameters() {
            return this.startupParameters != null ? this.startupParameters.toBuilder() : null;
        }

        public final void setStartupParameters(InferenceComponentStartupParameters.BuilderImpl startupParameters) {
            this.startupParameters = startupParameters != null ? startupParameters.build() : null;
        }

        @Override
        public final Builder startupParameters(InferenceComponentStartupParameters startupParameters) {
            this.startupParameters = startupParameters;
            return this;
        }

        public final InferenceComponentComputeResourceRequirements.Builder getComputeResourceRequirements() {
            return this.computeResourceRequirements != null ? this.computeResourceRequirements.toBuilder() : null;
        }

        public final void setComputeResourceRequirements(InferenceComponentComputeResourceRequirements.BuilderImpl computeResourceRequirements) {
            this.computeResourceRequirements = computeResourceRequirements != null ? computeResourceRequirements.build() : null;
        }

        @Override
        public final Builder computeResourceRequirements(InferenceComponentComputeResourceRequirements computeResourceRequirements) {
            this.computeResourceRequirements = computeResourceRequirements;
            return this;
        }

        public final String getBaseInferenceComponentName() {
            return this.baseInferenceComponentName;
        }

        public final void setBaseInferenceComponentName(String baseInferenceComponentName) {
            this.baseInferenceComponentName = baseInferenceComponentName;
        }

        @Override
        public final Builder baseInferenceComponentName(String baseInferenceComponentName) {
            this.baseInferenceComponentName = baseInferenceComponentName;
            return this;
        }

        public final InferenceComponentDataCacheConfigSummary.Builder getDataCacheConfig() {
            return this.dataCacheConfig != null ? this.dataCacheConfig.toBuilder() : null;
        }

        public final void setDataCacheConfig(InferenceComponentDataCacheConfigSummary.BuilderImpl dataCacheConfig) {
            this.dataCacheConfig = dataCacheConfig != null ? dataCacheConfig.build() : null;
        }

        @Override
        public final Builder dataCacheConfig(InferenceComponentDataCacheConfigSummary dataCacheConfig) {
            this.dataCacheConfig = dataCacheConfig;
            return this;
        }

        public InferenceComponentSpecificationSummary build() {
            return new InferenceComponentSpecificationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InferenceComponentSpecificationSummary> {
        public Builder modelName(String var1);

        public Builder container(InferenceComponentContainerSpecificationSummary var1);

        default public Builder container(Consumer<InferenceComponentContainerSpecificationSummary.Builder> container) {
            return this.container((InferenceComponentContainerSpecificationSummary)((InferenceComponentContainerSpecificationSummary.Builder)InferenceComponentContainerSpecificationSummary.builder().applyMutation(container)).build());
        }

        public Builder startupParameters(InferenceComponentStartupParameters var1);

        default public Builder startupParameters(Consumer<InferenceComponentStartupParameters.Builder> startupParameters) {
            return this.startupParameters((InferenceComponentStartupParameters)((InferenceComponentStartupParameters.Builder)InferenceComponentStartupParameters.builder().applyMutation(startupParameters)).build());
        }

        public Builder computeResourceRequirements(InferenceComponentComputeResourceRequirements var1);

        default public Builder computeResourceRequirements(Consumer<InferenceComponentComputeResourceRequirements.Builder> computeResourceRequirements) {
            return this.computeResourceRequirements((InferenceComponentComputeResourceRequirements)((InferenceComponentComputeResourceRequirements.Builder)InferenceComponentComputeResourceRequirements.builder().applyMutation(computeResourceRequirements)).build());
        }

        public Builder baseInferenceComponentName(String var1);

        public Builder dataCacheConfig(InferenceComponentDataCacheConfigSummary var1);

        default public Builder dataCacheConfig(Consumer<InferenceComponentDataCacheConfigSummary.Builder> dataCacheConfig) {
            return this.dataCacheConfig((InferenceComponentDataCacheConfigSummary)((InferenceComponentDataCacheConfigSummary.Builder)InferenceComponentDataCacheConfigSummary.builder().applyMutation(dataCacheConfig)).build());
        }
    }
}

