/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.SageMakerImageName;
import software.amazon.awssdk.services.sagemaker.model.VersionAliasesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HiddenSageMakerImage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HiddenSageMakerImage> {
    private static final SdkField<String> SAGE_MAKER_IMAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SageMakerImageName").getter(HiddenSageMakerImage.getter(HiddenSageMakerImage::sageMakerImageNameAsString)).setter(HiddenSageMakerImage.setter(Builder::sageMakerImageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SageMakerImageName").build()}).build();
    private static final SdkField<List<String>> VERSION_ALIASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VersionAliases").getter(HiddenSageMakerImage.getter(HiddenSageMakerImage::versionAliases)).setter(HiddenSageMakerImage.setter(Builder::versionAliases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionAliases").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAGE_MAKER_IMAGE_NAME_FIELD, VERSION_ALIASES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = HiddenSageMakerImage.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String sageMakerImageName;
    private final List<String> versionAliases;

    private HiddenSageMakerImage(BuilderImpl builder) {
        this.sageMakerImageName = builder.sageMakerImageName;
        this.versionAliases = builder.versionAliases;
    }

    public final SageMakerImageName sageMakerImageName() {
        return SageMakerImageName.fromValue(this.sageMakerImageName);
    }

    public final String sageMakerImageNameAsString() {
        return this.sageMakerImageName;
    }

    public final boolean hasVersionAliases() {
        return this.versionAliases != null && !(this.versionAliases instanceof SdkAutoConstructList);
    }

    public final List<String> versionAliases() {
        return this.versionAliases;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sageMakerImageNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVersionAliases() ? this.versionAliases() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HiddenSageMakerImage)) {
            return false;
        }
        HiddenSageMakerImage other = (HiddenSageMakerImage)obj;
        return Objects.equals(this.sageMakerImageNameAsString(), other.sageMakerImageNameAsString()) && this.hasVersionAliases() == other.hasVersionAliases() && Objects.equals(this.versionAliases(), other.versionAliases());
    }

    public final String toString() {
        return ToString.builder((String)"HiddenSageMakerImage").add("SageMakerImageName", (Object)this.sageMakerImageNameAsString()).add("VersionAliases", this.hasVersionAliases() ? this.versionAliases() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SageMakerImageName": {
                return Optional.ofNullable(clazz.cast(this.sageMakerImageNameAsString()));
            }
            case "VersionAliases": {
                return Optional.ofNullable(clazz.cast(this.versionAliases()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SageMakerImageName", SAGE_MAKER_IMAGE_NAME_FIELD);
        map.put("VersionAliases", VERSION_ALIASES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HiddenSageMakerImage, T> g) {
        return obj -> g.apply((HiddenSageMakerImage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sageMakerImageName;
        private List<String> versionAliases = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(HiddenSageMakerImage model) {
            this.sageMakerImageName(model.sageMakerImageName);
            this.versionAliases(model.versionAliases);
        }

        public final String getSageMakerImageName() {
            return this.sageMakerImageName;
        }

        public final void setSageMakerImageName(String sageMakerImageName) {
            this.sageMakerImageName = sageMakerImageName;
        }

        @Override
        public final Builder sageMakerImageName(String sageMakerImageName) {
            this.sageMakerImageName = sageMakerImageName;
            return this;
        }

        @Override
        public final Builder sageMakerImageName(SageMakerImageName sageMakerImageName) {
            this.sageMakerImageName(sageMakerImageName == null ? null : sageMakerImageName.toString());
            return this;
        }

        public final Collection<String> getVersionAliases() {
            if (this.versionAliases instanceof SdkAutoConstructList) {
                return null;
            }
            return this.versionAliases;
        }

        public final void setVersionAliases(Collection<String> versionAliases) {
            this.versionAliases = VersionAliasesListCopier.copy(versionAliases);
        }

        @Override
        public final Builder versionAliases(Collection<String> versionAliases) {
            this.versionAliases = VersionAliasesListCopier.copy(versionAliases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder versionAliases(String ... versionAliases) {
            this.versionAliases(Arrays.asList(versionAliases));
            return this;
        }

        public HiddenSageMakerImage build() {
            return new HiddenSageMakerImage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HiddenSageMakerImage> {
        public Builder sageMakerImageName(String var1);

        public Builder sageMakerImageName(SageMakerImageName var1);

        public Builder versionAliases(Collection<String> var1);

        public Builder versionAliases(String ... var1);
    }
}

