/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sagemaker.model.ClusterMetadata;
import software.amazon.awssdk.services.sagemaker.model.InstanceGroupMetadata;
import software.amazon.awssdk.services.sagemaker.model.InstanceGroupScalingMetadata;
import software.amazon.awssdk.services.sagemaker.model.InstanceMetadata;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EventMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EventMetadata> {
    private static final SdkField<ClusterMetadata> CLUSTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Cluster").getter(EventMetadata.getter(EventMetadata::cluster)).setter(EventMetadata.setter(Builder::cluster)).constructor(ClusterMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cluster").build()}).build();
    private static final SdkField<InstanceGroupMetadata> INSTANCE_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InstanceGroup").getter(EventMetadata.getter(EventMetadata::instanceGroup)).setter(EventMetadata.setter(Builder::instanceGroup)).constructor(InstanceGroupMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceGroup").build()}).build();
    private static final SdkField<InstanceGroupScalingMetadata> INSTANCE_GROUP_SCALING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InstanceGroupScaling").getter(EventMetadata.getter(EventMetadata::instanceGroupScaling)).setter(EventMetadata.setter(Builder::instanceGroupScaling)).constructor(InstanceGroupScalingMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceGroupScaling").build()}).build();
    private static final SdkField<InstanceMetadata> INSTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Instance").getter(EventMetadata.getter(EventMetadata::instance)).setter(EventMetadata.setter(Builder::instance)).constructor(InstanceMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Instance").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_FIELD, INSTANCE_GROUP_FIELD, INSTANCE_GROUP_SCALING_FIELD, INSTANCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EventMetadata.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ClusterMetadata cluster;
    private final InstanceGroupMetadata instanceGroup;
    private final InstanceGroupScalingMetadata instanceGroupScaling;
    private final InstanceMetadata instance;
    private final Type type;

    private EventMetadata(BuilderImpl builder) {
        this.cluster = builder.cluster;
        this.instanceGroup = builder.instanceGroup;
        this.instanceGroupScaling = builder.instanceGroupScaling;
        this.instance = builder.instance;
        this.type = builder.type;
    }

    public final ClusterMetadata cluster() {
        return this.cluster;
    }

    public final InstanceGroupMetadata instanceGroup() {
        return this.instanceGroup;
    }

    public final InstanceGroupScalingMetadata instanceGroupScaling() {
        return this.instanceGroupScaling;
    }

    public final InstanceMetadata instance() {
        return this.instance;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cluster());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceGroupScaling());
        hashCode = 31 * hashCode + Objects.hashCode(this.instance());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventMetadata)) {
            return false;
        }
        EventMetadata other = (EventMetadata)obj;
        return Objects.equals(this.cluster(), other.cluster()) && Objects.equals(this.instanceGroup(), other.instanceGroup()) && Objects.equals(this.instanceGroupScaling(), other.instanceGroupScaling()) && Objects.equals(this.instance(), other.instance());
    }

    public final String toString() {
        return ToString.builder((String)"EventMetadata").add("Cluster", (Object)this.cluster()).add("InstanceGroup", (Object)this.instanceGroup()).add("InstanceGroupScaling", (Object)this.instanceGroupScaling()).add("Instance", (Object)this.instance()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Cluster": {
                return Optional.ofNullable(clazz.cast(this.cluster()));
            }
            case "InstanceGroup": {
                return Optional.ofNullable(clazz.cast(this.instanceGroup()));
            }
            case "InstanceGroupScaling": {
                return Optional.ofNullable(clazz.cast(this.instanceGroupScaling()));
            }
            case "Instance": {
                return Optional.ofNullable(clazz.cast(this.instance()));
            }
        }
        return Optional.empty();
    }

    public static EventMetadata fromCluster(ClusterMetadata cluster) {
        return (EventMetadata)EventMetadata.builder().cluster(cluster).build();
    }

    public static EventMetadata fromCluster(Consumer<ClusterMetadata.Builder> cluster) {
        ClusterMetadata.Builder builder = ClusterMetadata.builder();
        cluster.accept(builder);
        return EventMetadata.fromCluster((ClusterMetadata)builder.build());
    }

    public static EventMetadata fromInstanceGroup(InstanceGroupMetadata instanceGroup) {
        return (EventMetadata)EventMetadata.builder().instanceGroup(instanceGroup).build();
    }

    public static EventMetadata fromInstanceGroup(Consumer<InstanceGroupMetadata.Builder> instanceGroup) {
        InstanceGroupMetadata.Builder builder = InstanceGroupMetadata.builder();
        instanceGroup.accept(builder);
        return EventMetadata.fromInstanceGroup((InstanceGroupMetadata)builder.build());
    }

    public static EventMetadata fromInstanceGroupScaling(InstanceGroupScalingMetadata instanceGroupScaling) {
        return (EventMetadata)EventMetadata.builder().instanceGroupScaling(instanceGroupScaling).build();
    }

    public static EventMetadata fromInstanceGroupScaling(Consumer<InstanceGroupScalingMetadata.Builder> instanceGroupScaling) {
        InstanceGroupScalingMetadata.Builder builder = InstanceGroupScalingMetadata.builder();
        instanceGroupScaling.accept(builder);
        return EventMetadata.fromInstanceGroupScaling((InstanceGroupScalingMetadata)builder.build());
    }

    public static EventMetadata fromInstance(InstanceMetadata instance) {
        return (EventMetadata)EventMetadata.builder().instance(instance).build();
    }

    public static EventMetadata fromInstance(Consumer<InstanceMetadata.Builder> instance) {
        InstanceMetadata.Builder builder = InstanceMetadata.builder();
        instance.accept(builder);
        return EventMetadata.fromInstance((InstanceMetadata)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Cluster", CLUSTER_FIELD);
        map.put("InstanceGroup", INSTANCE_GROUP_FIELD);
        map.put("InstanceGroupScaling", INSTANCE_GROUP_SCALING_FIELD);
        map.put("Instance", INSTANCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EventMetadata, T> g) {
        return obj -> g.apply((EventMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        CLUSTER,
        INSTANCE_GROUP,
        INSTANCE_GROUP_SCALING,
        INSTANCE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private ClusterMetadata cluster;
        private InstanceGroupMetadata instanceGroup;
        private InstanceGroupScalingMetadata instanceGroupScaling;
        private InstanceMetadata instance;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(EventMetadata model) {
            this.cluster(model.cluster);
            this.instanceGroup(model.instanceGroup);
            this.instanceGroupScaling(model.instanceGroupScaling);
            this.instance(model.instance);
        }

        public final ClusterMetadata.Builder getCluster() {
            return this.cluster != null ? this.cluster.toBuilder() : null;
        }

        public final void setCluster(ClusterMetadata.BuilderImpl cluster) {
            ClusterMetadata oldValue = this.cluster;
            this.cluster = cluster != null ? cluster.build() : null;
            this.handleUnionValueChange(Type.CLUSTER, oldValue, this.cluster);
        }

        @Override
        public final Builder cluster(ClusterMetadata cluster) {
            ClusterMetadata oldValue = this.cluster;
            this.cluster = cluster;
            this.handleUnionValueChange(Type.CLUSTER, oldValue, this.cluster);
            return this;
        }

        public final InstanceGroupMetadata.Builder getInstanceGroup() {
            return this.instanceGroup != null ? this.instanceGroup.toBuilder() : null;
        }

        public final void setInstanceGroup(InstanceGroupMetadata.BuilderImpl instanceGroup) {
            InstanceGroupMetadata oldValue = this.instanceGroup;
            this.instanceGroup = instanceGroup != null ? instanceGroup.build() : null;
            this.handleUnionValueChange(Type.INSTANCE_GROUP, oldValue, this.instanceGroup);
        }

        @Override
        public final Builder instanceGroup(InstanceGroupMetadata instanceGroup) {
            InstanceGroupMetadata oldValue = this.instanceGroup;
            this.instanceGroup = instanceGroup;
            this.handleUnionValueChange(Type.INSTANCE_GROUP, oldValue, this.instanceGroup);
            return this;
        }

        public final InstanceGroupScalingMetadata.Builder getInstanceGroupScaling() {
            return this.instanceGroupScaling != null ? this.instanceGroupScaling.toBuilder() : null;
        }

        public final void setInstanceGroupScaling(InstanceGroupScalingMetadata.BuilderImpl instanceGroupScaling) {
            InstanceGroupScalingMetadata oldValue = this.instanceGroupScaling;
            this.instanceGroupScaling = instanceGroupScaling != null ? instanceGroupScaling.build() : null;
            this.handleUnionValueChange(Type.INSTANCE_GROUP_SCALING, oldValue, this.instanceGroupScaling);
        }

        @Override
        public final Builder instanceGroupScaling(InstanceGroupScalingMetadata instanceGroupScaling) {
            InstanceGroupScalingMetadata oldValue = this.instanceGroupScaling;
            this.instanceGroupScaling = instanceGroupScaling;
            this.handleUnionValueChange(Type.INSTANCE_GROUP_SCALING, oldValue, this.instanceGroupScaling);
            return this;
        }

        public final InstanceMetadata.Builder getInstance() {
            return this.instance != null ? this.instance.toBuilder() : null;
        }

        public final void setInstance(InstanceMetadata.BuilderImpl instance) {
            InstanceMetadata oldValue = this.instance;
            this.instance = instance != null ? instance.build() : null;
            this.handleUnionValueChange(Type.INSTANCE, oldValue, this.instance);
        }

        @Override
        public final Builder instance(InstanceMetadata instance) {
            InstanceMetadata oldValue = this.instance;
            this.instance = instance;
            this.handleUnionValueChange(Type.INSTANCE, oldValue, this.instance);
            return this;
        }

        public EventMetadata build() {
            return new EventMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EventMetadata> {
        public Builder cluster(ClusterMetadata var1);

        default public Builder cluster(Consumer<ClusterMetadata.Builder> cluster) {
            return this.cluster((ClusterMetadata)((ClusterMetadata.Builder)ClusterMetadata.builder().applyMutation(cluster)).build());
        }

        public Builder instanceGroup(InstanceGroupMetadata var1);

        default public Builder instanceGroup(Consumer<InstanceGroupMetadata.Builder> instanceGroup) {
            return this.instanceGroup((InstanceGroupMetadata)((InstanceGroupMetadata.Builder)InstanceGroupMetadata.builder().applyMutation(instanceGroup)).build());
        }

        public Builder instanceGroupScaling(InstanceGroupScalingMetadata var1);

        default public Builder instanceGroupScaling(Consumer<InstanceGroupScalingMetadata.Builder> instanceGroupScaling) {
            return this.instanceGroupScaling((InstanceGroupScalingMetadata)((InstanceGroupScalingMetadata.Builder)InstanceGroupScalingMetadata.builder().applyMutation(instanceGroupScaling)).build());
        }

        public Builder instance(InstanceMetadata var1);

        default public Builder instance(Consumer<InstanceMetadata.Builder> instance) {
            return this.instance((InstanceMetadata)((InstanceMetadata.Builder)InstanceMetadata.builder().applyMutation(instance)).build());
        }
    }
}

