/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.AsyncInferenceConfig;
import software.amazon.awssdk.services.sagemaker.model.DataCaptureConfigSummary;
import software.amazon.awssdk.services.sagemaker.model.DeploymentConfig;
import software.amazon.awssdk.services.sagemaker.model.EndpointStatus;
import software.amazon.awssdk.services.sagemaker.model.ExplainerConfig;
import software.amazon.awssdk.services.sagemaker.model.MetricsConfig;
import software.amazon.awssdk.services.sagemaker.model.PendingDeploymentSummary;
import software.amazon.awssdk.services.sagemaker.model.ProductionVariantSummary;
import software.amazon.awssdk.services.sagemaker.model.ProductionVariantSummaryListCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEndpointResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, DescribeEndpointResponse> {
    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointName").getter(DescribeEndpointResponse.getter(DescribeEndpointResponse::endpointName)).setter(DescribeEndpointResponse.setter(Builder::endpointName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointName").build()}).build();
    private static final SdkField<String> ENDPOINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointArn").getter(DescribeEndpointResponse.getter(DescribeEndpointResponse::endpointArn)).setter(DescribeEndpointResponse.setter(Builder::endpointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointArn").build()}).build();
    private static final SdkField<String> ENDPOINT_CONFIG_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointConfigName").getter(DescribeEndpointResponse.getter(DescribeEndpointResponse::endpointConfigName)).setter(DescribeEndpointResponse.setter(Builder::endpointConfigName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointConfigName").build()}).build();
    private static final SdkField<List<ProductionVariantSummary>> PRODUCTION_VARIANTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProductionVariants").getter(DescribeEndpointResponse.getter(DescribeEndpointResponse::productionVariants)).setter(DescribeEndpointResponse.setter(Builder::productionVariants)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductionVariants").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProductionVariantSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DataCaptureConfigSummary> DATA_CAPTURE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataCaptureConfig").getter(DescribeEndpointResponse.getter(DescribeEndpointResponse::dataCaptureConfig)).setter(DescribeEndpointResponse.setter(Builder::dataCaptureConfig)).constructor(DataCaptureConfigSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataCaptureConfig").build()}).build();
    private static final SdkField<String> ENDPOINT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointStatus").getter(DescribeEndpointResponse.getter(DescribeEndpointResponse::endpointStatusAsString)).setter(DescribeEndpointResponse.setter(Builder::endpointStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointStatus").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(DescribeEndpointResponse.getter(DescribeEndpointResponse::failureReason)).setter(DescribeEndpointResponse.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeEndpointResponse.getter(DescribeEndpointResponse::creationTime)).setter(DescribeEndpointResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(DescribeEndpointResponse.getter(DescribeEndpointResponse::lastModifiedTime)).setter(DescribeEndpointResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<DeploymentConfig> LAST_DEPLOYMENT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LastDeploymentConfig").getter(DescribeEndpointResponse.getter(DescribeEndpointResponse::lastDeploymentConfig)).setter(DescribeEndpointResponse.setter(Builder::lastDeploymentConfig)).constructor(DeploymentConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastDeploymentConfig").build()}).build();
    private static final SdkField<AsyncInferenceConfig> ASYNC_INFERENCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AsyncInferenceConfig").getter(DescribeEndpointResponse.getter(DescribeEndpointResponse::asyncInferenceConfig)).setter(DescribeEndpointResponse.setter(Builder::asyncInferenceConfig)).constructor(AsyncInferenceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AsyncInferenceConfig").build()}).build();
    private static final SdkField<PendingDeploymentSummary> PENDING_DEPLOYMENT_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PendingDeploymentSummary").getter(DescribeEndpointResponse.getter(DescribeEndpointResponse::pendingDeploymentSummary)).setter(DescribeEndpointResponse.setter(Builder::pendingDeploymentSummary)).constructor(PendingDeploymentSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PendingDeploymentSummary").build()}).build();
    private static final SdkField<ExplainerConfig> EXPLAINER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExplainerConfig").getter(DescribeEndpointResponse.getter(DescribeEndpointResponse::explainerConfig)).setter(DescribeEndpointResponse.setter(Builder::explainerConfig)).constructor(ExplainerConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExplainerConfig").build()}).build();
    private static final SdkField<List<ProductionVariantSummary>> SHADOW_PRODUCTION_VARIANTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ShadowProductionVariants").getter(DescribeEndpointResponse.getter(DescribeEndpointResponse::shadowProductionVariants)).setter(DescribeEndpointResponse.setter(Builder::shadowProductionVariants)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShadowProductionVariants").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProductionVariantSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<MetricsConfig> METRICS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MetricsConfig").getter(DescribeEndpointResponse.getter(DescribeEndpointResponse::metricsConfig)).setter(DescribeEndpointResponse.setter(Builder::metricsConfig)).constructor(MetricsConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricsConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_NAME_FIELD, ENDPOINT_ARN_FIELD, ENDPOINT_CONFIG_NAME_FIELD, PRODUCTION_VARIANTS_FIELD, DATA_CAPTURE_CONFIG_FIELD, ENDPOINT_STATUS_FIELD, FAILURE_REASON_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, LAST_DEPLOYMENT_CONFIG_FIELD, ASYNC_INFERENCE_CONFIG_FIELD, PENDING_DEPLOYMENT_SUMMARY_FIELD, EXPLAINER_CONFIG_FIELD, SHADOW_PRODUCTION_VARIANTS_FIELD, METRICS_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeEndpointResponse.memberNameToFieldInitializer();
    private final String endpointName;
    private final String endpointArn;
    private final String endpointConfigName;
    private final List<ProductionVariantSummary> productionVariants;
    private final DataCaptureConfigSummary dataCaptureConfig;
    private final String endpointStatus;
    private final String failureReason;
    private final Instant creationTime;
    private final Instant lastModifiedTime;
    private final DeploymentConfig lastDeploymentConfig;
    private final AsyncInferenceConfig asyncInferenceConfig;
    private final PendingDeploymentSummary pendingDeploymentSummary;
    private final ExplainerConfig explainerConfig;
    private final List<ProductionVariantSummary> shadowProductionVariants;
    private final MetricsConfig metricsConfig;

    private DescribeEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.endpointName = builder.endpointName;
        this.endpointArn = builder.endpointArn;
        this.endpointConfigName = builder.endpointConfigName;
        this.productionVariants = builder.productionVariants;
        this.dataCaptureConfig = builder.dataCaptureConfig;
        this.endpointStatus = builder.endpointStatus;
        this.failureReason = builder.failureReason;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastDeploymentConfig = builder.lastDeploymentConfig;
        this.asyncInferenceConfig = builder.asyncInferenceConfig;
        this.pendingDeploymentSummary = builder.pendingDeploymentSummary;
        this.explainerConfig = builder.explainerConfig;
        this.shadowProductionVariants = builder.shadowProductionVariants;
        this.metricsConfig = builder.metricsConfig;
    }

    public final String endpointName() {
        return this.endpointName;
    }

    public final String endpointArn() {
        return this.endpointArn;
    }

    public final String endpointConfigName() {
        return this.endpointConfigName;
    }

    public final boolean hasProductionVariants() {
        return this.productionVariants != null && !(this.productionVariants instanceof SdkAutoConstructList);
    }

    public final List<ProductionVariantSummary> productionVariants() {
        return this.productionVariants;
    }

    public final DataCaptureConfigSummary dataCaptureConfig() {
        return this.dataCaptureConfig;
    }

    public final EndpointStatus endpointStatus() {
        return EndpointStatus.fromValue(this.endpointStatus);
    }

    public final String endpointStatusAsString() {
        return this.endpointStatus;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final DeploymentConfig lastDeploymentConfig() {
        return this.lastDeploymentConfig;
    }

    public final AsyncInferenceConfig asyncInferenceConfig() {
        return this.asyncInferenceConfig;
    }

    public final PendingDeploymentSummary pendingDeploymentSummary() {
        return this.pendingDeploymentSummary;
    }

    public final ExplainerConfig explainerConfig() {
        return this.explainerConfig;
    }

    public final boolean hasShadowProductionVariants() {
        return this.shadowProductionVariants != null && !(this.shadowProductionVariants instanceof SdkAutoConstructList);
    }

    public final List<ProductionVariantSummary> shadowProductionVariants() {
        return this.shadowProductionVariants;
    }

    public final MetricsConfig metricsConfig() {
        return this.metricsConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProductionVariants() ? this.productionVariants() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dataCaptureConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastDeploymentConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.asyncInferenceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.pendingDeploymentSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.explainerConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasShadowProductionVariants() ? this.shadowProductionVariants() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.metricsConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEndpointResponse)) {
            return false;
        }
        DescribeEndpointResponse other = (DescribeEndpointResponse)((Object)obj);
        return Objects.equals(this.endpointName(), other.endpointName()) && Objects.equals(this.endpointArn(), other.endpointArn()) && Objects.equals(this.endpointConfigName(), other.endpointConfigName()) && this.hasProductionVariants() == other.hasProductionVariants() && Objects.equals(this.productionVariants(), other.productionVariants()) && Objects.equals(this.dataCaptureConfig(), other.dataCaptureConfig()) && Objects.equals(this.endpointStatusAsString(), other.endpointStatusAsString()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.lastDeploymentConfig(), other.lastDeploymentConfig()) && Objects.equals(this.asyncInferenceConfig(), other.asyncInferenceConfig()) && Objects.equals(this.pendingDeploymentSummary(), other.pendingDeploymentSummary()) && Objects.equals(this.explainerConfig(), other.explainerConfig()) && this.hasShadowProductionVariants() == other.hasShadowProductionVariants() && Objects.equals(this.shadowProductionVariants(), other.shadowProductionVariants()) && Objects.equals(this.metricsConfig(), other.metricsConfig());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeEndpointResponse").add("EndpointName", (Object)this.endpointName()).add("EndpointArn", (Object)this.endpointArn()).add("EndpointConfigName", (Object)this.endpointConfigName()).add("ProductionVariants", this.hasProductionVariants() ? this.productionVariants() : null).add("DataCaptureConfig", (Object)this.dataCaptureConfig()).add("EndpointStatus", (Object)this.endpointStatusAsString()).add("FailureReason", (Object)this.failureReason()).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("LastDeploymentConfig", (Object)this.lastDeploymentConfig()).add("AsyncInferenceConfig", (Object)this.asyncInferenceConfig()).add("PendingDeploymentSummary", (Object)this.pendingDeploymentSummary()).add("ExplainerConfig", (Object)this.explainerConfig()).add("ShadowProductionVariants", this.hasShadowProductionVariants() ? this.shadowProductionVariants() : null).add("MetricsConfig", (Object)this.metricsConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointName": {
                return Optional.ofNullable(clazz.cast(this.endpointName()));
            }
            case "EndpointArn": {
                return Optional.ofNullable(clazz.cast(this.endpointArn()));
            }
            case "EndpointConfigName": {
                return Optional.ofNullable(clazz.cast(this.endpointConfigName()));
            }
            case "ProductionVariants": {
                return Optional.ofNullable(clazz.cast(this.productionVariants()));
            }
            case "DataCaptureConfig": {
                return Optional.ofNullable(clazz.cast(this.dataCaptureConfig()));
            }
            case "EndpointStatus": {
                return Optional.ofNullable(clazz.cast(this.endpointStatusAsString()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "LastDeploymentConfig": {
                return Optional.ofNullable(clazz.cast(this.lastDeploymentConfig()));
            }
            case "AsyncInferenceConfig": {
                return Optional.ofNullable(clazz.cast(this.asyncInferenceConfig()));
            }
            case "PendingDeploymentSummary": {
                return Optional.ofNullable(clazz.cast(this.pendingDeploymentSummary()));
            }
            case "ExplainerConfig": {
                return Optional.ofNullable(clazz.cast(this.explainerConfig()));
            }
            case "ShadowProductionVariants": {
                return Optional.ofNullable(clazz.cast(this.shadowProductionVariants()));
            }
            case "MetricsConfig": {
                return Optional.ofNullable(clazz.cast(this.metricsConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EndpointName", ENDPOINT_NAME_FIELD);
        map.put("EndpointArn", ENDPOINT_ARN_FIELD);
        map.put("EndpointConfigName", ENDPOINT_CONFIG_NAME_FIELD);
        map.put("ProductionVariants", PRODUCTION_VARIANTS_FIELD);
        map.put("DataCaptureConfig", DATA_CAPTURE_CONFIG_FIELD);
        map.put("EndpointStatus", ENDPOINT_STATUS_FIELD);
        map.put("FailureReason", FAILURE_REASON_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("LastDeploymentConfig", LAST_DEPLOYMENT_CONFIG_FIELD);
        map.put("AsyncInferenceConfig", ASYNC_INFERENCE_CONFIG_FIELD);
        map.put("PendingDeploymentSummary", PENDING_DEPLOYMENT_SUMMARY_FIELD);
        map.put("ExplainerConfig", EXPLAINER_CONFIG_FIELD);
        map.put("ShadowProductionVariants", SHADOW_PRODUCTION_VARIANTS_FIELD);
        map.put("MetricsConfig", METRICS_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeEndpointResponse, T> g) {
        return obj -> g.apply((DescribeEndpointResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String endpointName;
        private String endpointArn;
        private String endpointConfigName;
        private List<ProductionVariantSummary> productionVariants = DefaultSdkAutoConstructList.getInstance();
        private DataCaptureConfigSummary dataCaptureConfig;
        private String endpointStatus;
        private String failureReason;
        private Instant creationTime;
        private Instant lastModifiedTime;
        private DeploymentConfig lastDeploymentConfig;
        private AsyncInferenceConfig asyncInferenceConfig;
        private PendingDeploymentSummary pendingDeploymentSummary;
        private ExplainerConfig explainerConfig;
        private List<ProductionVariantSummary> shadowProductionVariants = DefaultSdkAutoConstructList.getInstance();
        private MetricsConfig metricsConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEndpointResponse model) {
            super(model);
            this.endpointName(model.endpointName);
            this.endpointArn(model.endpointArn);
            this.endpointConfigName(model.endpointConfigName);
            this.productionVariants(model.productionVariants);
            this.dataCaptureConfig(model.dataCaptureConfig);
            this.endpointStatus(model.endpointStatus);
            this.failureReason(model.failureReason);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.lastDeploymentConfig(model.lastDeploymentConfig);
            this.asyncInferenceConfig(model.asyncInferenceConfig);
            this.pendingDeploymentSummary(model.pendingDeploymentSummary);
            this.explainerConfig(model.explainerConfig);
            this.shadowProductionVariants(model.shadowProductionVariants);
            this.metricsConfig(model.metricsConfig);
        }

        public final String getEndpointName() {
            return this.endpointName;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final String getEndpointArn() {
            return this.endpointArn;
        }

        public final void setEndpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
        }

        @Override
        public final Builder endpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
            return this;
        }

        public final String getEndpointConfigName() {
            return this.endpointConfigName;
        }

        public final void setEndpointConfigName(String endpointConfigName) {
            this.endpointConfigName = endpointConfigName;
        }

        @Override
        public final Builder endpointConfigName(String endpointConfigName) {
            this.endpointConfigName = endpointConfigName;
            return this;
        }

        public final List<ProductionVariantSummary.Builder> getProductionVariants() {
            List<ProductionVariantSummary.Builder> result = ProductionVariantSummaryListCopier.copyToBuilder(this.productionVariants);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProductionVariants(Collection<ProductionVariantSummary.BuilderImpl> productionVariants) {
            this.productionVariants = ProductionVariantSummaryListCopier.copyFromBuilder(productionVariants);
        }

        @Override
        public final Builder productionVariants(Collection<ProductionVariantSummary> productionVariants) {
            this.productionVariants = ProductionVariantSummaryListCopier.copy(productionVariants);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productionVariants(ProductionVariantSummary ... productionVariants) {
            this.productionVariants(Arrays.asList(productionVariants));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productionVariants(Consumer<ProductionVariantSummary.Builder> ... productionVariants) {
            this.productionVariants(Stream.of(productionVariants).map(c -> (ProductionVariantSummary)((ProductionVariantSummary.Builder)ProductionVariantSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final DataCaptureConfigSummary.Builder getDataCaptureConfig() {
            return this.dataCaptureConfig != null ? this.dataCaptureConfig.toBuilder() : null;
        }

        public final void setDataCaptureConfig(DataCaptureConfigSummary.BuilderImpl dataCaptureConfig) {
            this.dataCaptureConfig = dataCaptureConfig != null ? dataCaptureConfig.build() : null;
        }

        @Override
        public final Builder dataCaptureConfig(DataCaptureConfigSummary dataCaptureConfig) {
            this.dataCaptureConfig = dataCaptureConfig;
            return this;
        }

        public final String getEndpointStatus() {
            return this.endpointStatus;
        }

        public final void setEndpointStatus(String endpointStatus) {
            this.endpointStatus = endpointStatus;
        }

        @Override
        public final Builder endpointStatus(String endpointStatus) {
            this.endpointStatus = endpointStatus;
            return this;
        }

        @Override
        public final Builder endpointStatus(EndpointStatus endpointStatus) {
            this.endpointStatus(endpointStatus == null ? null : endpointStatus.toString());
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final DeploymentConfig.Builder getLastDeploymentConfig() {
            return this.lastDeploymentConfig != null ? this.lastDeploymentConfig.toBuilder() : null;
        }

        public final void setLastDeploymentConfig(DeploymentConfig.BuilderImpl lastDeploymentConfig) {
            this.lastDeploymentConfig = lastDeploymentConfig != null ? lastDeploymentConfig.build() : null;
        }

        @Override
        public final Builder lastDeploymentConfig(DeploymentConfig lastDeploymentConfig) {
            this.lastDeploymentConfig = lastDeploymentConfig;
            return this;
        }

        public final AsyncInferenceConfig.Builder getAsyncInferenceConfig() {
            return this.asyncInferenceConfig != null ? this.asyncInferenceConfig.toBuilder() : null;
        }

        public final void setAsyncInferenceConfig(AsyncInferenceConfig.BuilderImpl asyncInferenceConfig) {
            this.asyncInferenceConfig = asyncInferenceConfig != null ? asyncInferenceConfig.build() : null;
        }

        @Override
        public final Builder asyncInferenceConfig(AsyncInferenceConfig asyncInferenceConfig) {
            this.asyncInferenceConfig = asyncInferenceConfig;
            return this;
        }

        public final PendingDeploymentSummary.Builder getPendingDeploymentSummary() {
            return this.pendingDeploymentSummary != null ? this.pendingDeploymentSummary.toBuilder() : null;
        }

        public final void setPendingDeploymentSummary(PendingDeploymentSummary.BuilderImpl pendingDeploymentSummary) {
            this.pendingDeploymentSummary = pendingDeploymentSummary != null ? pendingDeploymentSummary.build() : null;
        }

        @Override
        public final Builder pendingDeploymentSummary(PendingDeploymentSummary pendingDeploymentSummary) {
            this.pendingDeploymentSummary = pendingDeploymentSummary;
            return this;
        }

        public final ExplainerConfig.Builder getExplainerConfig() {
            return this.explainerConfig != null ? this.explainerConfig.toBuilder() : null;
        }

        public final void setExplainerConfig(ExplainerConfig.BuilderImpl explainerConfig) {
            this.explainerConfig = explainerConfig != null ? explainerConfig.build() : null;
        }

        @Override
        public final Builder explainerConfig(ExplainerConfig explainerConfig) {
            this.explainerConfig = explainerConfig;
            return this;
        }

        public final List<ProductionVariantSummary.Builder> getShadowProductionVariants() {
            List<ProductionVariantSummary.Builder> result = ProductionVariantSummaryListCopier.copyToBuilder(this.shadowProductionVariants);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setShadowProductionVariants(Collection<ProductionVariantSummary.BuilderImpl> shadowProductionVariants) {
            this.shadowProductionVariants = ProductionVariantSummaryListCopier.copyFromBuilder(shadowProductionVariants);
        }

        @Override
        public final Builder shadowProductionVariants(Collection<ProductionVariantSummary> shadowProductionVariants) {
            this.shadowProductionVariants = ProductionVariantSummaryListCopier.copy(shadowProductionVariants);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shadowProductionVariants(ProductionVariantSummary ... shadowProductionVariants) {
            this.shadowProductionVariants(Arrays.asList(shadowProductionVariants));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shadowProductionVariants(Consumer<ProductionVariantSummary.Builder> ... shadowProductionVariants) {
            this.shadowProductionVariants(Stream.of(shadowProductionVariants).map(c -> (ProductionVariantSummary)((ProductionVariantSummary.Builder)ProductionVariantSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final MetricsConfig.Builder getMetricsConfig() {
            return this.metricsConfig != null ? this.metricsConfig.toBuilder() : null;
        }

        public final void setMetricsConfig(MetricsConfig.BuilderImpl metricsConfig) {
            this.metricsConfig = metricsConfig != null ? metricsConfig.build() : null;
        }

        @Override
        public final Builder metricsConfig(MetricsConfig metricsConfig) {
            this.metricsConfig = metricsConfig;
            return this;
        }

        @Override
        public DescribeEndpointResponse build() {
            return new DescribeEndpointResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeEndpointResponse> {
        public Builder endpointName(String var1);

        public Builder endpointArn(String var1);

        public Builder endpointConfigName(String var1);

        public Builder productionVariants(Collection<ProductionVariantSummary> var1);

        public Builder productionVariants(ProductionVariantSummary ... var1);

        public Builder productionVariants(Consumer<ProductionVariantSummary.Builder> ... var1);

        public Builder dataCaptureConfig(DataCaptureConfigSummary var1);

        default public Builder dataCaptureConfig(Consumer<DataCaptureConfigSummary.Builder> dataCaptureConfig) {
            return this.dataCaptureConfig((DataCaptureConfigSummary)((DataCaptureConfigSummary.Builder)DataCaptureConfigSummary.builder().applyMutation(dataCaptureConfig)).build());
        }

        public Builder endpointStatus(String var1);

        public Builder endpointStatus(EndpointStatus var1);

        public Builder failureReason(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder lastDeploymentConfig(DeploymentConfig var1);

        default public Builder lastDeploymentConfig(Consumer<DeploymentConfig.Builder> lastDeploymentConfig) {
            return this.lastDeploymentConfig((DeploymentConfig)((DeploymentConfig.Builder)DeploymentConfig.builder().applyMutation(lastDeploymentConfig)).build());
        }

        public Builder asyncInferenceConfig(AsyncInferenceConfig var1);

        default public Builder asyncInferenceConfig(Consumer<AsyncInferenceConfig.Builder> asyncInferenceConfig) {
            return this.asyncInferenceConfig((AsyncInferenceConfig)((AsyncInferenceConfig.Builder)AsyncInferenceConfig.builder().applyMutation(asyncInferenceConfig)).build());
        }

        public Builder pendingDeploymentSummary(PendingDeploymentSummary var1);

        default public Builder pendingDeploymentSummary(Consumer<PendingDeploymentSummary.Builder> pendingDeploymentSummary) {
            return this.pendingDeploymentSummary((PendingDeploymentSummary)((PendingDeploymentSummary.Builder)PendingDeploymentSummary.builder().applyMutation(pendingDeploymentSummary)).build());
        }

        public Builder explainerConfig(ExplainerConfig var1);

        default public Builder explainerConfig(Consumer<ExplainerConfig.Builder> explainerConfig) {
            return this.explainerConfig((ExplainerConfig)((ExplainerConfig.Builder)ExplainerConfig.builder().applyMutation(explainerConfig)).build());
        }

        public Builder shadowProductionVariants(Collection<ProductionVariantSummary> var1);

        public Builder shadowProductionVariants(ProductionVariantSummary ... var1);

        public Builder shadowProductionVariants(Consumer<ProductionVariantSummary.Builder> ... var1);

        public Builder metricsConfig(MetricsConfig var1);

        default public Builder metricsConfig(Consumer<MetricsConfig.Builder> metricsConfig) {
            return this.metricsConfig((MetricsConfig)((MetricsConfig.Builder)MetricsConfig.builder().applyMutation(metricsConfig)).build());
        }
    }
}

