/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.AdditionalCodeRepositoryNamesOrUrlsCopier;
import software.amazon.awssdk.services.sagemaker.model.DirectInternetAccess;
import software.amazon.awssdk.services.sagemaker.model.IPAddressType;
import software.amazon.awssdk.services.sagemaker.model.InstanceMetadataServiceConfiguration;
import software.amazon.awssdk.services.sagemaker.model.InstanceType;
import software.amazon.awssdk.services.sagemaker.model.NotebookInstanceAcceleratorType;
import software.amazon.awssdk.services.sagemaker.model.NotebookInstanceAcceleratorTypesCopier;
import software.amazon.awssdk.services.sagemaker.model.RootAccess;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.SecurityGroupIdsCopier;
import software.amazon.awssdk.services.sagemaker.model.Tag;
import software.amazon.awssdk.services.sagemaker.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateNotebookInstanceRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, CreateNotebookInstanceRequest> {
    private static final SdkField<String> NOTEBOOK_INSTANCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NotebookInstanceName").getter(CreateNotebookInstanceRequest.getter(CreateNotebookInstanceRequest::notebookInstanceName)).setter(CreateNotebookInstanceRequest.setter(Builder::notebookInstanceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookInstanceName").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(CreateNotebookInstanceRequest.getter(CreateNotebookInstanceRequest::instanceTypeAsString)).setter(CreateNotebookInstanceRequest.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetId").getter(CreateNotebookInstanceRequest.getter(CreateNotebookInstanceRequest::subnetId)).setter(CreateNotebookInstanceRequest.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroupIds").getter(CreateNotebookInstanceRequest.getter(CreateNotebookInstanceRequest::securityGroupIds)).setter(CreateNotebookInstanceRequest.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> IP_ADDRESS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpAddressType").getter(CreateNotebookInstanceRequest.getter(CreateNotebookInstanceRequest::ipAddressTypeAsString)).setter(CreateNotebookInstanceRequest.setter(Builder::ipAddressType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddressType").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(CreateNotebookInstanceRequest.getter(CreateNotebookInstanceRequest::roleArn)).setter(CreateNotebookInstanceRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(CreateNotebookInstanceRequest.getter(CreateNotebookInstanceRequest::kmsKeyId)).setter(CreateNotebookInstanceRequest.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateNotebookInstanceRequest.getter(CreateNotebookInstanceRequest::tags)).setter(CreateNotebookInstanceRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LIFECYCLE_CONFIG_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LifecycleConfigName").getter(CreateNotebookInstanceRequest.getter(CreateNotebookInstanceRequest::lifecycleConfigName)).setter(CreateNotebookInstanceRequest.setter(Builder::lifecycleConfigName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifecycleConfigName").build()}).build();
    private static final SdkField<String> DIRECT_INTERNET_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectInternetAccess").getter(CreateNotebookInstanceRequest.getter(CreateNotebookInstanceRequest::directInternetAccessAsString)).setter(CreateNotebookInstanceRequest.setter(Builder::directInternetAccess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectInternetAccess").build()}).build();
    private static final SdkField<Integer> VOLUME_SIZE_IN_GB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("VolumeSizeInGB").getter(CreateNotebookInstanceRequest.getter(CreateNotebookInstanceRequest::volumeSizeInGB)).setter(CreateNotebookInstanceRequest.setter(Builder::volumeSizeInGB)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeSizeInGB").build()}).build();
    private static final SdkField<List<String>> ACCELERATOR_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AcceleratorTypes").getter(CreateNotebookInstanceRequest.getter(CreateNotebookInstanceRequest::acceleratorTypesAsStrings)).setter(CreateNotebookInstanceRequest.setter(Builder::acceleratorTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceleratorTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DEFAULT_CODE_REPOSITORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultCodeRepository").getter(CreateNotebookInstanceRequest.getter(CreateNotebookInstanceRequest::defaultCodeRepository)).setter(CreateNotebookInstanceRequest.setter(Builder::defaultCodeRepository)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultCodeRepository").build()}).build();
    private static final SdkField<List<String>> ADDITIONAL_CODE_REPOSITORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdditionalCodeRepositories").getter(CreateNotebookInstanceRequest.getter(CreateNotebookInstanceRequest::additionalCodeRepositories)).setter(CreateNotebookInstanceRequest.setter(Builder::additionalCodeRepositories)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalCodeRepositories").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ROOT_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RootAccess").getter(CreateNotebookInstanceRequest.getter(CreateNotebookInstanceRequest::rootAccessAsString)).setter(CreateNotebookInstanceRequest.setter(Builder::rootAccess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootAccess").build()}).build();
    private static final SdkField<String> PLATFORM_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlatformIdentifier").getter(CreateNotebookInstanceRequest.getter(CreateNotebookInstanceRequest::platformIdentifier)).setter(CreateNotebookInstanceRequest.setter(Builder::platformIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformIdentifier").build()}).build();
    private static final SdkField<InstanceMetadataServiceConfiguration> INSTANCE_METADATA_SERVICE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InstanceMetadataServiceConfiguration").getter(CreateNotebookInstanceRequest.getter(CreateNotebookInstanceRequest::instanceMetadataServiceConfiguration)).setter(CreateNotebookInstanceRequest.setter(Builder::instanceMetadataServiceConfiguration)).constructor(InstanceMetadataServiceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceMetadataServiceConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTEBOOK_INSTANCE_NAME_FIELD, INSTANCE_TYPE_FIELD, SUBNET_ID_FIELD, SECURITY_GROUP_IDS_FIELD, IP_ADDRESS_TYPE_FIELD, ROLE_ARN_FIELD, KMS_KEY_ID_FIELD, TAGS_FIELD, LIFECYCLE_CONFIG_NAME_FIELD, DIRECT_INTERNET_ACCESS_FIELD, VOLUME_SIZE_IN_GB_FIELD, ACCELERATOR_TYPES_FIELD, DEFAULT_CODE_REPOSITORY_FIELD, ADDITIONAL_CODE_REPOSITORIES_FIELD, ROOT_ACCESS_FIELD, PLATFORM_IDENTIFIER_FIELD, INSTANCE_METADATA_SERVICE_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateNotebookInstanceRequest.memberNameToFieldInitializer();
    private final String notebookInstanceName;
    private final String instanceType;
    private final String subnetId;
    private final List<String> securityGroupIds;
    private final String ipAddressType;
    private final String roleArn;
    private final String kmsKeyId;
    private final List<Tag> tags;
    private final String lifecycleConfigName;
    private final String directInternetAccess;
    private final Integer volumeSizeInGB;
    private final List<String> acceleratorTypes;
    private final String defaultCodeRepository;
    private final List<String> additionalCodeRepositories;
    private final String rootAccess;
    private final String platformIdentifier;
    private final InstanceMetadataServiceConfiguration instanceMetadataServiceConfiguration;

    private CreateNotebookInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.notebookInstanceName = builder.notebookInstanceName;
        this.instanceType = builder.instanceType;
        this.subnetId = builder.subnetId;
        this.securityGroupIds = builder.securityGroupIds;
        this.ipAddressType = builder.ipAddressType;
        this.roleArn = builder.roleArn;
        this.kmsKeyId = builder.kmsKeyId;
        this.tags = builder.tags;
        this.lifecycleConfigName = builder.lifecycleConfigName;
        this.directInternetAccess = builder.directInternetAccess;
        this.volumeSizeInGB = builder.volumeSizeInGB;
        this.acceleratorTypes = builder.acceleratorTypes;
        this.defaultCodeRepository = builder.defaultCodeRepository;
        this.additionalCodeRepositories = builder.additionalCodeRepositories;
        this.rootAccess = builder.rootAccess;
        this.platformIdentifier = builder.platformIdentifier;
        this.instanceMetadataServiceConfiguration = builder.instanceMetadataServiceConfiguration;
    }

    public final String notebookInstanceName() {
        return this.notebookInstanceName;
    }

    public final InstanceType instanceType() {
        return InstanceType.fromValue(this.instanceType);
    }

    public final String instanceTypeAsString() {
        return this.instanceType;
    }

    public final String subnetId() {
        return this.subnetId;
    }

    public final boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public final IPAddressType ipAddressType() {
        return IPAddressType.fromValue(this.ipAddressType);
    }

    public final String ipAddressTypeAsString() {
        return this.ipAddressType;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String lifecycleConfigName() {
        return this.lifecycleConfigName;
    }

    public final DirectInternetAccess directInternetAccess() {
        return DirectInternetAccess.fromValue(this.directInternetAccess);
    }

    public final String directInternetAccessAsString() {
        return this.directInternetAccess;
    }

    public final Integer volumeSizeInGB() {
        return this.volumeSizeInGB;
    }

    public final List<NotebookInstanceAcceleratorType> acceleratorTypes() {
        return NotebookInstanceAcceleratorTypesCopier.copyStringToEnum(this.acceleratorTypes);
    }

    public final boolean hasAcceleratorTypes() {
        return this.acceleratorTypes != null && !(this.acceleratorTypes instanceof SdkAutoConstructList);
    }

    public final List<String> acceleratorTypesAsStrings() {
        return this.acceleratorTypes;
    }

    public final String defaultCodeRepository() {
        return this.defaultCodeRepository;
    }

    public final boolean hasAdditionalCodeRepositories() {
        return this.additionalCodeRepositories != null && !(this.additionalCodeRepositories instanceof SdkAutoConstructList);
    }

    public final List<String> additionalCodeRepositories() {
        return this.additionalCodeRepositories;
    }

    public final RootAccess rootAccess() {
        return RootAccess.fromValue(this.rootAccess);
    }

    public final String rootAccessAsString() {
        return this.rootAccess;
    }

    public final String platformIdentifier() {
        return this.platformIdentifier;
    }

    public final InstanceMetadataServiceConfiguration instanceMetadataServiceConfiguration() {
        return this.instanceMetadataServiceConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.notebookInstanceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupIds() ? this.securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddressTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(this.directInternetAccessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeSizeInGB());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAcceleratorTypes() ? this.acceleratorTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultCodeRepository());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalCodeRepositories() ? this.additionalCodeRepositories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.rootAccessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceMetadataServiceConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNotebookInstanceRequest)) {
            return false;
        }
        CreateNotebookInstanceRequest other = (CreateNotebookInstanceRequest)((Object)obj);
        return Objects.equals(this.notebookInstanceName(), other.notebookInstanceName()) && Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.subnetId(), other.subnetId()) && this.hasSecurityGroupIds() == other.hasSecurityGroupIds() && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && Objects.equals(this.ipAddressTypeAsString(), other.ipAddressTypeAsString()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.lifecycleConfigName(), other.lifecycleConfigName()) && Objects.equals(this.directInternetAccessAsString(), other.directInternetAccessAsString()) && Objects.equals(this.volumeSizeInGB(), other.volumeSizeInGB()) && this.hasAcceleratorTypes() == other.hasAcceleratorTypes() && Objects.equals(this.acceleratorTypesAsStrings(), other.acceleratorTypesAsStrings()) && Objects.equals(this.defaultCodeRepository(), other.defaultCodeRepository()) && this.hasAdditionalCodeRepositories() == other.hasAdditionalCodeRepositories() && Objects.equals(this.additionalCodeRepositories(), other.additionalCodeRepositories()) && Objects.equals(this.rootAccessAsString(), other.rootAccessAsString()) && Objects.equals(this.platformIdentifier(), other.platformIdentifier()) && Objects.equals(this.instanceMetadataServiceConfiguration(), other.instanceMetadataServiceConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"CreateNotebookInstanceRequest").add("NotebookInstanceName", (Object)this.notebookInstanceName()).add("InstanceType", (Object)this.instanceTypeAsString()).add("SubnetId", (Object)this.subnetId()).add("SecurityGroupIds", this.hasSecurityGroupIds() ? this.securityGroupIds() : null).add("IpAddressType", (Object)this.ipAddressTypeAsString()).add("RoleArn", (Object)this.roleArn()).add("KmsKeyId", (Object)this.kmsKeyId()).add("Tags", this.hasTags() ? this.tags() : null).add("LifecycleConfigName", (Object)this.lifecycleConfigName()).add("DirectInternetAccess", (Object)this.directInternetAccessAsString()).add("VolumeSizeInGB", (Object)this.volumeSizeInGB()).add("AcceleratorTypes", this.hasAcceleratorTypes() ? this.acceleratorTypesAsStrings() : null).add("DefaultCodeRepository", (Object)this.defaultCodeRepository()).add("AdditionalCodeRepositories", this.hasAdditionalCodeRepositories() ? this.additionalCodeRepositories() : null).add("RootAccess", (Object)this.rootAccessAsString()).add("PlatformIdentifier", (Object)this.platformIdentifier()).add("InstanceMetadataServiceConfiguration", (Object)this.instanceMetadataServiceConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NotebookInstanceName": {
                return Optional.ofNullable(clazz.cast(this.notebookInstanceName()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "SecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "IpAddressType": {
                return Optional.ofNullable(clazz.cast(this.ipAddressTypeAsString()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "LifecycleConfigName": {
                return Optional.ofNullable(clazz.cast(this.lifecycleConfigName()));
            }
            case "DirectInternetAccess": {
                return Optional.ofNullable(clazz.cast(this.directInternetAccessAsString()));
            }
            case "VolumeSizeInGB": {
                return Optional.ofNullable(clazz.cast(this.volumeSizeInGB()));
            }
            case "AcceleratorTypes": {
                return Optional.ofNullable(clazz.cast(this.acceleratorTypesAsStrings()));
            }
            case "DefaultCodeRepository": {
                return Optional.ofNullable(clazz.cast(this.defaultCodeRepository()));
            }
            case "AdditionalCodeRepositories": {
                return Optional.ofNullable(clazz.cast(this.additionalCodeRepositories()));
            }
            case "RootAccess": {
                return Optional.ofNullable(clazz.cast(this.rootAccessAsString()));
            }
            case "PlatformIdentifier": {
                return Optional.ofNullable(clazz.cast(this.platformIdentifier()));
            }
            case "InstanceMetadataServiceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.instanceMetadataServiceConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NotebookInstanceName", NOTEBOOK_INSTANCE_NAME_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("SubnetId", SUBNET_ID_FIELD);
        map.put("SecurityGroupIds", SECURITY_GROUP_IDS_FIELD);
        map.put("IpAddressType", IP_ADDRESS_TYPE_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("LifecycleConfigName", LIFECYCLE_CONFIG_NAME_FIELD);
        map.put("DirectInternetAccess", DIRECT_INTERNET_ACCESS_FIELD);
        map.put("VolumeSizeInGB", VOLUME_SIZE_IN_GB_FIELD);
        map.put("AcceleratorTypes", ACCELERATOR_TYPES_FIELD);
        map.put("DefaultCodeRepository", DEFAULT_CODE_REPOSITORY_FIELD);
        map.put("AdditionalCodeRepositories", ADDITIONAL_CODE_REPOSITORIES_FIELD);
        map.put("RootAccess", ROOT_ACCESS_FIELD);
        map.put("PlatformIdentifier", PLATFORM_IDENTIFIER_FIELD);
        map.put("InstanceMetadataServiceConfiguration", INSTANCE_METADATA_SERVICE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateNotebookInstanceRequest, T> g) {
        return obj -> g.apply((CreateNotebookInstanceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String notebookInstanceName;
        private String instanceType;
        private String subnetId;
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private String ipAddressType;
        private String roleArn;
        private String kmsKeyId;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String lifecycleConfigName;
        private String directInternetAccess;
        private Integer volumeSizeInGB;
        private List<String> acceleratorTypes = DefaultSdkAutoConstructList.getInstance();
        private String defaultCodeRepository;
        private List<String> additionalCodeRepositories = DefaultSdkAutoConstructList.getInstance();
        private String rootAccess;
        private String platformIdentifier;
        private InstanceMetadataServiceConfiguration instanceMetadataServiceConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNotebookInstanceRequest model) {
            super(model);
            this.notebookInstanceName(model.notebookInstanceName);
            this.instanceType(model.instanceType);
            this.subnetId(model.subnetId);
            this.securityGroupIds(model.securityGroupIds);
            this.ipAddressType(model.ipAddressType);
            this.roleArn(model.roleArn);
            this.kmsKeyId(model.kmsKeyId);
            this.tags(model.tags);
            this.lifecycleConfigName(model.lifecycleConfigName);
            this.directInternetAccess(model.directInternetAccess);
            this.volumeSizeInGB(model.volumeSizeInGB);
            this.acceleratorTypesWithStrings(model.acceleratorTypes);
            this.defaultCodeRepository(model.defaultCodeRepository);
            this.additionalCodeRepositories(model.additionalCodeRepositories);
            this.rootAccess(model.rootAccess);
            this.platformIdentifier(model.platformIdentifier);
            this.instanceMetadataServiceConfiguration(model.instanceMetadataServiceConfiguration);
        }

        public final String getNotebookInstanceName() {
            return this.notebookInstanceName;
        }

        public final void setNotebookInstanceName(String notebookInstanceName) {
            this.notebookInstanceName = notebookInstanceName;
        }

        @Override
        public final Builder notebookInstanceName(String notebookInstanceName) {
            this.notebookInstanceName = notebookInstanceName;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (this.securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final String getIpAddressType() {
            return this.ipAddressType;
        }

        public final void setIpAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
        }

        @Override
        public final Builder ipAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        @Override
        public final Builder ipAddressType(IPAddressType ipAddressType) {
            this.ipAddressType(ipAddressType == null ? null : ipAddressType.toString());
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getLifecycleConfigName() {
            return this.lifecycleConfigName;
        }

        public final void setLifecycleConfigName(String lifecycleConfigName) {
            this.lifecycleConfigName = lifecycleConfigName;
        }

        @Override
        public final Builder lifecycleConfigName(String lifecycleConfigName) {
            this.lifecycleConfigName = lifecycleConfigName;
            return this;
        }

        public final String getDirectInternetAccess() {
            return this.directInternetAccess;
        }

        public final void setDirectInternetAccess(String directInternetAccess) {
            this.directInternetAccess = directInternetAccess;
        }

        @Override
        public final Builder directInternetAccess(String directInternetAccess) {
            this.directInternetAccess = directInternetAccess;
            return this;
        }

        @Override
        public final Builder directInternetAccess(DirectInternetAccess directInternetAccess) {
            this.directInternetAccess(directInternetAccess == null ? null : directInternetAccess.toString());
            return this;
        }

        public final Integer getVolumeSizeInGB() {
            return this.volumeSizeInGB;
        }

        public final void setVolumeSizeInGB(Integer volumeSizeInGB) {
            this.volumeSizeInGB = volumeSizeInGB;
        }

        @Override
        public final Builder volumeSizeInGB(Integer volumeSizeInGB) {
            this.volumeSizeInGB = volumeSizeInGB;
            return this;
        }

        public final Collection<String> getAcceleratorTypes() {
            if (this.acceleratorTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.acceleratorTypes;
        }

        public final void setAcceleratorTypes(Collection<String> acceleratorTypes) {
            this.acceleratorTypes = NotebookInstanceAcceleratorTypesCopier.copy(acceleratorTypes);
        }

        @Override
        public final Builder acceleratorTypesWithStrings(Collection<String> acceleratorTypes) {
            this.acceleratorTypes = NotebookInstanceAcceleratorTypesCopier.copy(acceleratorTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acceleratorTypesWithStrings(String ... acceleratorTypes) {
            this.acceleratorTypesWithStrings(Arrays.asList(acceleratorTypes));
            return this;
        }

        @Override
        public final Builder acceleratorTypes(Collection<NotebookInstanceAcceleratorType> acceleratorTypes) {
            this.acceleratorTypes = NotebookInstanceAcceleratorTypesCopier.copyEnumToString(acceleratorTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acceleratorTypes(NotebookInstanceAcceleratorType ... acceleratorTypes) {
            this.acceleratorTypes(Arrays.asList(acceleratorTypes));
            return this;
        }

        public final String getDefaultCodeRepository() {
            return this.defaultCodeRepository;
        }

        public final void setDefaultCodeRepository(String defaultCodeRepository) {
            this.defaultCodeRepository = defaultCodeRepository;
        }

        @Override
        public final Builder defaultCodeRepository(String defaultCodeRepository) {
            this.defaultCodeRepository = defaultCodeRepository;
            return this;
        }

        public final Collection<String> getAdditionalCodeRepositories() {
            if (this.additionalCodeRepositories instanceof SdkAutoConstructList) {
                return null;
            }
            return this.additionalCodeRepositories;
        }

        public final void setAdditionalCodeRepositories(Collection<String> additionalCodeRepositories) {
            this.additionalCodeRepositories = AdditionalCodeRepositoryNamesOrUrlsCopier.copy(additionalCodeRepositories);
        }

        @Override
        public final Builder additionalCodeRepositories(Collection<String> additionalCodeRepositories) {
            this.additionalCodeRepositories = AdditionalCodeRepositoryNamesOrUrlsCopier.copy(additionalCodeRepositories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalCodeRepositories(String ... additionalCodeRepositories) {
            this.additionalCodeRepositories(Arrays.asList(additionalCodeRepositories));
            return this;
        }

        public final String getRootAccess() {
            return this.rootAccess;
        }

        public final void setRootAccess(String rootAccess) {
            this.rootAccess = rootAccess;
        }

        @Override
        public final Builder rootAccess(String rootAccess) {
            this.rootAccess = rootAccess;
            return this;
        }

        @Override
        public final Builder rootAccess(RootAccess rootAccess) {
            this.rootAccess(rootAccess == null ? null : rootAccess.toString());
            return this;
        }

        public final String getPlatformIdentifier() {
            return this.platformIdentifier;
        }

        public final void setPlatformIdentifier(String platformIdentifier) {
            this.platformIdentifier = platformIdentifier;
        }

        @Override
        public final Builder platformIdentifier(String platformIdentifier) {
            this.platformIdentifier = platformIdentifier;
            return this;
        }

        public final InstanceMetadataServiceConfiguration.Builder getInstanceMetadataServiceConfiguration() {
            return this.instanceMetadataServiceConfiguration != null ? this.instanceMetadataServiceConfiguration.toBuilder() : null;
        }

        public final void setInstanceMetadataServiceConfiguration(InstanceMetadataServiceConfiguration.BuilderImpl instanceMetadataServiceConfiguration) {
            this.instanceMetadataServiceConfiguration = instanceMetadataServiceConfiguration != null ? instanceMetadataServiceConfiguration.build() : null;
        }

        @Override
        public final Builder instanceMetadataServiceConfiguration(InstanceMetadataServiceConfiguration instanceMetadataServiceConfiguration) {
            this.instanceMetadataServiceConfiguration = instanceMetadataServiceConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateNotebookInstanceRequest build() {
            return new CreateNotebookInstanceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateNotebookInstanceRequest> {
        public Builder notebookInstanceName(String var1);

        public Builder instanceType(String var1);

        public Builder instanceType(InstanceType var1);

        public Builder subnetId(String var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder ipAddressType(String var1);

        public Builder ipAddressType(IPAddressType var1);

        public Builder roleArn(String var1);

        public Builder kmsKeyId(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder lifecycleConfigName(String var1);

        public Builder directInternetAccess(String var1);

        public Builder directInternetAccess(DirectInternetAccess var1);

        public Builder volumeSizeInGB(Integer var1);

        public Builder acceleratorTypesWithStrings(Collection<String> var1);

        public Builder acceleratorTypesWithStrings(String ... var1);

        public Builder acceleratorTypes(Collection<NotebookInstanceAcceleratorType> var1);

        public Builder acceleratorTypes(NotebookInstanceAcceleratorType ... var1);

        public Builder defaultCodeRepository(String var1);

        public Builder additionalCodeRepositories(Collection<String> var1);

        public Builder additionalCodeRepositories(String ... var1);

        public Builder rootAccess(String var1);

        public Builder rootAccess(RootAccess var1);

        public Builder platformIdentifier(String var1);

        public Builder instanceMetadataServiceConfiguration(InstanceMetadataServiceConfiguration var1);

        default public Builder instanceMetadataServiceConfiguration(Consumer<InstanceMetadataServiceConfiguration.Builder> instanceMetadataServiceConfiguration) {
            return this.instanceMetadataServiceConfiguration((InstanceMetadataServiceConfiguration)((InstanceMetadataServiceConfiguration.Builder)InstanceMetadataServiceConfiguration.builder().applyMutation(instanceMetadataServiceConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

