/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sagemaker.model.ClusterKubernetesLabelsCopier;
import software.amazon.awssdk.services.sagemaker.model.ClusterKubernetesTaint;
import software.amazon.awssdk.services.sagemaker.model.ClusterKubernetesTaintsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClusterKubernetesConfigDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClusterKubernetesConfigDetails> {
    private static final SdkField<Map<String, String>> CURRENT_LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("CurrentLabels").getter(ClusterKubernetesConfigDetails.getter(ClusterKubernetesConfigDetails::currentLabels)).setter(ClusterKubernetesConfigDetails.setter(Builder::currentLabels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentLabels").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> DESIRED_LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("DesiredLabels").getter(ClusterKubernetesConfigDetails.getter(ClusterKubernetesConfigDetails::desiredLabels)).setter(ClusterKubernetesConfigDetails.setter(Builder::desiredLabels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredLabels").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<ClusterKubernetesTaint>> CURRENT_TAINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CurrentTaints").getter(ClusterKubernetesConfigDetails.getter(ClusterKubernetesConfigDetails::currentTaints)).setter(ClusterKubernetesConfigDetails.setter(Builder::currentTaints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentTaints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ClusterKubernetesTaint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ClusterKubernetesTaint>> DESIRED_TAINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DesiredTaints").getter(ClusterKubernetesConfigDetails.getter(ClusterKubernetesConfigDetails::desiredTaints)).setter(ClusterKubernetesConfigDetails.setter(Builder::desiredTaints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredTaints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ClusterKubernetesTaint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CURRENT_LABELS_FIELD, DESIRED_LABELS_FIELD, CURRENT_TAINTS_FIELD, DESIRED_TAINTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ClusterKubernetesConfigDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Map<String, String> currentLabels;
    private final Map<String, String> desiredLabels;
    private final List<ClusterKubernetesTaint> currentTaints;
    private final List<ClusterKubernetesTaint> desiredTaints;

    private ClusterKubernetesConfigDetails(BuilderImpl builder) {
        this.currentLabels = builder.currentLabels;
        this.desiredLabels = builder.desiredLabels;
        this.currentTaints = builder.currentTaints;
        this.desiredTaints = builder.desiredTaints;
    }

    public final boolean hasCurrentLabels() {
        return this.currentLabels != null && !(this.currentLabels instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> currentLabels() {
        return this.currentLabels;
    }

    public final boolean hasDesiredLabels() {
        return this.desiredLabels != null && !(this.desiredLabels instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> desiredLabels() {
        return this.desiredLabels;
    }

    public final boolean hasCurrentTaints() {
        return this.currentTaints != null && !(this.currentTaints instanceof SdkAutoConstructList);
    }

    public final List<ClusterKubernetesTaint> currentTaints() {
        return this.currentTaints;
    }

    public final boolean hasDesiredTaints() {
        return this.desiredTaints != null && !(this.desiredTaints instanceof SdkAutoConstructList);
    }

    public final List<ClusterKubernetesTaint> desiredTaints() {
        return this.desiredTaints;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCurrentLabels() ? this.currentLabels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDesiredLabels() ? this.desiredLabels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCurrentTaints() ? this.currentTaints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDesiredTaints() ? this.desiredTaints() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterKubernetesConfigDetails)) {
            return false;
        }
        ClusterKubernetesConfigDetails other = (ClusterKubernetesConfigDetails)obj;
        return this.hasCurrentLabels() == other.hasCurrentLabels() && Objects.equals(this.currentLabels(), other.currentLabels()) && this.hasDesiredLabels() == other.hasDesiredLabels() && Objects.equals(this.desiredLabels(), other.desiredLabels()) && this.hasCurrentTaints() == other.hasCurrentTaints() && Objects.equals(this.currentTaints(), other.currentTaints()) && this.hasDesiredTaints() == other.hasDesiredTaints() && Objects.equals(this.desiredTaints(), other.desiredTaints());
    }

    public final String toString() {
        return ToString.builder((String)"ClusterKubernetesConfigDetails").add("CurrentLabels", this.hasCurrentLabels() ? this.currentLabels() : null).add("DesiredLabels", this.hasDesiredLabels() ? this.desiredLabels() : null).add("CurrentTaints", this.hasCurrentTaints() ? this.currentTaints() : null).add("DesiredTaints", this.hasDesiredTaints() ? this.desiredTaints() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CurrentLabels": {
                return Optional.ofNullable(clazz.cast(this.currentLabels()));
            }
            case "DesiredLabels": {
                return Optional.ofNullable(clazz.cast(this.desiredLabels()));
            }
            case "CurrentTaints": {
                return Optional.ofNullable(clazz.cast(this.currentTaints()));
            }
            case "DesiredTaints": {
                return Optional.ofNullable(clazz.cast(this.desiredTaints()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CurrentLabels", CURRENT_LABELS_FIELD);
        map.put("DesiredLabels", DESIRED_LABELS_FIELD);
        map.put("CurrentTaints", CURRENT_TAINTS_FIELD);
        map.put("DesiredTaints", DESIRED_TAINTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClusterKubernetesConfigDetails, T> g) {
        return obj -> g.apply((ClusterKubernetesConfigDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> currentLabels = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> desiredLabels = DefaultSdkAutoConstructMap.getInstance();
        private List<ClusterKubernetesTaint> currentTaints = DefaultSdkAutoConstructList.getInstance();
        private List<ClusterKubernetesTaint> desiredTaints = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterKubernetesConfigDetails model) {
            this.currentLabels(model.currentLabels);
            this.desiredLabels(model.desiredLabels);
            this.currentTaints(model.currentTaints);
            this.desiredTaints(model.desiredTaints);
        }

        public final Map<String, String> getCurrentLabels() {
            if (this.currentLabels instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.currentLabels;
        }

        public final void setCurrentLabels(Map<String, String> currentLabels) {
            this.currentLabels = ClusterKubernetesLabelsCopier.copy(currentLabels);
        }

        @Override
        public final Builder currentLabels(Map<String, String> currentLabels) {
            this.currentLabels = ClusterKubernetesLabelsCopier.copy(currentLabels);
            return this;
        }

        public final Map<String, String> getDesiredLabels() {
            if (this.desiredLabels instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.desiredLabels;
        }

        public final void setDesiredLabels(Map<String, String> desiredLabels) {
            this.desiredLabels = ClusterKubernetesLabelsCopier.copy(desiredLabels);
        }

        @Override
        public final Builder desiredLabels(Map<String, String> desiredLabels) {
            this.desiredLabels = ClusterKubernetesLabelsCopier.copy(desiredLabels);
            return this;
        }

        public final List<ClusterKubernetesTaint.Builder> getCurrentTaints() {
            List<ClusterKubernetesTaint.Builder> result = ClusterKubernetesTaintsCopier.copyToBuilder(this.currentTaints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCurrentTaints(Collection<ClusterKubernetesTaint.BuilderImpl> currentTaints) {
            this.currentTaints = ClusterKubernetesTaintsCopier.copyFromBuilder(currentTaints);
        }

        @Override
        public final Builder currentTaints(Collection<ClusterKubernetesTaint> currentTaints) {
            this.currentTaints = ClusterKubernetesTaintsCopier.copy(currentTaints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder currentTaints(ClusterKubernetesTaint ... currentTaints) {
            this.currentTaints(Arrays.asList(currentTaints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder currentTaints(Consumer<ClusterKubernetesTaint.Builder> ... currentTaints) {
            this.currentTaints(Stream.of(currentTaints).map(c -> (ClusterKubernetesTaint)((ClusterKubernetesTaint.Builder)ClusterKubernetesTaint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ClusterKubernetesTaint.Builder> getDesiredTaints() {
            List<ClusterKubernetesTaint.Builder> result = ClusterKubernetesTaintsCopier.copyToBuilder(this.desiredTaints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDesiredTaints(Collection<ClusterKubernetesTaint.BuilderImpl> desiredTaints) {
            this.desiredTaints = ClusterKubernetesTaintsCopier.copyFromBuilder(desiredTaints);
        }

        @Override
        public final Builder desiredTaints(Collection<ClusterKubernetesTaint> desiredTaints) {
            this.desiredTaints = ClusterKubernetesTaintsCopier.copy(desiredTaints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder desiredTaints(ClusterKubernetesTaint ... desiredTaints) {
            this.desiredTaints(Arrays.asList(desiredTaints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder desiredTaints(Consumer<ClusterKubernetesTaint.Builder> ... desiredTaints) {
            this.desiredTaints(Stream.of(desiredTaints).map(c -> (ClusterKubernetesTaint)((ClusterKubernetesTaint.Builder)ClusterKubernetesTaint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ClusterKubernetesConfigDetails build() {
            return new ClusterKubernetesConfigDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClusterKubernetesConfigDetails> {
        public Builder currentLabels(Map<String, String> var1);

        public Builder desiredLabels(Map<String, String> var1);

        public Builder currentTaints(Collection<ClusterKubernetesTaint> var1);

        public Builder currentTaints(ClusterKubernetesTaint ... var1);

        public Builder currentTaints(Consumer<ClusterKubernetesTaint.Builder> ... var1);

        public Builder desiredTaints(Collection<ClusterKubernetesTaint> var1);

        public Builder desiredTaints(ClusterKubernetesTaint ... var1);

        public Builder desiredTaints(Consumer<ClusterKubernetesTaint.Builder> ... var1);
    }
}

