/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.ReleaseNotesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AvailableUpgrade
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AvailableUpgrade> {
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Version").getter(AvailableUpgrade.getter(AvailableUpgrade::version)).setter(AvailableUpgrade.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final SdkField<List<String>> RELEASE_NOTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReleaseNotes").getter(AvailableUpgrade.getter(AvailableUpgrade::releaseNotes)).setter(AvailableUpgrade.setter(Builder::releaseNotes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReleaseNotes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERSION_FIELD, RELEASE_NOTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AvailableUpgrade.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String version;
    private final List<String> releaseNotes;

    private AvailableUpgrade(BuilderImpl builder) {
        this.version = builder.version;
        this.releaseNotes = builder.releaseNotes;
    }

    public final String version() {
        return this.version;
    }

    public final boolean hasReleaseNotes() {
        return this.releaseNotes != null && !(this.releaseNotes instanceof SdkAutoConstructList);
    }

    public final List<String> releaseNotes() {
        return this.releaseNotes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReleaseNotes() ? this.releaseNotes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AvailableUpgrade)) {
            return false;
        }
        AvailableUpgrade other = (AvailableUpgrade)obj;
        return Objects.equals(this.version(), other.version()) && this.hasReleaseNotes() == other.hasReleaseNotes() && Objects.equals(this.releaseNotes(), other.releaseNotes());
    }

    public final String toString() {
        return ToString.builder((String)"AvailableUpgrade").add("Version", (Object)this.version()).add("ReleaseNotes", this.hasReleaseNotes() ? this.releaseNotes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "ReleaseNotes": {
                return Optional.ofNullable(clazz.cast(this.releaseNotes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Version", VERSION_FIELD);
        map.put("ReleaseNotes", RELEASE_NOTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AvailableUpgrade, T> g) {
        return obj -> g.apply((AvailableUpgrade)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String version;
        private List<String> releaseNotes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AvailableUpgrade model) {
            this.version(model.version);
            this.releaseNotes(model.releaseNotes);
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final Collection<String> getReleaseNotes() {
            if (this.releaseNotes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.releaseNotes;
        }

        public final void setReleaseNotes(Collection<String> releaseNotes) {
            this.releaseNotes = ReleaseNotesListCopier.copy(releaseNotes);
        }

        @Override
        public final Builder releaseNotes(Collection<String> releaseNotes) {
            this.releaseNotes = ReleaseNotesListCopier.copy(releaseNotes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder releaseNotes(String ... releaseNotes) {
            this.releaseNotes(Arrays.asList(releaseNotes));
            return this;
        }

        public AvailableUpgrade build() {
            return new AvailableUpgrade(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AvailableUpgrade> {
        public Builder version(String var1);

        public Builder releaseNotes(Collection<String> var1);

        public Builder releaseNotes(String ... var1);
    }
}

