/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListStageDevicesRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, ListStageDevicesRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListStageDevicesRequest.getter(ListStageDevicesRequest::nextToken)).setter(ListStageDevicesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListStageDevicesRequest.getter(ListStageDevicesRequest::maxResults)).setter(ListStageDevicesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> EDGE_DEPLOYMENT_PLAN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EdgeDeploymentPlanName").getter(ListStageDevicesRequest.getter(ListStageDevicesRequest::edgeDeploymentPlanName)).setter(ListStageDevicesRequest.setter(Builder::edgeDeploymentPlanName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeDeploymentPlanName").build()}).build();
    private static final SdkField<Boolean> EXCLUDE_DEVICES_DEPLOYED_IN_OTHER_STAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ExcludeDevicesDeployedInOtherStage").getter(ListStageDevicesRequest.getter(ListStageDevicesRequest::excludeDevicesDeployedInOtherStage)).setter(ListStageDevicesRequest.setter(Builder::excludeDevicesDeployedInOtherStage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeDevicesDeployedInOtherStage").build()}).build();
    private static final SdkField<String> STAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StageName").getter(ListStageDevicesRequest.getter(ListStageDevicesRequest::stageName)).setter(ListStageDevicesRequest.setter(Builder::stageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StageName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, EDGE_DEPLOYMENT_PLAN_NAME_FIELD, EXCLUDE_DEVICES_DEPLOYED_IN_OTHER_STAGE_FIELD, STAGE_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListStageDevicesRequest.memberNameToFieldInitializer();
    private final String nextToken;
    private final Integer maxResults;
    private final String edgeDeploymentPlanName;
    private final Boolean excludeDevicesDeployedInOtherStage;
    private final String stageName;

    private ListStageDevicesRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.edgeDeploymentPlanName = builder.edgeDeploymentPlanName;
        this.excludeDevicesDeployedInOtherStage = builder.excludeDevicesDeployedInOtherStage;
        this.stageName = builder.stageName;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String edgeDeploymentPlanName() {
        return this.edgeDeploymentPlanName;
    }

    public final Boolean excludeDevicesDeployedInOtherStage() {
        return this.excludeDevicesDeployedInOtherStage;
    }

    public final String stageName() {
        return this.stageName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.edgeDeploymentPlanName());
        hashCode = 31 * hashCode + Objects.hashCode(this.excludeDevicesDeployedInOtherStage());
        hashCode = 31 * hashCode + Objects.hashCode(this.stageName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStageDevicesRequest)) {
            return false;
        }
        ListStageDevicesRequest other = (ListStageDevicesRequest)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.edgeDeploymentPlanName(), other.edgeDeploymentPlanName()) && Objects.equals(this.excludeDevicesDeployedInOtherStage(), other.excludeDevicesDeployedInOtherStage()) && Objects.equals(this.stageName(), other.stageName());
    }

    public final String toString() {
        return ToString.builder((String)"ListStageDevicesRequest").add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("EdgeDeploymentPlanName", (Object)this.edgeDeploymentPlanName()).add("ExcludeDevicesDeployedInOtherStage", (Object)this.excludeDevicesDeployedInOtherStage()).add("StageName", (Object)this.stageName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "EdgeDeploymentPlanName": {
                return Optional.ofNullable(clazz.cast(this.edgeDeploymentPlanName()));
            }
            case "ExcludeDevicesDeployedInOtherStage": {
                return Optional.ofNullable(clazz.cast(this.excludeDevicesDeployedInOtherStage()));
            }
            case "StageName": {
                return Optional.ofNullable(clazz.cast(this.stageName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("EdgeDeploymentPlanName", EDGE_DEPLOYMENT_PLAN_NAME_FIELD);
        map.put("ExcludeDevicesDeployedInOtherStage", EXCLUDE_DEVICES_DEPLOYED_IN_OTHER_STAGE_FIELD);
        map.put("StageName", STAGE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListStageDevicesRequest, T> g) {
        return obj -> g.apply((ListStageDevicesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String nextToken;
        private Integer maxResults;
        private String edgeDeploymentPlanName;
        private Boolean excludeDevicesDeployedInOtherStage;
        private String stageName;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStageDevicesRequest model) {
            super(model);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.edgeDeploymentPlanName(model.edgeDeploymentPlanName);
            this.excludeDevicesDeployedInOtherStage(model.excludeDevicesDeployedInOtherStage);
            this.stageName(model.stageName);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getEdgeDeploymentPlanName() {
            return this.edgeDeploymentPlanName;
        }

        public final void setEdgeDeploymentPlanName(String edgeDeploymentPlanName) {
            this.edgeDeploymentPlanName = edgeDeploymentPlanName;
        }

        @Override
        public final Builder edgeDeploymentPlanName(String edgeDeploymentPlanName) {
            this.edgeDeploymentPlanName = edgeDeploymentPlanName;
            return this;
        }

        public final Boolean getExcludeDevicesDeployedInOtherStage() {
            return this.excludeDevicesDeployedInOtherStage;
        }

        public final void setExcludeDevicesDeployedInOtherStage(Boolean excludeDevicesDeployedInOtherStage) {
            this.excludeDevicesDeployedInOtherStage = excludeDevicesDeployedInOtherStage;
        }

        @Override
        public final Builder excludeDevicesDeployedInOtherStage(Boolean excludeDevicesDeployedInOtherStage) {
            this.excludeDevicesDeployedInOtherStage = excludeDevicesDeployedInOtherStage;
            return this;
        }

        public final String getStageName() {
            return this.stageName;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListStageDevicesRequest build() {
            return new ListStageDevicesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListStageDevicesRequest> {
        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder edgeDeploymentPlanName(String var1);

        public Builder excludeDevicesDeployedInOtherStage(Boolean var1);

        public Builder stageName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

