/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.AdditionalEnis;
import software.amazon.awssdk.services.sagemaker.model.CapacityReservation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceMetadata> {
    private static final SdkField<String> CUSTOMER_ENI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomerEni").getter(InstanceMetadata.getter(InstanceMetadata::customerEni)).setter(InstanceMetadata.setter(Builder::customerEni)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerEni").build()}).build();
    private static final SdkField<AdditionalEnis> ADDITIONAL_ENIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AdditionalEnis").getter(InstanceMetadata.getter(InstanceMetadata::additionalEnis)).setter(InstanceMetadata.setter(Builder::additionalEnis)).constructor(AdditionalEnis::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalEnis").build()}).build();
    private static final SdkField<CapacityReservation> CAPACITY_RESERVATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CapacityReservation").getter(InstanceMetadata.getter(InstanceMetadata::capacityReservation)).setter(InstanceMetadata.setter(Builder::capacityReservation)).constructor(CapacityReservation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservation").build()}).build();
    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureMessage").getter(InstanceMetadata.getter(InstanceMetadata::failureMessage)).setter(InstanceMetadata.setter(Builder::failureMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureMessage").build()}).build();
    private static final SdkField<String> LCS_EXECUTION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LcsExecutionState").getter(InstanceMetadata.getter(InstanceMetadata::lcsExecutionState)).setter(InstanceMetadata.setter(Builder::lcsExecutionState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LcsExecutionState").build()}).build();
    private static final SdkField<String> NODE_LOGICAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NodeLogicalId").getter(InstanceMetadata.getter(InstanceMetadata::nodeLogicalId)).setter(InstanceMetadata.setter(Builder::nodeLogicalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeLogicalId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOMER_ENI_FIELD, ADDITIONAL_ENIS_FIELD, CAPACITY_RESERVATION_FIELD, FAILURE_MESSAGE_FIELD, LCS_EXECUTION_STATE_FIELD, NODE_LOGICAL_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InstanceMetadata.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String customerEni;
    private final AdditionalEnis additionalEnis;
    private final CapacityReservation capacityReservation;
    private final String failureMessage;
    private final String lcsExecutionState;
    private final String nodeLogicalId;

    private InstanceMetadata(BuilderImpl builder) {
        this.customerEni = builder.customerEni;
        this.additionalEnis = builder.additionalEnis;
        this.capacityReservation = builder.capacityReservation;
        this.failureMessage = builder.failureMessage;
        this.lcsExecutionState = builder.lcsExecutionState;
        this.nodeLogicalId = builder.nodeLogicalId;
    }

    public final String customerEni() {
        return this.customerEni;
    }

    public final AdditionalEnis additionalEnis() {
        return this.additionalEnis;
    }

    public final CapacityReservation capacityReservation() {
        return this.capacityReservation;
    }

    public final String failureMessage() {
        return this.failureMessage;
    }

    public final String lcsExecutionState() {
        return this.lcsExecutionState;
    }

    public final String nodeLogicalId() {
        return this.nodeLogicalId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.customerEni());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalEnis());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityReservation());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.lcsExecutionState());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeLogicalId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceMetadata)) {
            return false;
        }
        InstanceMetadata other = (InstanceMetadata)obj;
        return Objects.equals(this.customerEni(), other.customerEni()) && Objects.equals(this.additionalEnis(), other.additionalEnis()) && Objects.equals(this.capacityReservation(), other.capacityReservation()) && Objects.equals(this.failureMessage(), other.failureMessage()) && Objects.equals(this.lcsExecutionState(), other.lcsExecutionState()) && Objects.equals(this.nodeLogicalId(), other.nodeLogicalId());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceMetadata").add("CustomerEni", (Object)this.customerEni()).add("AdditionalEnis", (Object)this.additionalEnis()).add("CapacityReservation", (Object)this.capacityReservation()).add("FailureMessage", (Object)this.failureMessage()).add("LcsExecutionState", (Object)this.lcsExecutionState()).add("NodeLogicalId", (Object)this.nodeLogicalId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CustomerEni": {
                return Optional.ofNullable(clazz.cast(this.customerEni()));
            }
            case "AdditionalEnis": {
                return Optional.ofNullable(clazz.cast(this.additionalEnis()));
            }
            case "CapacityReservation": {
                return Optional.ofNullable(clazz.cast(this.capacityReservation()));
            }
            case "FailureMessage": {
                return Optional.ofNullable(clazz.cast(this.failureMessage()));
            }
            case "LcsExecutionState": {
                return Optional.ofNullable(clazz.cast(this.lcsExecutionState()));
            }
            case "NodeLogicalId": {
                return Optional.ofNullable(clazz.cast(this.nodeLogicalId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CustomerEni", CUSTOMER_ENI_FIELD);
        map.put("AdditionalEnis", ADDITIONAL_ENIS_FIELD);
        map.put("CapacityReservation", CAPACITY_RESERVATION_FIELD);
        map.put("FailureMessage", FAILURE_MESSAGE_FIELD);
        map.put("LcsExecutionState", LCS_EXECUTION_STATE_FIELD);
        map.put("NodeLogicalId", NODE_LOGICAL_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstanceMetadata, T> g) {
        return obj -> g.apply((InstanceMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String customerEni;
        private AdditionalEnis additionalEnis;
        private CapacityReservation capacityReservation;
        private String failureMessage;
        private String lcsExecutionState;
        private String nodeLogicalId;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceMetadata model) {
            this.customerEni(model.customerEni);
            this.additionalEnis(model.additionalEnis);
            this.capacityReservation(model.capacityReservation);
            this.failureMessage(model.failureMessage);
            this.lcsExecutionState(model.lcsExecutionState);
            this.nodeLogicalId(model.nodeLogicalId);
        }

        public final String getCustomerEni() {
            return this.customerEni;
        }

        public final void setCustomerEni(String customerEni) {
            this.customerEni = customerEni;
        }

        @Override
        public final Builder customerEni(String customerEni) {
            this.customerEni = customerEni;
            return this;
        }

        public final AdditionalEnis.Builder getAdditionalEnis() {
            return this.additionalEnis != null ? this.additionalEnis.toBuilder() : null;
        }

        public final void setAdditionalEnis(AdditionalEnis.BuilderImpl additionalEnis) {
            this.additionalEnis = additionalEnis != null ? additionalEnis.build() : null;
        }

        @Override
        public final Builder additionalEnis(AdditionalEnis additionalEnis) {
            this.additionalEnis = additionalEnis;
            return this;
        }

        public final CapacityReservation.Builder getCapacityReservation() {
            return this.capacityReservation != null ? this.capacityReservation.toBuilder() : null;
        }

        public final void setCapacityReservation(CapacityReservation.BuilderImpl capacityReservation) {
            this.capacityReservation = capacityReservation != null ? capacityReservation.build() : null;
        }

        @Override
        public final Builder capacityReservation(CapacityReservation capacityReservation) {
            this.capacityReservation = capacityReservation;
            return this;
        }

        public final String getFailureMessage() {
            return this.failureMessage;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public final String getLcsExecutionState() {
            return this.lcsExecutionState;
        }

        public final void setLcsExecutionState(String lcsExecutionState) {
            this.lcsExecutionState = lcsExecutionState;
        }

        @Override
        public final Builder lcsExecutionState(String lcsExecutionState) {
            this.lcsExecutionState = lcsExecutionState;
            return this;
        }

        public final String getNodeLogicalId() {
            return this.nodeLogicalId;
        }

        public final void setNodeLogicalId(String nodeLogicalId) {
            this.nodeLogicalId = nodeLogicalId;
        }

        @Override
        public final Builder nodeLogicalId(String nodeLogicalId) {
            this.nodeLogicalId = nodeLogicalId;
            return this;
        }

        public InstanceMetadata build() {
            return new InstanceMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceMetadata> {
        public Builder customerEni(String var1);

        public Builder additionalEnis(AdditionalEnis var1);

        default public Builder additionalEnis(Consumer<AdditionalEnis.Builder> additionalEnis) {
            return this.additionalEnis((AdditionalEnis)((AdditionalEnis.Builder)AdditionalEnis.builder().applyMutation(additionalEnis)).build());
        }

        public Builder capacityReservation(CapacityReservation var1);

        default public Builder capacityReservation(Consumer<CapacityReservation.Builder> capacityReservation) {
            return this.capacityReservation((CapacityReservation)((CapacityReservation.Builder)CapacityReservation.builder().applyMutation(capacityReservation)).build());
        }

        public Builder failureMessage(String var1);

        public Builder lcsExecutionState(String var1);

        public Builder nodeLogicalId(String var1);
    }
}

