/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum IPAddressType {
    IPV4("ipv4"),
    DUALSTACK("dualstack"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, IPAddressType> VALUE_MAP;
    private final String value;

    private IPAddressType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IPAddressType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<IPAddressType> knownValues() {
        EnumSet<IPAddressType> knownValues = EnumSet.allOf(IPAddressType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(IPAddressType.class, IPAddressType::toString);
    }
}

