/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EdgeDeploymentModelConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EdgeDeploymentModelConfig> {
    private static final SdkField<String> MODEL_HANDLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelHandle").getter(EdgeDeploymentModelConfig.getter(EdgeDeploymentModelConfig::modelHandle)).setter(EdgeDeploymentModelConfig.setter(Builder::modelHandle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelHandle").build()}).build();
    private static final SdkField<String> EDGE_PACKAGING_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EdgePackagingJobName").getter(EdgeDeploymentModelConfig.getter(EdgeDeploymentModelConfig::edgePackagingJobName)).setter(EdgeDeploymentModelConfig.setter(Builder::edgePackagingJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgePackagingJobName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_HANDLE_FIELD, EDGE_PACKAGING_JOB_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EdgeDeploymentModelConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String modelHandle;
    private final String edgePackagingJobName;

    private EdgeDeploymentModelConfig(BuilderImpl builder) {
        this.modelHandle = builder.modelHandle;
        this.edgePackagingJobName = builder.edgePackagingJobName;
    }

    public final String modelHandle() {
        return this.modelHandle;
    }

    public final String edgePackagingJobName() {
        return this.edgePackagingJobName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modelHandle());
        hashCode = 31 * hashCode + Objects.hashCode(this.edgePackagingJobName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EdgeDeploymentModelConfig)) {
            return false;
        }
        EdgeDeploymentModelConfig other = (EdgeDeploymentModelConfig)obj;
        return Objects.equals(this.modelHandle(), other.modelHandle()) && Objects.equals(this.edgePackagingJobName(), other.edgePackagingJobName());
    }

    public final String toString() {
        return ToString.builder((String)"EdgeDeploymentModelConfig").add("ModelHandle", (Object)this.modelHandle()).add("EdgePackagingJobName", (Object)this.edgePackagingJobName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelHandle": {
                return Optional.ofNullable(clazz.cast(this.modelHandle()));
            }
            case "EdgePackagingJobName": {
                return Optional.ofNullable(clazz.cast(this.edgePackagingJobName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ModelHandle", MODEL_HANDLE_FIELD);
        map.put("EdgePackagingJobName", EDGE_PACKAGING_JOB_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EdgeDeploymentModelConfig, T> g) {
        return obj -> g.apply((EdgeDeploymentModelConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String modelHandle;
        private String edgePackagingJobName;

        private BuilderImpl() {
        }

        private BuilderImpl(EdgeDeploymentModelConfig model) {
            this.modelHandle(model.modelHandle);
            this.edgePackagingJobName(model.edgePackagingJobName);
        }

        public final String getModelHandle() {
            return this.modelHandle;
        }

        public final void setModelHandle(String modelHandle) {
            this.modelHandle = modelHandle;
        }

        @Override
        public final Builder modelHandle(String modelHandle) {
            this.modelHandle = modelHandle;
            return this;
        }

        public final String getEdgePackagingJobName() {
            return this.edgePackagingJobName;
        }

        public final void setEdgePackagingJobName(String edgePackagingJobName) {
            this.edgePackagingJobName = edgePackagingJobName;
        }

        @Override
        public final Builder edgePackagingJobName(String edgePackagingJobName) {
            this.edgePackagingJobName = edgePackagingJobName;
            return this;
        }

        public EdgeDeploymentModelConfig build() {
            return new EdgeDeploymentModelConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EdgeDeploymentModelConfig> {
        public Builder modelHandle(String var1);

        public Builder edgePackagingJobName(String var1);
    }
}

