/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ProductionVariantServerlessUpdateConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DesiredWeightAndCapacity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DesiredWeightAndCapacity> {
    private static final SdkField<String> VARIANT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VariantName").getter(DesiredWeightAndCapacity.getter(DesiredWeightAndCapacity::variantName)).setter(DesiredWeightAndCapacity.setter(Builder::variantName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VariantName").build()}).build();
    private static final SdkField<Float> DESIRED_WEIGHT_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("DesiredWeight").getter(DesiredWeightAndCapacity.getter(DesiredWeightAndCapacity::desiredWeight)).setter(DesiredWeightAndCapacity.setter(Builder::desiredWeight)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredWeight").build()}).build();
    private static final SdkField<Integer> DESIRED_INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DesiredInstanceCount").getter(DesiredWeightAndCapacity.getter(DesiredWeightAndCapacity::desiredInstanceCount)).setter(DesiredWeightAndCapacity.setter(Builder::desiredInstanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredInstanceCount").build()}).build();
    private static final SdkField<ProductionVariantServerlessUpdateConfig> SERVERLESS_UPDATE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ServerlessUpdateConfig").getter(DesiredWeightAndCapacity.getter(DesiredWeightAndCapacity::serverlessUpdateConfig)).setter(DesiredWeightAndCapacity.setter(Builder::serverlessUpdateConfig)).constructor(ProductionVariantServerlessUpdateConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerlessUpdateConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VARIANT_NAME_FIELD, DESIRED_WEIGHT_FIELD, DESIRED_INSTANCE_COUNT_FIELD, SERVERLESS_UPDATE_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DesiredWeightAndCapacity.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String variantName;
    private final Float desiredWeight;
    private final Integer desiredInstanceCount;
    private final ProductionVariantServerlessUpdateConfig serverlessUpdateConfig;

    private DesiredWeightAndCapacity(BuilderImpl builder) {
        this.variantName = builder.variantName;
        this.desiredWeight = builder.desiredWeight;
        this.desiredInstanceCount = builder.desiredInstanceCount;
        this.serverlessUpdateConfig = builder.serverlessUpdateConfig;
    }

    public final String variantName() {
        return this.variantName;
    }

    public final Float desiredWeight() {
        return this.desiredWeight;
    }

    public final Integer desiredInstanceCount() {
        return this.desiredInstanceCount;
    }

    public final ProductionVariantServerlessUpdateConfig serverlessUpdateConfig() {
        return this.serverlessUpdateConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.variantName());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredWeight());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverlessUpdateConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DesiredWeightAndCapacity)) {
            return false;
        }
        DesiredWeightAndCapacity other = (DesiredWeightAndCapacity)obj;
        return Objects.equals(this.variantName(), other.variantName()) && Objects.equals(this.desiredWeight(), other.desiredWeight()) && Objects.equals(this.desiredInstanceCount(), other.desiredInstanceCount()) && Objects.equals(this.serverlessUpdateConfig(), other.serverlessUpdateConfig());
    }

    public final String toString() {
        return ToString.builder((String)"DesiredWeightAndCapacity").add("VariantName", (Object)this.variantName()).add("DesiredWeight", (Object)this.desiredWeight()).add("DesiredInstanceCount", (Object)this.desiredInstanceCount()).add("ServerlessUpdateConfig", (Object)this.serverlessUpdateConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VariantName": {
                return Optional.ofNullable(clazz.cast(this.variantName()));
            }
            case "DesiredWeight": {
                return Optional.ofNullable(clazz.cast(this.desiredWeight()));
            }
            case "DesiredInstanceCount": {
                return Optional.ofNullable(clazz.cast(this.desiredInstanceCount()));
            }
            case "ServerlessUpdateConfig": {
                return Optional.ofNullable(clazz.cast(this.serverlessUpdateConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("VariantName", VARIANT_NAME_FIELD);
        map.put("DesiredWeight", DESIRED_WEIGHT_FIELD);
        map.put("DesiredInstanceCount", DESIRED_INSTANCE_COUNT_FIELD);
        map.put("ServerlessUpdateConfig", SERVERLESS_UPDATE_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DesiredWeightAndCapacity, T> g) {
        return obj -> g.apply((DesiredWeightAndCapacity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String variantName;
        private Float desiredWeight;
        private Integer desiredInstanceCount;
        private ProductionVariantServerlessUpdateConfig serverlessUpdateConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(DesiredWeightAndCapacity model) {
            this.variantName(model.variantName);
            this.desiredWeight(model.desiredWeight);
            this.desiredInstanceCount(model.desiredInstanceCount);
            this.serverlessUpdateConfig(model.serverlessUpdateConfig);
        }

        public final String getVariantName() {
            return this.variantName;
        }

        public final void setVariantName(String variantName) {
            this.variantName = variantName;
        }

        @Override
        public final Builder variantName(String variantName) {
            this.variantName = variantName;
            return this;
        }

        public final Float getDesiredWeight() {
            return this.desiredWeight;
        }

        public final void setDesiredWeight(Float desiredWeight) {
            this.desiredWeight = desiredWeight;
        }

        @Override
        public final Builder desiredWeight(Float desiredWeight) {
            this.desiredWeight = desiredWeight;
            return this;
        }

        public final Integer getDesiredInstanceCount() {
            return this.desiredInstanceCount;
        }

        public final void setDesiredInstanceCount(Integer desiredInstanceCount) {
            this.desiredInstanceCount = desiredInstanceCount;
        }

        @Override
        public final Builder desiredInstanceCount(Integer desiredInstanceCount) {
            this.desiredInstanceCount = desiredInstanceCount;
            return this;
        }

        public final ProductionVariantServerlessUpdateConfig.Builder getServerlessUpdateConfig() {
            return this.serverlessUpdateConfig != null ? this.serverlessUpdateConfig.toBuilder() : null;
        }

        public final void setServerlessUpdateConfig(ProductionVariantServerlessUpdateConfig.BuilderImpl serverlessUpdateConfig) {
            this.serverlessUpdateConfig = serverlessUpdateConfig != null ? serverlessUpdateConfig.build() : null;
        }

        @Override
        public final Builder serverlessUpdateConfig(ProductionVariantServerlessUpdateConfig serverlessUpdateConfig) {
            this.serverlessUpdateConfig = serverlessUpdateConfig;
            return this;
        }

        public DesiredWeightAndCapacity build() {
            return new DesiredWeightAndCapacity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DesiredWeightAndCapacity> {
        public Builder variantName(String var1);

        public Builder desiredWeight(Float var1);

        public Builder desiredInstanceCount(Integer var1);

        public Builder serverlessUpdateConfig(ProductionVariantServerlessUpdateConfig var1);

        default public Builder serverlessUpdateConfig(Consumer<ProductionVariantServerlessUpdateConfig.Builder> serverlessUpdateConfig) {
            return this.serverlessUpdateConfig((ProductionVariantServerlessUpdateConfig)((ProductionVariantServerlessUpdateConfig.Builder)ProductionVariantServerlessUpdateConfig.builder().applyMutation(serverlessUpdateConfig)).build());
        }
    }
}

