/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.CfnStackDetail;
import software.amazon.awssdk.services.sagemaker.model.CfnStackParameter;
import software.amazon.awssdk.services.sagemaker.model.CfnStackParametersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CfnTemplateProviderDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CfnTemplateProviderDetail> {
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateName").getter(CfnTemplateProviderDetail.getter(CfnTemplateProviderDetail::templateName)).setter(CfnTemplateProviderDetail.setter(Builder::templateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateName").build()}).build();
    private static final SdkField<String> TEMPLATE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateURL").getter(CfnTemplateProviderDetail.getter(CfnTemplateProviderDetail::templateURL)).setter(CfnTemplateProviderDetail.setter(Builder::templateURL)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateURL").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleARN").getter(CfnTemplateProviderDetail.getter(CfnTemplateProviderDetail::roleARN)).setter(CfnTemplateProviderDetail.setter(Builder::roleARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()}).build();
    private static final SdkField<List<CfnStackParameter>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Parameters").getter(CfnTemplateProviderDetail.getter(CfnTemplateProviderDetail::parameters)).setter(CfnTemplateProviderDetail.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CfnStackParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<CfnStackDetail> STACK_DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StackDetail").getter(CfnTemplateProviderDetail.getter(CfnTemplateProviderDetail::stackDetail)).setter(CfnTemplateProviderDetail.setter(Builder::stackDetail)).constructor(CfnStackDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackDetail").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_NAME_FIELD, TEMPLATE_URL_FIELD, ROLE_ARN_FIELD, PARAMETERS_FIELD, STACK_DETAIL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CfnTemplateProviderDetail.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String templateName;
    private final String templateURL;
    private final String roleARN;
    private final List<CfnStackParameter> parameters;
    private final CfnStackDetail stackDetail;

    private CfnTemplateProviderDetail(BuilderImpl builder) {
        this.templateName = builder.templateName;
        this.templateURL = builder.templateURL;
        this.roleARN = builder.roleARN;
        this.parameters = builder.parameters;
        this.stackDetail = builder.stackDetail;
    }

    public final String templateName() {
        return this.templateName;
    }

    public final String templateURL() {
        return this.templateURL;
    }

    public final String roleARN() {
        return this.roleARN;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructList);
    }

    public final List<CfnStackParameter> parameters() {
        return this.parameters;
    }

    public final CfnStackDetail stackDetail() {
        return this.stackDetail;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.templateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateURL());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.stackDetail());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CfnTemplateProviderDetail)) {
            return false;
        }
        CfnTemplateProviderDetail other = (CfnTemplateProviderDetail)obj;
        return Objects.equals(this.templateName(), other.templateName()) && Objects.equals(this.templateURL(), other.templateURL()) && Objects.equals(this.roleARN(), other.roleARN()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.stackDetail(), other.stackDetail());
    }

    public final String toString() {
        return ToString.builder((String)"CfnTemplateProviderDetail").add("TemplateName", (Object)this.templateName()).add("TemplateURL", (Object)this.templateURL()).add("RoleARN", (Object)this.roleARN()).add("Parameters", this.hasParameters() ? this.parameters() : null).add("StackDetail", (Object)this.stackDetail()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TemplateName": {
                return Optional.ofNullable(clazz.cast(this.templateName()));
            }
            case "TemplateURL": {
                return Optional.ofNullable(clazz.cast(this.templateURL()));
            }
            case "RoleARN": {
                return Optional.ofNullable(clazz.cast(this.roleARN()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "StackDetail": {
                return Optional.ofNullable(clazz.cast(this.stackDetail()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TemplateName", TEMPLATE_NAME_FIELD);
        map.put("TemplateURL", TEMPLATE_URL_FIELD);
        map.put("RoleARN", ROLE_ARN_FIELD);
        map.put("Parameters", PARAMETERS_FIELD);
        map.put("StackDetail", STACK_DETAIL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CfnTemplateProviderDetail, T> g) {
        return obj -> g.apply((CfnTemplateProviderDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String templateName;
        private String templateURL;
        private String roleARN;
        private List<CfnStackParameter> parameters = DefaultSdkAutoConstructList.getInstance();
        private CfnStackDetail stackDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(CfnTemplateProviderDetail model) {
            this.templateName(model.templateName);
            this.templateURL(model.templateURL);
            this.roleARN(model.roleARN);
            this.parameters(model.parameters);
            this.stackDetail(model.stackDetail);
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final String getTemplateURL() {
            return this.templateURL;
        }

        public final void setTemplateURL(String templateURL) {
            this.templateURL = templateURL;
        }

        @Override
        public final Builder templateURL(String templateURL) {
            this.templateURL = templateURL;
            return this;
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final List<CfnStackParameter.Builder> getParameters() {
            List<CfnStackParameter.Builder> result = CfnStackParametersCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameters(Collection<CfnStackParameter.BuilderImpl> parameters) {
            this.parameters = CfnStackParametersCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Collection<CfnStackParameter> parameters) {
            this.parameters = CfnStackParametersCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(CfnStackParameter ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<CfnStackParameter.Builder> ... parameters) {
            this.parameters(Stream.of(parameters).map(c -> (CfnStackParameter)((CfnStackParameter.Builder)CfnStackParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final CfnStackDetail.Builder getStackDetail() {
            return this.stackDetail != null ? this.stackDetail.toBuilder() : null;
        }

        public final void setStackDetail(CfnStackDetail.BuilderImpl stackDetail) {
            this.stackDetail = stackDetail != null ? stackDetail.build() : null;
        }

        @Override
        public final Builder stackDetail(CfnStackDetail stackDetail) {
            this.stackDetail = stackDetail;
            return this;
        }

        public CfnTemplateProviderDetail build() {
            return new CfnTemplateProviderDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CfnTemplateProviderDetail> {
        public Builder templateName(String var1);

        public Builder templateURL(String var1);

        public Builder roleARN(String var1);

        public Builder parameters(Collection<CfnStackParameter> var1);

        public Builder parameters(CfnStackParameter ... var1);

        public Builder parameters(Consumer<CfnStackParameter.Builder> ... var1);

        public Builder stackDetail(CfnStackDetail var1);

        default public Builder stackDetail(Consumer<CfnStackDetail.Builder> stackDetail) {
            return this.stackDetail((CfnStackDetail)((CfnStackDetail.Builder)CfnStackDetail.builder().applyMutation(stackDetail)).build());
        }
    }
}

