/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AuthorizedUrl
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AuthorizedUrl> {
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Url").getter(AuthorizedUrl.getter(AuthorizedUrl::url)).setter(AuthorizedUrl.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()}).build();
    private static final SdkField<String> LOCAL_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocalPath").getter(AuthorizedUrl.getter(AuthorizedUrl::localPath)).setter(AuthorizedUrl.setter(Builder::localPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalPath").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(URL_FIELD, LOCAL_PATH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AuthorizedUrl.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String url;
    private final String localPath;

    private AuthorizedUrl(BuilderImpl builder) {
        this.url = builder.url;
        this.localPath = builder.localPath;
    }

    public final String url() {
        return this.url;
    }

    public final String localPath() {
        return this.localPath;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        hashCode = 31 * hashCode + Objects.hashCode(this.localPath());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthorizedUrl)) {
            return false;
        }
        AuthorizedUrl other = (AuthorizedUrl)obj;
        return Objects.equals(this.url(), other.url()) && Objects.equals(this.localPath(), other.localPath());
    }

    public final String toString() {
        return ToString.builder((String)"AuthorizedUrl").add("Url", (Object)this.url()).add("LocalPath", (Object)this.localPath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
            case "LocalPath": {
                return Optional.ofNullable(clazz.cast(this.localPath()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Url", URL_FIELD);
        map.put("LocalPath", LOCAL_PATH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AuthorizedUrl, T> g) {
        return obj -> g.apply((AuthorizedUrl)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String url;
        private String localPath;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthorizedUrl model) {
            this.url(model.url);
            this.localPath(model.localPath);
        }

        public final String getUrl() {
            return this.url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final String getLocalPath() {
            return this.localPath;
        }

        public final void setLocalPath(String localPath) {
            this.localPath = localPath;
        }

        @Override
        public final Builder localPath(String localPath) {
            this.localPath = localPath;
            return this;
        }

        public AuthorizedUrl build() {
            return new AuthorizedUrl(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AuthorizedUrl> {
        public Builder url(String var1);

        public Builder localPath(String var1);
    }
}

