/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ContainerConfig;
import software.amazon.awssdk.services.sagemaker.model.FileSystemConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CodeEditorAppImageConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CodeEditorAppImageConfig> {
    private static final SdkField<FileSystemConfig> FILE_SYSTEM_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FileSystemConfig").getter(CodeEditorAppImageConfig.getter(CodeEditorAppImageConfig::fileSystemConfig)).setter(CodeEditorAppImageConfig.setter(Builder::fileSystemConfig)).constructor(FileSystemConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemConfig").build()}).build();
    private static final SdkField<ContainerConfig> CONTAINER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ContainerConfig").getter(CodeEditorAppImageConfig.getter(CodeEditorAppImageConfig::containerConfig)).setter(CodeEditorAppImageConfig.setter(Builder::containerConfig)).constructor(ContainerConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_SYSTEM_CONFIG_FIELD, CONTAINER_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CodeEditorAppImageConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final FileSystemConfig fileSystemConfig;
    private final ContainerConfig containerConfig;

    private CodeEditorAppImageConfig(BuilderImpl builder) {
        this.fileSystemConfig = builder.fileSystemConfig;
        this.containerConfig = builder.containerConfig;
    }

    public final FileSystemConfig fileSystemConfig() {
        return this.fileSystemConfig;
    }

    public final ContainerConfig containerConfig() {
        return this.containerConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeEditorAppImageConfig)) {
            return false;
        }
        CodeEditorAppImageConfig other = (CodeEditorAppImageConfig)obj;
        return Objects.equals(this.fileSystemConfig(), other.fileSystemConfig()) && Objects.equals(this.containerConfig(), other.containerConfig());
    }

    public final String toString() {
        return ToString.builder((String)"CodeEditorAppImageConfig").add("FileSystemConfig", (Object)this.fileSystemConfig()).add("ContainerConfig", (Object)this.containerConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FileSystemConfig": {
                return Optional.ofNullable(clazz.cast(this.fileSystemConfig()));
            }
            case "ContainerConfig": {
                return Optional.ofNullable(clazz.cast(this.containerConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FileSystemConfig", FILE_SYSTEM_CONFIG_FIELD);
        map.put("ContainerConfig", CONTAINER_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CodeEditorAppImageConfig, T> g) {
        return obj -> g.apply((CodeEditorAppImageConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private FileSystemConfig fileSystemConfig;
        private ContainerConfig containerConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeEditorAppImageConfig model) {
            this.fileSystemConfig(model.fileSystemConfig);
            this.containerConfig(model.containerConfig);
        }

        public final FileSystemConfig.Builder getFileSystemConfig() {
            return this.fileSystemConfig != null ? this.fileSystemConfig.toBuilder() : null;
        }

        public final void setFileSystemConfig(FileSystemConfig.BuilderImpl fileSystemConfig) {
            this.fileSystemConfig = fileSystemConfig != null ? fileSystemConfig.build() : null;
        }

        @Override
        public final Builder fileSystemConfig(FileSystemConfig fileSystemConfig) {
            this.fileSystemConfig = fileSystemConfig;
            return this;
        }

        public final ContainerConfig.Builder getContainerConfig() {
            return this.containerConfig != null ? this.containerConfig.toBuilder() : null;
        }

        public final void setContainerConfig(ContainerConfig.BuilderImpl containerConfig) {
            this.containerConfig = containerConfig != null ? containerConfig.build() : null;
        }

        @Override
        public final Builder containerConfig(ContainerConfig containerConfig) {
            this.containerConfig = containerConfig;
            return this;
        }

        public CodeEditorAppImageConfig build() {
            return new CodeEditorAppImageConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CodeEditorAppImageConfig> {
        public Builder fileSystemConfig(FileSystemConfig var1);

        default public Builder fileSystemConfig(Consumer<FileSystemConfig.Builder> fileSystemConfig) {
            return this.fileSystemConfig((FileSystemConfig)((FileSystemConfig.Builder)FileSystemConfig.builder().applyMutation(fileSystemConfig)).build());
        }

        public Builder containerConfig(ContainerConfig var1);

        default public Builder containerConfig(Consumer<ContainerConfig.Builder> containerConfig) {
            return this.containerConfig((ContainerConfig)((ContainerConfig.Builder)ContainerConfig.builder().applyMutation(containerConfig)).build());
        }
    }
}

