/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.ActivationState;
import software.amazon.awssdk.services.sagemaker.model.ComputeQuotaConfig;
import software.amazon.awssdk.services.sagemaker.model.ComputeQuotaTarget;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.Tag;
import software.amazon.awssdk.services.sagemaker.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateComputeQuotaRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, CreateComputeQuotaRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateComputeQuotaRequest.getter(CreateComputeQuotaRequest::name)).setter(CreateComputeQuotaRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateComputeQuotaRequest.getter(CreateComputeQuotaRequest::description)).setter(CreateComputeQuotaRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterArn").getter(CreateComputeQuotaRequest.getter(CreateComputeQuotaRequest::clusterArn)).setter(CreateComputeQuotaRequest.setter(Builder::clusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterArn").build()}).build();
    private static final SdkField<ComputeQuotaConfig> COMPUTE_QUOTA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ComputeQuotaConfig").getter(CreateComputeQuotaRequest.getter(CreateComputeQuotaRequest::computeQuotaConfig)).setter(CreateComputeQuotaRequest.setter(Builder::computeQuotaConfig)).constructor(ComputeQuotaConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeQuotaConfig").build()}).build();
    private static final SdkField<ComputeQuotaTarget> COMPUTE_QUOTA_TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ComputeQuotaTarget").getter(CreateComputeQuotaRequest.getter(CreateComputeQuotaRequest::computeQuotaTarget)).setter(CreateComputeQuotaRequest.setter(Builder::computeQuotaTarget)).constructor(ComputeQuotaTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeQuotaTarget").build()}).build();
    private static final SdkField<String> ACTIVATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActivationState").getter(CreateComputeQuotaRequest.getter(CreateComputeQuotaRequest::activationStateAsString)).setter(CreateComputeQuotaRequest.setter(Builder::activationState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivationState").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateComputeQuotaRequest.getter(CreateComputeQuotaRequest::tags)).setter(CreateComputeQuotaRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, CLUSTER_ARN_FIELD, COMPUTE_QUOTA_CONFIG_FIELD, COMPUTE_QUOTA_TARGET_FIELD, ACTIVATION_STATE_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateComputeQuotaRequest.memberNameToFieldInitializer();
    private final String name;
    private final String description;
    private final String clusterArn;
    private final ComputeQuotaConfig computeQuotaConfig;
    private final ComputeQuotaTarget computeQuotaTarget;
    private final String activationState;
    private final List<Tag> tags;

    private CreateComputeQuotaRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.clusterArn = builder.clusterArn;
        this.computeQuotaConfig = builder.computeQuotaConfig;
        this.computeQuotaTarget = builder.computeQuotaTarget;
        this.activationState = builder.activationState;
        this.tags = builder.tags;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String clusterArn() {
        return this.clusterArn;
    }

    public final ComputeQuotaConfig computeQuotaConfig() {
        return this.computeQuotaConfig;
    }

    public final ComputeQuotaTarget computeQuotaTarget() {
        return this.computeQuotaTarget;
    }

    public final ActivationState activationState() {
        return ActivationState.fromValue(this.activationState);
    }

    public final String activationStateAsString() {
        return this.activationState;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeQuotaConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeQuotaTarget());
        hashCode = 31 * hashCode + Objects.hashCode(this.activationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateComputeQuotaRequest)) {
            return false;
        }
        CreateComputeQuotaRequest other = (CreateComputeQuotaRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.clusterArn(), other.clusterArn()) && Objects.equals(this.computeQuotaConfig(), other.computeQuotaConfig()) && Objects.equals(this.computeQuotaTarget(), other.computeQuotaTarget()) && Objects.equals(this.activationStateAsString(), other.activationStateAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateComputeQuotaRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("ClusterArn", (Object)this.clusterArn()).add("ComputeQuotaConfig", (Object)this.computeQuotaConfig()).add("ComputeQuotaTarget", (Object)this.computeQuotaTarget()).add("ActivationState", (Object)this.activationStateAsString()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ClusterArn": {
                return Optional.ofNullable(clazz.cast(this.clusterArn()));
            }
            case "ComputeQuotaConfig": {
                return Optional.ofNullable(clazz.cast(this.computeQuotaConfig()));
            }
            case "ComputeQuotaTarget": {
                return Optional.ofNullable(clazz.cast(this.computeQuotaTarget()));
            }
            case "ActivationState": {
                return Optional.ofNullable(clazz.cast(this.activationStateAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ClusterArn", CLUSTER_ARN_FIELD);
        map.put("ComputeQuotaConfig", COMPUTE_QUOTA_CONFIG_FIELD);
        map.put("ComputeQuotaTarget", COMPUTE_QUOTA_TARGET_FIELD);
        map.put("ActivationState", ACTIVATION_STATE_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateComputeQuotaRequest, T> g) {
        return obj -> g.apply((CreateComputeQuotaRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String clusterArn;
        private ComputeQuotaConfig computeQuotaConfig;
        private ComputeQuotaTarget computeQuotaTarget;
        private String activationState;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateComputeQuotaRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.clusterArn(model.clusterArn);
            this.computeQuotaConfig(model.computeQuotaConfig);
            this.computeQuotaTarget(model.computeQuotaTarget);
            this.activationState(model.activationState);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getClusterArn() {
            return this.clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final ComputeQuotaConfig.Builder getComputeQuotaConfig() {
            return this.computeQuotaConfig != null ? this.computeQuotaConfig.toBuilder() : null;
        }

        public final void setComputeQuotaConfig(ComputeQuotaConfig.BuilderImpl computeQuotaConfig) {
            this.computeQuotaConfig = computeQuotaConfig != null ? computeQuotaConfig.build() : null;
        }

        @Override
        public final Builder computeQuotaConfig(ComputeQuotaConfig computeQuotaConfig) {
            this.computeQuotaConfig = computeQuotaConfig;
            return this;
        }

        public final ComputeQuotaTarget.Builder getComputeQuotaTarget() {
            return this.computeQuotaTarget != null ? this.computeQuotaTarget.toBuilder() : null;
        }

        public final void setComputeQuotaTarget(ComputeQuotaTarget.BuilderImpl computeQuotaTarget) {
            this.computeQuotaTarget = computeQuotaTarget != null ? computeQuotaTarget.build() : null;
        }

        @Override
        public final Builder computeQuotaTarget(ComputeQuotaTarget computeQuotaTarget) {
            this.computeQuotaTarget = computeQuotaTarget;
            return this;
        }

        public final String getActivationState() {
            return this.activationState;
        }

        public final void setActivationState(String activationState) {
            this.activationState = activationState;
        }

        @Override
        public final Builder activationState(String activationState) {
            this.activationState = activationState;
            return this;
        }

        @Override
        public final Builder activationState(ActivationState activationState) {
            this.activationState(activationState == null ? null : activationState.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateComputeQuotaRequest build() {
            return new CreateComputeQuotaRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateComputeQuotaRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder clusterArn(String var1);

        public Builder computeQuotaConfig(ComputeQuotaConfig var1);

        default public Builder computeQuotaConfig(Consumer<ComputeQuotaConfig.Builder> computeQuotaConfig) {
            return this.computeQuotaConfig((ComputeQuotaConfig)((ComputeQuotaConfig.Builder)ComputeQuotaConfig.builder().applyMutation(computeQuotaConfig)).build());
        }

        public Builder computeQuotaTarget(ComputeQuotaTarget var1);

        default public Builder computeQuotaTarget(Consumer<ComputeQuotaTarget.Builder> computeQuotaTarget) {
            return this.computeQuotaTarget((ComputeQuotaTarget)((ComputeQuotaTarget.Builder)ComputeQuotaTarget.builder().applyMutation(computeQuotaTarget)).build());
        }

        public Builder activationState(String var1);

        public Builder activationState(ActivationState var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

