/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sagemaker.model.DeployedImage;
import software.amazon.awssdk.services.sagemaker.model.EnvironmentMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InferenceComponentContainerSpecificationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InferenceComponentContainerSpecificationSummary> {
    private static final SdkField<DeployedImage> DEPLOYED_IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeployedImage").getter(InferenceComponentContainerSpecificationSummary.getter(InferenceComponentContainerSpecificationSummary::deployedImage)).setter(InferenceComponentContainerSpecificationSummary.setter(Builder::deployedImage)).constructor(DeployedImage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeployedImage").build()}).build();
    private static final SdkField<String> ARTIFACT_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ArtifactUrl").getter(InferenceComponentContainerSpecificationSummary.getter(InferenceComponentContainerSpecificationSummary::artifactUrl)).setter(InferenceComponentContainerSpecificationSummary.setter(Builder::artifactUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArtifactUrl").build()}).build();
    private static final SdkField<Map<String, String>> ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Environment").getter(InferenceComponentContainerSpecificationSummary.getter(InferenceComponentContainerSpecificationSummary::environment)).setter(InferenceComponentContainerSpecificationSummary.setter(Builder::environment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Environment").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYED_IMAGE_FIELD, ARTIFACT_URL_FIELD, ENVIRONMENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InferenceComponentContainerSpecificationSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final DeployedImage deployedImage;
    private final String artifactUrl;
    private final Map<String, String> environment;

    private InferenceComponentContainerSpecificationSummary(BuilderImpl builder) {
        this.deployedImage = builder.deployedImage;
        this.artifactUrl = builder.artifactUrl;
        this.environment = builder.environment;
    }

    public final DeployedImage deployedImage() {
        return this.deployedImage;
    }

    public final String artifactUrl() {
        return this.artifactUrl;
    }

    public final boolean hasEnvironment() {
        return this.environment != null && !(this.environment instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> environment() {
        return this.environment;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deployedImage());
        hashCode = 31 * hashCode + Objects.hashCode(this.artifactUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironment() ? this.environment() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferenceComponentContainerSpecificationSummary)) {
            return false;
        }
        InferenceComponentContainerSpecificationSummary other = (InferenceComponentContainerSpecificationSummary)obj;
        return Objects.equals(this.deployedImage(), other.deployedImage()) && Objects.equals(this.artifactUrl(), other.artifactUrl()) && this.hasEnvironment() == other.hasEnvironment() && Objects.equals(this.environment(), other.environment());
    }

    public final String toString() {
        return ToString.builder((String)"InferenceComponentContainerSpecificationSummary").add("DeployedImage", (Object)this.deployedImage()).add("ArtifactUrl", (Object)this.artifactUrl()).add("Environment", this.hasEnvironment() ? this.environment() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeployedImage": {
                return Optional.ofNullable(clazz.cast(this.deployedImage()));
            }
            case "ArtifactUrl": {
                return Optional.ofNullable(clazz.cast(this.artifactUrl()));
            }
            case "Environment": {
                return Optional.ofNullable(clazz.cast(this.environment()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DeployedImage", DEPLOYED_IMAGE_FIELD);
        map.put("ArtifactUrl", ARTIFACT_URL_FIELD);
        map.put("Environment", ENVIRONMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InferenceComponentContainerSpecificationSummary, T> g) {
        return obj -> g.apply((InferenceComponentContainerSpecificationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DeployedImage deployedImage;
        private String artifactUrl;
        private Map<String, String> environment = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InferenceComponentContainerSpecificationSummary model) {
            this.deployedImage(model.deployedImage);
            this.artifactUrl(model.artifactUrl);
            this.environment(model.environment);
        }

        public final DeployedImage.Builder getDeployedImage() {
            return this.deployedImage != null ? this.deployedImage.toBuilder() : null;
        }

        public final void setDeployedImage(DeployedImage.BuilderImpl deployedImage) {
            this.deployedImage = deployedImage != null ? deployedImage.build() : null;
        }

        @Override
        public final Builder deployedImage(DeployedImage deployedImage) {
            this.deployedImage = deployedImage;
            return this;
        }

        public final String getArtifactUrl() {
            return this.artifactUrl;
        }

        public final void setArtifactUrl(String artifactUrl) {
            this.artifactUrl = artifactUrl;
        }

        @Override
        public final Builder artifactUrl(String artifactUrl) {
            this.artifactUrl = artifactUrl;
            return this;
        }

        public final Map<String, String> getEnvironment() {
            if (this.environment instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.environment;
        }

        public final void setEnvironment(Map<String, String> environment) {
            this.environment = EnvironmentMapCopier.copy(environment);
        }

        @Override
        public final Builder environment(Map<String, String> environment) {
            this.environment = EnvironmentMapCopier.copy(environment);
            return this;
        }

        public InferenceComponentContainerSpecificationSummary build() {
            return new InferenceComponentContainerSpecificationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InferenceComponentContainerSpecificationSummary> {
        public Builder deployedImage(DeployedImage var1);

        default public Builder deployedImage(Consumer<DeployedImage.Builder> deployedImage) {
            return this.deployedImage((DeployedImage)((DeployedImage.Builder)DeployedImage.builder().applyMutation(deployedImage)).build());
        }

        public Builder artifactUrl(String var1);

        public Builder environment(Map<String, String> var1);
    }
}

