/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.services.sagemaker.model.TrainingPlanSummariesCopier;
import software.amazon.awssdk.services.sagemaker.model.TrainingPlanSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTrainingPlansResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, ListTrainingPlansResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListTrainingPlansResponse.getter(ListTrainingPlansResponse::nextToken)).setter(ListTrainingPlansResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<TrainingPlanSummary>> TRAINING_PLAN_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TrainingPlanSummaries").getter(ListTrainingPlansResponse.getter(ListTrainingPlansResponse::trainingPlanSummaries)).setter(ListTrainingPlansResponse.setter(Builder::trainingPlanSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingPlanSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TrainingPlanSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, TRAINING_PLAN_SUMMARIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListTrainingPlansResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<TrainingPlanSummary> trainingPlanSummaries;

    private ListTrainingPlansResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.trainingPlanSummaries = builder.trainingPlanSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasTrainingPlanSummaries() {
        return this.trainingPlanSummaries != null && !(this.trainingPlanSummaries instanceof SdkAutoConstructList);
    }

    public final List<TrainingPlanSummary> trainingPlanSummaries() {
        return this.trainingPlanSummaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTrainingPlanSummaries() ? this.trainingPlanSummaries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrainingPlansResponse)) {
            return false;
        }
        ListTrainingPlansResponse other = (ListTrainingPlansResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasTrainingPlanSummaries() == other.hasTrainingPlanSummaries() && Objects.equals(this.trainingPlanSummaries(), other.trainingPlanSummaries());
    }

    public final String toString() {
        return ToString.builder((String)"ListTrainingPlansResponse").add("NextToken", (Object)this.nextToken()).add("TrainingPlanSummaries", this.hasTrainingPlanSummaries() ? this.trainingPlanSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "TrainingPlanSummaries": {
                return Optional.ofNullable(clazz.cast(this.trainingPlanSummaries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("TrainingPlanSummaries", TRAINING_PLAN_SUMMARIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTrainingPlansResponse, T> g) {
        return obj -> g.apply((ListTrainingPlansResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<TrainingPlanSummary> trainingPlanSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListTrainingPlansResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.trainingPlanSummaries(model.trainingPlanSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<TrainingPlanSummary.Builder> getTrainingPlanSummaries() {
            List<TrainingPlanSummary.Builder> result = TrainingPlanSummariesCopier.copyToBuilder(this.trainingPlanSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTrainingPlanSummaries(Collection<TrainingPlanSummary.BuilderImpl> trainingPlanSummaries) {
            this.trainingPlanSummaries = TrainingPlanSummariesCopier.copyFromBuilder(trainingPlanSummaries);
        }

        @Override
        public final Builder trainingPlanSummaries(Collection<TrainingPlanSummary> trainingPlanSummaries) {
            this.trainingPlanSummaries = TrainingPlanSummariesCopier.copy(trainingPlanSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trainingPlanSummaries(TrainingPlanSummary ... trainingPlanSummaries) {
            this.trainingPlanSummaries(Arrays.asList(trainingPlanSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trainingPlanSummaries(Consumer<TrainingPlanSummary.Builder> ... trainingPlanSummaries) {
            this.trainingPlanSummaries(Stream.of(trainingPlanSummaries).map(c -> (TrainingPlanSummary)((TrainingPlanSummary.Builder)TrainingPlanSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListTrainingPlansResponse build() {
            return new ListTrainingPlansResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTrainingPlansResponse> {
        public Builder nextToken(String var1);

        public Builder trainingPlanSummaries(Collection<TrainingPlanSummary> var1);

        public Builder trainingPlanSummaries(TrainingPlanSummary ... var1);

        public Builder trainingPlanSummaries(Consumer<TrainingPlanSummary.Builder> ... var1);
    }
}

