/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.TrackingServerSize;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateMlflowTrackingServerRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, UpdateMlflowTrackingServerRequest> {
    private static final SdkField<String> TRACKING_SERVER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrackingServerName").getter(UpdateMlflowTrackingServerRequest.getter(UpdateMlflowTrackingServerRequest::trackingServerName)).setter(UpdateMlflowTrackingServerRequest.setter(Builder::trackingServerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrackingServerName").build()}).build();
    private static final SdkField<String> ARTIFACT_STORE_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ArtifactStoreUri").getter(UpdateMlflowTrackingServerRequest.getter(UpdateMlflowTrackingServerRequest::artifactStoreUri)).setter(UpdateMlflowTrackingServerRequest.setter(Builder::artifactStoreUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArtifactStoreUri").build()}).build();
    private static final SdkField<String> TRACKING_SERVER_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrackingServerSize").getter(UpdateMlflowTrackingServerRequest.getter(UpdateMlflowTrackingServerRequest::trackingServerSizeAsString)).setter(UpdateMlflowTrackingServerRequest.setter(Builder::trackingServerSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrackingServerSize").build()}).build();
    private static final SdkField<Boolean> AUTOMATIC_MODEL_REGISTRATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutomaticModelRegistration").getter(UpdateMlflowTrackingServerRequest.getter(UpdateMlflowTrackingServerRequest::automaticModelRegistration)).setter(UpdateMlflowTrackingServerRequest.setter(Builder::automaticModelRegistration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomaticModelRegistration").build()}).build();
    private static final SdkField<String> WEEKLY_MAINTENANCE_WINDOW_START_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WeeklyMaintenanceWindowStart").getter(UpdateMlflowTrackingServerRequest.getter(UpdateMlflowTrackingServerRequest::weeklyMaintenanceWindowStart)).setter(UpdateMlflowTrackingServerRequest.setter(Builder::weeklyMaintenanceWindowStart)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeeklyMaintenanceWindowStart").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRACKING_SERVER_NAME_FIELD, ARTIFACT_STORE_URI_FIELD, TRACKING_SERVER_SIZE_FIELD, AUTOMATIC_MODEL_REGISTRATION_FIELD, WEEKLY_MAINTENANCE_WINDOW_START_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateMlflowTrackingServerRequest.memberNameToFieldInitializer();
    private final String trackingServerName;
    private final String artifactStoreUri;
    private final String trackingServerSize;
    private final Boolean automaticModelRegistration;
    private final String weeklyMaintenanceWindowStart;

    private UpdateMlflowTrackingServerRequest(BuilderImpl builder) {
        super(builder);
        this.trackingServerName = builder.trackingServerName;
        this.artifactStoreUri = builder.artifactStoreUri;
        this.trackingServerSize = builder.trackingServerSize;
        this.automaticModelRegistration = builder.automaticModelRegistration;
        this.weeklyMaintenanceWindowStart = builder.weeklyMaintenanceWindowStart;
    }

    public final String trackingServerName() {
        return this.trackingServerName;
    }

    public final String artifactStoreUri() {
        return this.artifactStoreUri;
    }

    public final TrackingServerSize trackingServerSize() {
        return TrackingServerSize.fromValue(this.trackingServerSize);
    }

    public final String trackingServerSizeAsString() {
        return this.trackingServerSize;
    }

    public final Boolean automaticModelRegistration() {
        return this.automaticModelRegistration;
    }

    public final String weeklyMaintenanceWindowStart() {
        return this.weeklyMaintenanceWindowStart;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.trackingServerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.artifactStoreUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.trackingServerSizeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.automaticModelRegistration());
        hashCode = 31 * hashCode + Objects.hashCode(this.weeklyMaintenanceWindowStart());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMlflowTrackingServerRequest)) {
            return false;
        }
        UpdateMlflowTrackingServerRequest other = (UpdateMlflowTrackingServerRequest)((Object)obj);
        return Objects.equals(this.trackingServerName(), other.trackingServerName()) && Objects.equals(this.artifactStoreUri(), other.artifactStoreUri()) && Objects.equals(this.trackingServerSizeAsString(), other.trackingServerSizeAsString()) && Objects.equals(this.automaticModelRegistration(), other.automaticModelRegistration()) && Objects.equals(this.weeklyMaintenanceWindowStart(), other.weeklyMaintenanceWindowStart());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateMlflowTrackingServerRequest").add("TrackingServerName", (Object)this.trackingServerName()).add("ArtifactStoreUri", (Object)this.artifactStoreUri()).add("TrackingServerSize", (Object)this.trackingServerSizeAsString()).add("AutomaticModelRegistration", (Object)this.automaticModelRegistration()).add("WeeklyMaintenanceWindowStart", (Object)this.weeklyMaintenanceWindowStart()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrackingServerName": {
                return Optional.ofNullable(clazz.cast(this.trackingServerName()));
            }
            case "ArtifactStoreUri": {
                return Optional.ofNullable(clazz.cast(this.artifactStoreUri()));
            }
            case "TrackingServerSize": {
                return Optional.ofNullable(clazz.cast(this.trackingServerSizeAsString()));
            }
            case "AutomaticModelRegistration": {
                return Optional.ofNullable(clazz.cast(this.automaticModelRegistration()));
            }
            case "WeeklyMaintenanceWindowStart": {
                return Optional.ofNullable(clazz.cast(this.weeklyMaintenanceWindowStart()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TrackingServerName", TRACKING_SERVER_NAME_FIELD);
        map.put("ArtifactStoreUri", ARTIFACT_STORE_URI_FIELD);
        map.put("TrackingServerSize", TRACKING_SERVER_SIZE_FIELD);
        map.put("AutomaticModelRegistration", AUTOMATIC_MODEL_REGISTRATION_FIELD);
        map.put("WeeklyMaintenanceWindowStart", WEEKLY_MAINTENANCE_WINDOW_START_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateMlflowTrackingServerRequest, T> g) {
        return obj -> g.apply((UpdateMlflowTrackingServerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String trackingServerName;
        private String artifactStoreUri;
        private String trackingServerSize;
        private Boolean automaticModelRegistration;
        private String weeklyMaintenanceWindowStart;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMlflowTrackingServerRequest model) {
            super(model);
            this.trackingServerName(model.trackingServerName);
            this.artifactStoreUri(model.artifactStoreUri);
            this.trackingServerSize(model.trackingServerSize);
            this.automaticModelRegistration(model.automaticModelRegistration);
            this.weeklyMaintenanceWindowStart(model.weeklyMaintenanceWindowStart);
        }

        public final String getTrackingServerName() {
            return this.trackingServerName;
        }

        public final void setTrackingServerName(String trackingServerName) {
            this.trackingServerName = trackingServerName;
        }

        @Override
        public final Builder trackingServerName(String trackingServerName) {
            this.trackingServerName = trackingServerName;
            return this;
        }

        public final String getArtifactStoreUri() {
            return this.artifactStoreUri;
        }

        public final void setArtifactStoreUri(String artifactStoreUri) {
            this.artifactStoreUri = artifactStoreUri;
        }

        @Override
        public final Builder artifactStoreUri(String artifactStoreUri) {
            this.artifactStoreUri = artifactStoreUri;
            return this;
        }

        public final String getTrackingServerSize() {
            return this.trackingServerSize;
        }

        public final void setTrackingServerSize(String trackingServerSize) {
            this.trackingServerSize = trackingServerSize;
        }

        @Override
        public final Builder trackingServerSize(String trackingServerSize) {
            this.trackingServerSize = trackingServerSize;
            return this;
        }

        @Override
        public final Builder trackingServerSize(TrackingServerSize trackingServerSize) {
            this.trackingServerSize(trackingServerSize == null ? null : trackingServerSize.toString());
            return this;
        }

        public final Boolean getAutomaticModelRegistration() {
            return this.automaticModelRegistration;
        }

        public final void setAutomaticModelRegistration(Boolean automaticModelRegistration) {
            this.automaticModelRegistration = automaticModelRegistration;
        }

        @Override
        public final Builder automaticModelRegistration(Boolean automaticModelRegistration) {
            this.automaticModelRegistration = automaticModelRegistration;
            return this;
        }

        public final String getWeeklyMaintenanceWindowStart() {
            return this.weeklyMaintenanceWindowStart;
        }

        public final void setWeeklyMaintenanceWindowStart(String weeklyMaintenanceWindowStart) {
            this.weeklyMaintenanceWindowStart = weeklyMaintenanceWindowStart;
        }

        @Override
        public final Builder weeklyMaintenanceWindowStart(String weeklyMaintenanceWindowStart) {
            this.weeklyMaintenanceWindowStart = weeklyMaintenanceWindowStart;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMlflowTrackingServerRequest build() {
            return new UpdateMlflowTrackingServerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateMlflowTrackingServerRequest> {
        public Builder trackingServerName(String var1);

        public Builder artifactStoreUri(String var1);

        public Builder trackingServerSize(String var1);

        public Builder trackingServerSize(TrackingServerSize var1);

        public Builder automaticModelRegistration(Boolean var1);

        public Builder weeklyMaintenanceWindowStart(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

