/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.StageStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EdgeDeploymentStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EdgeDeploymentStatus> {
    private static final SdkField<String> STAGE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StageStatus").getter(EdgeDeploymentStatus.getter(EdgeDeploymentStatus::stageStatusAsString)).setter(EdgeDeploymentStatus.setter(Builder::stageStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StageStatus").build()}).build();
    private static final SdkField<Integer> EDGE_DEPLOYMENT_SUCCESS_IN_STAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("EdgeDeploymentSuccessInStage").getter(EdgeDeploymentStatus.getter(EdgeDeploymentStatus::edgeDeploymentSuccessInStage)).setter(EdgeDeploymentStatus.setter(Builder::edgeDeploymentSuccessInStage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeDeploymentSuccessInStage").build()}).build();
    private static final SdkField<Integer> EDGE_DEPLOYMENT_PENDING_IN_STAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("EdgeDeploymentPendingInStage").getter(EdgeDeploymentStatus.getter(EdgeDeploymentStatus::edgeDeploymentPendingInStage)).setter(EdgeDeploymentStatus.setter(Builder::edgeDeploymentPendingInStage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeDeploymentPendingInStage").build()}).build();
    private static final SdkField<Integer> EDGE_DEPLOYMENT_FAILED_IN_STAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("EdgeDeploymentFailedInStage").getter(EdgeDeploymentStatus.getter(EdgeDeploymentStatus::edgeDeploymentFailedInStage)).setter(EdgeDeploymentStatus.setter(Builder::edgeDeploymentFailedInStage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeDeploymentFailedInStage").build()}).build();
    private static final SdkField<String> EDGE_DEPLOYMENT_STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EdgeDeploymentStatusMessage").getter(EdgeDeploymentStatus.getter(EdgeDeploymentStatus::edgeDeploymentStatusMessage)).setter(EdgeDeploymentStatus.setter(Builder::edgeDeploymentStatusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeDeploymentStatusMessage").build()}).build();
    private static final SdkField<Instant> EDGE_DEPLOYMENT_STAGE_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EdgeDeploymentStageStartTime").getter(EdgeDeploymentStatus.getter(EdgeDeploymentStatus::edgeDeploymentStageStartTime)).setter(EdgeDeploymentStatus.setter(Builder::edgeDeploymentStageStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeDeploymentStageStartTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STAGE_STATUS_FIELD, EDGE_DEPLOYMENT_SUCCESS_IN_STAGE_FIELD, EDGE_DEPLOYMENT_PENDING_IN_STAGE_FIELD, EDGE_DEPLOYMENT_FAILED_IN_STAGE_FIELD, EDGE_DEPLOYMENT_STATUS_MESSAGE_FIELD, EDGE_DEPLOYMENT_STAGE_START_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EdgeDeploymentStatus.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String stageStatus;
    private final Integer edgeDeploymentSuccessInStage;
    private final Integer edgeDeploymentPendingInStage;
    private final Integer edgeDeploymentFailedInStage;
    private final String edgeDeploymentStatusMessage;
    private final Instant edgeDeploymentStageStartTime;

    private EdgeDeploymentStatus(BuilderImpl builder) {
        this.stageStatus = builder.stageStatus;
        this.edgeDeploymentSuccessInStage = builder.edgeDeploymentSuccessInStage;
        this.edgeDeploymentPendingInStage = builder.edgeDeploymentPendingInStage;
        this.edgeDeploymentFailedInStage = builder.edgeDeploymentFailedInStage;
        this.edgeDeploymentStatusMessage = builder.edgeDeploymentStatusMessage;
        this.edgeDeploymentStageStartTime = builder.edgeDeploymentStageStartTime;
    }

    public final StageStatus stageStatus() {
        return StageStatus.fromValue(this.stageStatus);
    }

    public final String stageStatusAsString() {
        return this.stageStatus;
    }

    public final Integer edgeDeploymentSuccessInStage() {
        return this.edgeDeploymentSuccessInStage;
    }

    public final Integer edgeDeploymentPendingInStage() {
        return this.edgeDeploymentPendingInStage;
    }

    public final Integer edgeDeploymentFailedInStage() {
        return this.edgeDeploymentFailedInStage;
    }

    public final String edgeDeploymentStatusMessage() {
        return this.edgeDeploymentStatusMessage;
    }

    public final Instant edgeDeploymentStageStartTime() {
        return this.edgeDeploymentStageStartTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stageStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.edgeDeploymentSuccessInStage());
        hashCode = 31 * hashCode + Objects.hashCode(this.edgeDeploymentPendingInStage());
        hashCode = 31 * hashCode + Objects.hashCode(this.edgeDeploymentFailedInStage());
        hashCode = 31 * hashCode + Objects.hashCode(this.edgeDeploymentStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.edgeDeploymentStageStartTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EdgeDeploymentStatus)) {
            return false;
        }
        EdgeDeploymentStatus other = (EdgeDeploymentStatus)obj;
        return Objects.equals(this.stageStatusAsString(), other.stageStatusAsString()) && Objects.equals(this.edgeDeploymentSuccessInStage(), other.edgeDeploymentSuccessInStage()) && Objects.equals(this.edgeDeploymentPendingInStage(), other.edgeDeploymentPendingInStage()) && Objects.equals(this.edgeDeploymentFailedInStage(), other.edgeDeploymentFailedInStage()) && Objects.equals(this.edgeDeploymentStatusMessage(), other.edgeDeploymentStatusMessage()) && Objects.equals(this.edgeDeploymentStageStartTime(), other.edgeDeploymentStageStartTime());
    }

    public final String toString() {
        return ToString.builder((String)"EdgeDeploymentStatus").add("StageStatus", (Object)this.stageStatusAsString()).add("EdgeDeploymentSuccessInStage", (Object)this.edgeDeploymentSuccessInStage()).add("EdgeDeploymentPendingInStage", (Object)this.edgeDeploymentPendingInStage()).add("EdgeDeploymentFailedInStage", (Object)this.edgeDeploymentFailedInStage()).add("EdgeDeploymentStatusMessage", (Object)this.edgeDeploymentStatusMessage()).add("EdgeDeploymentStageStartTime", (Object)this.edgeDeploymentStageStartTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StageStatus": {
                return Optional.ofNullable(clazz.cast(this.stageStatusAsString()));
            }
            case "EdgeDeploymentSuccessInStage": {
                return Optional.ofNullable(clazz.cast(this.edgeDeploymentSuccessInStage()));
            }
            case "EdgeDeploymentPendingInStage": {
                return Optional.ofNullable(clazz.cast(this.edgeDeploymentPendingInStage()));
            }
            case "EdgeDeploymentFailedInStage": {
                return Optional.ofNullable(clazz.cast(this.edgeDeploymentFailedInStage()));
            }
            case "EdgeDeploymentStatusMessage": {
                return Optional.ofNullable(clazz.cast(this.edgeDeploymentStatusMessage()));
            }
            case "EdgeDeploymentStageStartTime": {
                return Optional.ofNullable(clazz.cast(this.edgeDeploymentStageStartTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StageStatus", STAGE_STATUS_FIELD);
        map.put("EdgeDeploymentSuccessInStage", EDGE_DEPLOYMENT_SUCCESS_IN_STAGE_FIELD);
        map.put("EdgeDeploymentPendingInStage", EDGE_DEPLOYMENT_PENDING_IN_STAGE_FIELD);
        map.put("EdgeDeploymentFailedInStage", EDGE_DEPLOYMENT_FAILED_IN_STAGE_FIELD);
        map.put("EdgeDeploymentStatusMessage", EDGE_DEPLOYMENT_STATUS_MESSAGE_FIELD);
        map.put("EdgeDeploymentStageStartTime", EDGE_DEPLOYMENT_STAGE_START_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EdgeDeploymentStatus, T> g) {
        return obj -> g.apply((EdgeDeploymentStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String stageStatus;
        private Integer edgeDeploymentSuccessInStage;
        private Integer edgeDeploymentPendingInStage;
        private Integer edgeDeploymentFailedInStage;
        private String edgeDeploymentStatusMessage;
        private Instant edgeDeploymentStageStartTime;

        private BuilderImpl() {
        }

        private BuilderImpl(EdgeDeploymentStatus model) {
            this.stageStatus(model.stageStatus);
            this.edgeDeploymentSuccessInStage(model.edgeDeploymentSuccessInStage);
            this.edgeDeploymentPendingInStage(model.edgeDeploymentPendingInStage);
            this.edgeDeploymentFailedInStage(model.edgeDeploymentFailedInStage);
            this.edgeDeploymentStatusMessage(model.edgeDeploymentStatusMessage);
            this.edgeDeploymentStageStartTime(model.edgeDeploymentStageStartTime);
        }

        public final String getStageStatus() {
            return this.stageStatus;
        }

        public final void setStageStatus(String stageStatus) {
            this.stageStatus = stageStatus;
        }

        @Override
        public final Builder stageStatus(String stageStatus) {
            this.stageStatus = stageStatus;
            return this;
        }

        @Override
        public final Builder stageStatus(StageStatus stageStatus) {
            this.stageStatus(stageStatus == null ? null : stageStatus.toString());
            return this;
        }

        public final Integer getEdgeDeploymentSuccessInStage() {
            return this.edgeDeploymentSuccessInStage;
        }

        public final void setEdgeDeploymentSuccessInStage(Integer edgeDeploymentSuccessInStage) {
            this.edgeDeploymentSuccessInStage = edgeDeploymentSuccessInStage;
        }

        @Override
        public final Builder edgeDeploymentSuccessInStage(Integer edgeDeploymentSuccessInStage) {
            this.edgeDeploymentSuccessInStage = edgeDeploymentSuccessInStage;
            return this;
        }

        public final Integer getEdgeDeploymentPendingInStage() {
            return this.edgeDeploymentPendingInStage;
        }

        public final void setEdgeDeploymentPendingInStage(Integer edgeDeploymentPendingInStage) {
            this.edgeDeploymentPendingInStage = edgeDeploymentPendingInStage;
        }

        @Override
        public final Builder edgeDeploymentPendingInStage(Integer edgeDeploymentPendingInStage) {
            this.edgeDeploymentPendingInStage = edgeDeploymentPendingInStage;
            return this;
        }

        public final Integer getEdgeDeploymentFailedInStage() {
            return this.edgeDeploymentFailedInStage;
        }

        public final void setEdgeDeploymentFailedInStage(Integer edgeDeploymentFailedInStage) {
            this.edgeDeploymentFailedInStage = edgeDeploymentFailedInStage;
        }

        @Override
        public final Builder edgeDeploymentFailedInStage(Integer edgeDeploymentFailedInStage) {
            this.edgeDeploymentFailedInStage = edgeDeploymentFailedInStage;
            return this;
        }

        public final String getEdgeDeploymentStatusMessage() {
            return this.edgeDeploymentStatusMessage;
        }

        public final void setEdgeDeploymentStatusMessage(String edgeDeploymentStatusMessage) {
            this.edgeDeploymentStatusMessage = edgeDeploymentStatusMessage;
        }

        @Override
        public final Builder edgeDeploymentStatusMessage(String edgeDeploymentStatusMessage) {
            this.edgeDeploymentStatusMessage = edgeDeploymentStatusMessage;
            return this;
        }

        public final Instant getEdgeDeploymentStageStartTime() {
            return this.edgeDeploymentStageStartTime;
        }

        public final void setEdgeDeploymentStageStartTime(Instant edgeDeploymentStageStartTime) {
            this.edgeDeploymentStageStartTime = edgeDeploymentStageStartTime;
        }

        @Override
        public final Builder edgeDeploymentStageStartTime(Instant edgeDeploymentStageStartTime) {
            this.edgeDeploymentStageStartTime = edgeDeploymentStageStartTime;
            return this;
        }

        public EdgeDeploymentStatus build() {
            return new EdgeDeploymentStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EdgeDeploymentStatus> {
        public Builder stageStatus(String var1);

        public Builder stageStatus(StageStatus var1);

        public Builder edgeDeploymentSuccessInStage(Integer var1);

        public Builder edgeDeploymentPendingInStage(Integer var1);

        public Builder edgeDeploymentFailedInStage(Integer var1);

        public Builder edgeDeploymentStatusMessage(String var1);

        public Builder edgeDeploymentStageStartTime(Instant var1);
    }
}

