/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.BestObjectiveNotImproving;
import software.amazon.awssdk.services.sagemaker.model.ConvergenceDetected;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TuningJobCompletionCriteria
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TuningJobCompletionCriteria> {
    private static final SdkField<Float> TARGET_OBJECTIVE_METRIC_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("TargetObjectiveMetricValue").getter(TuningJobCompletionCriteria.getter(TuningJobCompletionCriteria::targetObjectiveMetricValue)).setter(TuningJobCompletionCriteria.setter(Builder::targetObjectiveMetricValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetObjectiveMetricValue").build()}).build();
    private static final SdkField<BestObjectiveNotImproving> BEST_OBJECTIVE_NOT_IMPROVING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BestObjectiveNotImproving").getter(TuningJobCompletionCriteria.getter(TuningJobCompletionCriteria::bestObjectiveNotImproving)).setter(TuningJobCompletionCriteria.setter(Builder::bestObjectiveNotImproving)).constructor(BestObjectiveNotImproving::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BestObjectiveNotImproving").build()}).build();
    private static final SdkField<ConvergenceDetected> CONVERGENCE_DETECTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConvergenceDetected").getter(TuningJobCompletionCriteria.getter(TuningJobCompletionCriteria::convergenceDetected)).setter(TuningJobCompletionCriteria.setter(Builder::convergenceDetected)).constructor(ConvergenceDetected::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConvergenceDetected").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_OBJECTIVE_METRIC_VALUE_FIELD, BEST_OBJECTIVE_NOT_IMPROVING_FIELD, CONVERGENCE_DETECTED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TuningJobCompletionCriteria.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Float targetObjectiveMetricValue;
    private final BestObjectiveNotImproving bestObjectiveNotImproving;
    private final ConvergenceDetected convergenceDetected;

    private TuningJobCompletionCriteria(BuilderImpl builder) {
        this.targetObjectiveMetricValue = builder.targetObjectiveMetricValue;
        this.bestObjectiveNotImproving = builder.bestObjectiveNotImproving;
        this.convergenceDetected = builder.convergenceDetected;
    }

    public final Float targetObjectiveMetricValue() {
        return this.targetObjectiveMetricValue;
    }

    public final BestObjectiveNotImproving bestObjectiveNotImproving() {
        return this.bestObjectiveNotImproving;
    }

    public final ConvergenceDetected convergenceDetected() {
        return this.convergenceDetected;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.targetObjectiveMetricValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.bestObjectiveNotImproving());
        hashCode = 31 * hashCode + Objects.hashCode(this.convergenceDetected());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TuningJobCompletionCriteria)) {
            return false;
        }
        TuningJobCompletionCriteria other = (TuningJobCompletionCriteria)obj;
        return Objects.equals(this.targetObjectiveMetricValue(), other.targetObjectiveMetricValue()) && Objects.equals(this.bestObjectiveNotImproving(), other.bestObjectiveNotImproving()) && Objects.equals(this.convergenceDetected(), other.convergenceDetected());
    }

    public final String toString() {
        return ToString.builder((String)"TuningJobCompletionCriteria").add("TargetObjectiveMetricValue", (Object)this.targetObjectiveMetricValue()).add("BestObjectiveNotImproving", (Object)this.bestObjectiveNotImproving()).add("ConvergenceDetected", (Object)this.convergenceDetected()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetObjectiveMetricValue": {
                return Optional.ofNullable(clazz.cast(this.targetObjectiveMetricValue()));
            }
            case "BestObjectiveNotImproving": {
                return Optional.ofNullable(clazz.cast(this.bestObjectiveNotImproving()));
            }
            case "ConvergenceDetected": {
                return Optional.ofNullable(clazz.cast(this.convergenceDetected()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TargetObjectiveMetricValue", TARGET_OBJECTIVE_METRIC_VALUE_FIELD);
        map.put("BestObjectiveNotImproving", BEST_OBJECTIVE_NOT_IMPROVING_FIELD);
        map.put("ConvergenceDetected", CONVERGENCE_DETECTED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TuningJobCompletionCriteria, T> g) {
        return obj -> g.apply((TuningJobCompletionCriteria)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Float targetObjectiveMetricValue;
        private BestObjectiveNotImproving bestObjectiveNotImproving;
        private ConvergenceDetected convergenceDetected;

        private BuilderImpl() {
        }

        private BuilderImpl(TuningJobCompletionCriteria model) {
            this.targetObjectiveMetricValue(model.targetObjectiveMetricValue);
            this.bestObjectiveNotImproving(model.bestObjectiveNotImproving);
            this.convergenceDetected(model.convergenceDetected);
        }

        public final Float getTargetObjectiveMetricValue() {
            return this.targetObjectiveMetricValue;
        }

        public final void setTargetObjectiveMetricValue(Float targetObjectiveMetricValue) {
            this.targetObjectiveMetricValue = targetObjectiveMetricValue;
        }

        @Override
        public final Builder targetObjectiveMetricValue(Float targetObjectiveMetricValue) {
            this.targetObjectiveMetricValue = targetObjectiveMetricValue;
            return this;
        }

        public final BestObjectiveNotImproving.Builder getBestObjectiveNotImproving() {
            return this.bestObjectiveNotImproving != null ? this.bestObjectiveNotImproving.toBuilder() : null;
        }

        public final void setBestObjectiveNotImproving(BestObjectiveNotImproving.BuilderImpl bestObjectiveNotImproving) {
            this.bestObjectiveNotImproving = bestObjectiveNotImproving != null ? bestObjectiveNotImproving.build() : null;
        }

        @Override
        public final Builder bestObjectiveNotImproving(BestObjectiveNotImproving bestObjectiveNotImproving) {
            this.bestObjectiveNotImproving = bestObjectiveNotImproving;
            return this;
        }

        public final ConvergenceDetected.Builder getConvergenceDetected() {
            return this.convergenceDetected != null ? this.convergenceDetected.toBuilder() : null;
        }

        public final void setConvergenceDetected(ConvergenceDetected.BuilderImpl convergenceDetected) {
            this.convergenceDetected = convergenceDetected != null ? convergenceDetected.build() : null;
        }

        @Override
        public final Builder convergenceDetected(ConvergenceDetected convergenceDetected) {
            this.convergenceDetected = convergenceDetected;
            return this;
        }

        public TuningJobCompletionCriteria build() {
            return new TuningJobCompletionCriteria(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TuningJobCompletionCriteria> {
        public Builder targetObjectiveMetricValue(Float var1);

        public Builder bestObjectiveNotImproving(BestObjectiveNotImproving var1);

        default public Builder bestObjectiveNotImproving(Consumer<BestObjectiveNotImproving.Builder> bestObjectiveNotImproving) {
            return this.bestObjectiveNotImproving((BestObjectiveNotImproving)((BestObjectiveNotImproving.Builder)BestObjectiveNotImproving.builder().applyMutation(bestObjectiveNotImproving)).build());
        }

        public Builder convergenceDetected(ConvergenceDetected var1);

        default public Builder convergenceDetected(Consumer<ConvergenceDetected.Builder> convergenceDetected) {
            return this.convergenceDetected((ConvergenceDetected)((ConvergenceDetected.Builder)ConvergenceDetected.builder().applyMutation(convergenceDetected)).build());
        }
    }
}

