/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TransformJobStatus {
    IN_PROGRESS("InProgress"),
    COMPLETED("Completed"),
    FAILED("Failed"),
    STOPPING("Stopping"),
    STOPPED("Stopped"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TransformJobStatus> VALUE_MAP;
    private final String value;

    private TransformJobStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TransformJobStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TransformJobStatus> knownValues() {
        EnumSet<TransformJobStatus> knownValues = EnumSet.allOf(TransformJobStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TransformJobStatus.class, TransformJobStatus::toString);
    }
}

