/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.OptimizationJobModelSourceS3;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OptimizationJobModelSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OptimizationJobModelSource> {
    private static final SdkField<OptimizationJobModelSourceS3> S3_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3").getter(OptimizationJobModelSource.getter(OptimizationJobModelSource::s3)).setter(OptimizationJobModelSource.setter(Builder::s3)).constructor(OptimizationJobModelSourceS3::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OptimizationJobModelSource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final OptimizationJobModelSourceS3 s3;

    private OptimizationJobModelSource(BuilderImpl builder) {
        this.s3 = builder.s3;
    }

    public final OptimizationJobModelSourceS3 s3() {
        return this.s3;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OptimizationJobModelSource)) {
            return false;
        }
        OptimizationJobModelSource other = (OptimizationJobModelSource)obj;
        return Objects.equals(this.s3(), other.s3());
    }

    public final String toString() {
        return ToString.builder((String)"OptimizationJobModelSource").add("S3", (Object)this.s3()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3": {
                return Optional.ofNullable(clazz.cast(this.s3()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<OptimizationJobModelSourceS3>> map = new HashMap<String, SdkField<OptimizationJobModelSourceS3>>();
        map.put("S3", S3_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OptimizationJobModelSource, T> g) {
        return obj -> g.apply((OptimizationJobModelSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private OptimizationJobModelSourceS3 s3;

        private BuilderImpl() {
        }

        private BuilderImpl(OptimizationJobModelSource model) {
            this.s3(model.s3);
        }

        public final OptimizationJobModelSourceS3.Builder getS3() {
            return this.s3 != null ? this.s3.toBuilder() : null;
        }

        public final void setS3(OptimizationJobModelSourceS3.BuilderImpl s3) {
            this.s3 = s3 != null ? s3.build() : null;
        }

        @Override
        public final Builder s3(OptimizationJobModelSourceS3 s3) {
            this.s3 = s3;
            return this;
        }

        public OptimizationJobModelSource build() {
            return new OptimizationJobModelSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OptimizationJobModelSource> {
        public Builder s3(OptimizationJobModelSourceS3 var1);

        default public Builder s3(Consumer<OptimizationJobModelSourceS3.Builder> s3) {
            return this.s3((OptimizationJobModelSourceS3)((OptimizationJobModelSourceS3.Builder)OptimizationJobModelSourceS3.builder().applyMutation(s3)).build());
        }
    }
}

