/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.services.sagemaker.model.TransformJobSummariesCopier;
import software.amazon.awssdk.services.sagemaker.model.TransformJobSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTransformJobsResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, ListTransformJobsResponse> {
    private static final SdkField<List<TransformJobSummary>> TRANSFORM_JOB_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TransformJobSummaries").getter(ListTransformJobsResponse.getter(ListTransformJobsResponse::transformJobSummaries)).setter(ListTransformJobsResponse.setter(Builder::transformJobSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformJobSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TransformJobSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListTransformJobsResponse.getter(ListTransformJobsResponse::nextToken)).setter(ListTransformJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSFORM_JOB_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListTransformJobsResponse.memberNameToFieldInitializer();
    private final List<TransformJobSummary> transformJobSummaries;
    private final String nextToken;

    private ListTransformJobsResponse(BuilderImpl builder) {
        super(builder);
        this.transformJobSummaries = builder.transformJobSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTransformJobSummaries() {
        return this.transformJobSummaries != null && !(this.transformJobSummaries instanceof SdkAutoConstructList);
    }

    public final List<TransformJobSummary> transformJobSummaries() {
        return this.transformJobSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTransformJobSummaries() ? this.transformJobSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTransformJobsResponse)) {
            return false;
        }
        ListTransformJobsResponse other = (ListTransformJobsResponse)((Object)obj);
        return this.hasTransformJobSummaries() == other.hasTransformJobSummaries() && Objects.equals(this.transformJobSummaries(), other.transformJobSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListTransformJobsResponse").add("TransformJobSummaries", this.hasTransformJobSummaries() ? this.transformJobSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransformJobSummaries": {
                return Optional.ofNullable(clazz.cast(this.transformJobSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TransformJobSummaries", TRANSFORM_JOB_SUMMARIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTransformJobsResponse, T> g) {
        return obj -> g.apply((ListTransformJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private List<TransformJobSummary> transformJobSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTransformJobsResponse model) {
            super(model);
            this.transformJobSummaries(model.transformJobSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<TransformJobSummary.Builder> getTransformJobSummaries() {
            List<TransformJobSummary.Builder> result = TransformJobSummariesCopier.copyToBuilder(this.transformJobSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTransformJobSummaries(Collection<TransformJobSummary.BuilderImpl> transformJobSummaries) {
            this.transformJobSummaries = TransformJobSummariesCopier.copyFromBuilder(transformJobSummaries);
        }

        @Override
        public final Builder transformJobSummaries(Collection<TransformJobSummary> transformJobSummaries) {
            this.transformJobSummaries = TransformJobSummariesCopier.copy(transformJobSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transformJobSummaries(TransformJobSummary ... transformJobSummaries) {
            this.transformJobSummaries(Arrays.asList(transformJobSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transformJobSummaries(Consumer<TransformJobSummary.Builder> ... transformJobSummaries) {
            this.transformJobSummaries(Stream.of(transformJobSummaries).map(c -> (TransformJobSummary)((TransformJobSummary.Builder)TransformJobSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTransformJobsResponse build() {
            return new ListTransformJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTransformJobsResponse> {
        public Builder transformJobSummaries(Collection<TransformJobSummary> var1);

        public Builder transformJobSummaries(TransformJobSummary ... var1);

        public Builder transformJobSummaries(Consumer<TransformJobSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

