/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeClusterSchedulerConfigRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, DescribeClusterSchedulerConfigRequest> {
    private static final SdkField<String> CLUSTER_SCHEDULER_CONFIG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterSchedulerConfigId").getter(DescribeClusterSchedulerConfigRequest.getter(DescribeClusterSchedulerConfigRequest::clusterSchedulerConfigId)).setter(DescribeClusterSchedulerConfigRequest.setter(Builder::clusterSchedulerConfigId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterSchedulerConfigId").build()}).build();
    private static final SdkField<Integer> CLUSTER_SCHEDULER_CONFIG_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ClusterSchedulerConfigVersion").getter(DescribeClusterSchedulerConfigRequest.getter(DescribeClusterSchedulerConfigRequest::clusterSchedulerConfigVersion)).setter(DescribeClusterSchedulerConfigRequest.setter(Builder::clusterSchedulerConfigVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterSchedulerConfigVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_SCHEDULER_CONFIG_ID_FIELD, CLUSTER_SCHEDULER_CONFIG_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeClusterSchedulerConfigRequest.memberNameToFieldInitializer();
    private final String clusterSchedulerConfigId;
    private final Integer clusterSchedulerConfigVersion;

    private DescribeClusterSchedulerConfigRequest(BuilderImpl builder) {
        super(builder);
        this.clusterSchedulerConfigId = builder.clusterSchedulerConfigId;
        this.clusterSchedulerConfigVersion = builder.clusterSchedulerConfigVersion;
    }

    public final String clusterSchedulerConfigId() {
        return this.clusterSchedulerConfigId;
    }

    public final Integer clusterSchedulerConfigVersion() {
        return this.clusterSchedulerConfigVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterSchedulerConfigId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterSchedulerConfigVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClusterSchedulerConfigRequest)) {
            return false;
        }
        DescribeClusterSchedulerConfigRequest other = (DescribeClusterSchedulerConfigRequest)((Object)obj);
        return Objects.equals(this.clusterSchedulerConfigId(), other.clusterSchedulerConfigId()) && Objects.equals(this.clusterSchedulerConfigVersion(), other.clusterSchedulerConfigVersion());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeClusterSchedulerConfigRequest").add("ClusterSchedulerConfigId", (Object)this.clusterSchedulerConfigId()).add("ClusterSchedulerConfigVersion", (Object)this.clusterSchedulerConfigVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterSchedulerConfigId": {
                return Optional.ofNullable(clazz.cast(this.clusterSchedulerConfigId()));
            }
            case "ClusterSchedulerConfigVersion": {
                return Optional.ofNullable(clazz.cast(this.clusterSchedulerConfigVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ClusterSchedulerConfigId", CLUSTER_SCHEDULER_CONFIG_ID_FIELD);
        map.put("ClusterSchedulerConfigVersion", CLUSTER_SCHEDULER_CONFIG_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeClusterSchedulerConfigRequest, T> g) {
        return obj -> g.apply((DescribeClusterSchedulerConfigRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String clusterSchedulerConfigId;
        private Integer clusterSchedulerConfigVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClusterSchedulerConfigRequest model) {
            super(model);
            this.clusterSchedulerConfigId(model.clusterSchedulerConfigId);
            this.clusterSchedulerConfigVersion(model.clusterSchedulerConfigVersion);
        }

        public final String getClusterSchedulerConfigId() {
            return this.clusterSchedulerConfigId;
        }

        public final void setClusterSchedulerConfigId(String clusterSchedulerConfigId) {
            this.clusterSchedulerConfigId = clusterSchedulerConfigId;
        }

        @Override
        public final Builder clusterSchedulerConfigId(String clusterSchedulerConfigId) {
            this.clusterSchedulerConfigId = clusterSchedulerConfigId;
            return this;
        }

        public final Integer getClusterSchedulerConfigVersion() {
            return this.clusterSchedulerConfigVersion;
        }

        public final void setClusterSchedulerConfigVersion(Integer clusterSchedulerConfigVersion) {
            this.clusterSchedulerConfigVersion = clusterSchedulerConfigVersion;
        }

        @Override
        public final Builder clusterSchedulerConfigVersion(Integer clusterSchedulerConfigVersion) {
            this.clusterSchedulerConfigVersion = clusterSchedulerConfigVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeClusterSchedulerConfigRequest build() {
            return new DescribeClusterSchedulerConfigRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeClusterSchedulerConfigRequest> {
        public Builder clusterSchedulerConfigId(String var1);

        public Builder clusterSchedulerConfigVersion(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

