/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sagemaker.model.OptimizationJobEnvironmentVariablesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModelShardingConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ModelShardingConfig> {
    private static final SdkField<String> IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Image").getter(ModelShardingConfig.getter(ModelShardingConfig::image)).setter(ModelShardingConfig.setter(Builder::image)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Image").build()}).build();
    private static final SdkField<Map<String, String>> OVERRIDE_ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("OverrideEnvironment").getter(ModelShardingConfig.getter(ModelShardingConfig::overrideEnvironment)).setter(ModelShardingConfig.setter(Builder::overrideEnvironment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OverrideEnvironment").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_FIELD, OVERRIDE_ENVIRONMENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModelShardingConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String image;
    private final Map<String, String> overrideEnvironment;

    private ModelShardingConfig(BuilderImpl builder) {
        this.image = builder.image;
        this.overrideEnvironment = builder.overrideEnvironment;
    }

    public final String image() {
        return this.image;
    }

    public final boolean hasOverrideEnvironment() {
        return this.overrideEnvironment != null && !(this.overrideEnvironment instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> overrideEnvironment() {
        return this.overrideEnvironment;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.image());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOverrideEnvironment() ? this.overrideEnvironment() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelShardingConfig)) {
            return false;
        }
        ModelShardingConfig other = (ModelShardingConfig)obj;
        return Objects.equals(this.image(), other.image()) && this.hasOverrideEnvironment() == other.hasOverrideEnvironment() && Objects.equals(this.overrideEnvironment(), other.overrideEnvironment());
    }

    public final String toString() {
        return ToString.builder((String)"ModelShardingConfig").add("Image", (Object)this.image()).add("OverrideEnvironment", this.hasOverrideEnvironment() ? this.overrideEnvironment() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Image": {
                return Optional.ofNullable(clazz.cast(this.image()));
            }
            case "OverrideEnvironment": {
                return Optional.ofNullable(clazz.cast(this.overrideEnvironment()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Image", IMAGE_FIELD);
        map.put("OverrideEnvironment", OVERRIDE_ENVIRONMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModelShardingConfig, T> g) {
        return obj -> g.apply((ModelShardingConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String image;
        private Map<String, String> overrideEnvironment = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModelShardingConfig model) {
            this.image(model.image);
            this.overrideEnvironment(model.overrideEnvironment);
        }

        public final String getImage() {
            return this.image;
        }

        public final void setImage(String image) {
            this.image = image;
        }

        @Override
        public final Builder image(String image) {
            this.image = image;
            return this;
        }

        public final Map<String, String> getOverrideEnvironment() {
            if (this.overrideEnvironment instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.overrideEnvironment;
        }

        public final void setOverrideEnvironment(Map<String, String> overrideEnvironment) {
            this.overrideEnvironment = OptimizationJobEnvironmentVariablesCopier.copy(overrideEnvironment);
        }

        @Override
        public final Builder overrideEnvironment(Map<String, String> overrideEnvironment) {
            this.overrideEnvironment = OptimizationJobEnvironmentVariablesCopier.copy(overrideEnvironment);
            return this;
        }

        public ModelShardingConfig build() {
            return new ModelShardingConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ModelShardingConfig> {
        public Builder image(String var1);

        public Builder overrideEnvironment(Map<String, String> var1);
    }
}

