/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.HubContentType;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateHubContentReferenceRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, UpdateHubContentReferenceRequest> {
    private static final SdkField<String> HUB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HubName").getter(UpdateHubContentReferenceRequest.getter(UpdateHubContentReferenceRequest::hubName)).setter(UpdateHubContentReferenceRequest.setter(Builder::hubName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubName").build()}).build();
    private static final SdkField<String> HUB_CONTENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HubContentName").getter(UpdateHubContentReferenceRequest.getter(UpdateHubContentReferenceRequest::hubContentName)).setter(UpdateHubContentReferenceRequest.setter(Builder::hubContentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentName").build()}).build();
    private static final SdkField<String> HUB_CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HubContentType").getter(UpdateHubContentReferenceRequest.getter(UpdateHubContentReferenceRequest::hubContentTypeAsString)).setter(UpdateHubContentReferenceRequest.setter(Builder::hubContentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentType").build()}).build();
    private static final SdkField<String> MIN_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MinVersion").getter(UpdateHubContentReferenceRequest.getter(UpdateHubContentReferenceRequest::minVersion)).setter(UpdateHubContentReferenceRequest.setter(Builder::minVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HUB_NAME_FIELD, HUB_CONTENT_NAME_FIELD, HUB_CONTENT_TYPE_FIELD, MIN_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateHubContentReferenceRequest.memberNameToFieldInitializer();
    private final String hubName;
    private final String hubContentName;
    private final String hubContentType;
    private final String minVersion;

    private UpdateHubContentReferenceRequest(BuilderImpl builder) {
        super(builder);
        this.hubName = builder.hubName;
        this.hubContentName = builder.hubContentName;
        this.hubContentType = builder.hubContentType;
        this.minVersion = builder.minVersion;
    }

    public final String hubName() {
        return this.hubName;
    }

    public final String hubContentName() {
        return this.hubContentName;
    }

    public final HubContentType hubContentType() {
        return HubContentType.fromValue(this.hubContentType);
    }

    public final String hubContentTypeAsString() {
        return this.hubContentType;
    }

    public final String minVersion() {
        return this.minVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hubName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hubContentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hubContentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.minVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateHubContentReferenceRequest)) {
            return false;
        }
        UpdateHubContentReferenceRequest other = (UpdateHubContentReferenceRequest)((Object)obj);
        return Objects.equals(this.hubName(), other.hubName()) && Objects.equals(this.hubContentName(), other.hubContentName()) && Objects.equals(this.hubContentTypeAsString(), other.hubContentTypeAsString()) && Objects.equals(this.minVersion(), other.minVersion());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateHubContentReferenceRequest").add("HubName", (Object)this.hubName()).add("HubContentName", (Object)this.hubContentName()).add("HubContentType", (Object)this.hubContentTypeAsString()).add("MinVersion", (Object)this.minVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HubName": {
                return Optional.ofNullable(clazz.cast(this.hubName()));
            }
            case "HubContentName": {
                return Optional.ofNullable(clazz.cast(this.hubContentName()));
            }
            case "HubContentType": {
                return Optional.ofNullable(clazz.cast(this.hubContentTypeAsString()));
            }
            case "MinVersion": {
                return Optional.ofNullable(clazz.cast(this.minVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("HubName", HUB_NAME_FIELD);
        map.put("HubContentName", HUB_CONTENT_NAME_FIELD);
        map.put("HubContentType", HUB_CONTENT_TYPE_FIELD);
        map.put("MinVersion", MIN_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateHubContentReferenceRequest, T> g) {
        return obj -> g.apply((UpdateHubContentReferenceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String hubName;
        private String hubContentName;
        private String hubContentType;
        private String minVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateHubContentReferenceRequest model) {
            super(model);
            this.hubName(model.hubName);
            this.hubContentName(model.hubContentName);
            this.hubContentType(model.hubContentType);
            this.minVersion(model.minVersion);
        }

        public final String getHubName() {
            return this.hubName;
        }

        public final void setHubName(String hubName) {
            this.hubName = hubName;
        }

        @Override
        public final Builder hubName(String hubName) {
            this.hubName = hubName;
            return this;
        }

        public final String getHubContentName() {
            return this.hubContentName;
        }

        public final void setHubContentName(String hubContentName) {
            this.hubContentName = hubContentName;
        }

        @Override
        public final Builder hubContentName(String hubContentName) {
            this.hubContentName = hubContentName;
            return this;
        }

        public final String getHubContentType() {
            return this.hubContentType;
        }

        public final void setHubContentType(String hubContentType) {
            this.hubContentType = hubContentType;
        }

        @Override
        public final Builder hubContentType(String hubContentType) {
            this.hubContentType = hubContentType;
            return this;
        }

        @Override
        public final Builder hubContentType(HubContentType hubContentType) {
            this.hubContentType(hubContentType == null ? null : hubContentType.toString());
            return this;
        }

        public final String getMinVersion() {
            return this.minVersion;
        }

        public final void setMinVersion(String minVersion) {
            this.minVersion = minVersion;
        }

        @Override
        public final Builder minVersion(String minVersion) {
            this.minVersion = minVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateHubContentReferenceRequest build() {
            return new UpdateHubContentReferenceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateHubContentReferenceRequest> {
        public Builder hubName(String var1);

        public Builder hubContentName(String var1);

        public Builder hubContentType(String var1);

        public Builder hubContentType(HubContentType var1);

        public Builder minVersion(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

