/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.MonitoringAlertStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MonitoringAlertHistorySummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MonitoringAlertHistorySummary> {
    private static final SdkField<String> MONITORING_SCHEDULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MonitoringScheduleName").getter(MonitoringAlertHistorySummary.getter(MonitoringAlertHistorySummary::monitoringScheduleName)).setter(MonitoringAlertHistorySummary.setter(Builder::monitoringScheduleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringScheduleName").build()}).build();
    private static final SdkField<String> MONITORING_ALERT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MonitoringAlertName").getter(MonitoringAlertHistorySummary.getter(MonitoringAlertHistorySummary::monitoringAlertName)).setter(MonitoringAlertHistorySummary.setter(Builder::monitoringAlertName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringAlertName").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(MonitoringAlertHistorySummary.getter(MonitoringAlertHistorySummary::creationTime)).setter(MonitoringAlertHistorySummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> ALERT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlertStatus").getter(MonitoringAlertHistorySummary.getter(MonitoringAlertHistorySummary::alertStatusAsString)).setter(MonitoringAlertHistorySummary.setter(Builder::alertStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlertStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONITORING_SCHEDULE_NAME_FIELD, MONITORING_ALERT_NAME_FIELD, CREATION_TIME_FIELD, ALERT_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MonitoringAlertHistorySummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String monitoringScheduleName;
    private final String monitoringAlertName;
    private final Instant creationTime;
    private final String alertStatus;

    private MonitoringAlertHistorySummary(BuilderImpl builder) {
        this.monitoringScheduleName = builder.monitoringScheduleName;
        this.monitoringAlertName = builder.monitoringAlertName;
        this.creationTime = builder.creationTime;
        this.alertStatus = builder.alertStatus;
    }

    public final String monitoringScheduleName() {
        return this.monitoringScheduleName;
    }

    public final String monitoringAlertName() {
        return this.monitoringAlertName;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final MonitoringAlertStatus alertStatus() {
        return MonitoringAlertStatus.fromValue(this.alertStatus);
    }

    public final String alertStatusAsString() {
        return this.alertStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoringScheduleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoringAlertName());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.alertStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitoringAlertHistorySummary)) {
            return false;
        }
        MonitoringAlertHistorySummary other = (MonitoringAlertHistorySummary)obj;
        return Objects.equals(this.monitoringScheduleName(), other.monitoringScheduleName()) && Objects.equals(this.monitoringAlertName(), other.monitoringAlertName()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.alertStatusAsString(), other.alertStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"MonitoringAlertHistorySummary").add("MonitoringScheduleName", (Object)this.monitoringScheduleName()).add("MonitoringAlertName", (Object)this.monitoringAlertName()).add("CreationTime", (Object)this.creationTime()).add("AlertStatus", (Object)this.alertStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MonitoringScheduleName": {
                return Optional.ofNullable(clazz.cast(this.monitoringScheduleName()));
            }
            case "MonitoringAlertName": {
                return Optional.ofNullable(clazz.cast(this.monitoringAlertName()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "AlertStatus": {
                return Optional.ofNullable(clazz.cast(this.alertStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MonitoringScheduleName", MONITORING_SCHEDULE_NAME_FIELD);
        map.put("MonitoringAlertName", MONITORING_ALERT_NAME_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("AlertStatus", ALERT_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MonitoringAlertHistorySummary, T> g) {
        return obj -> g.apply((MonitoringAlertHistorySummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String monitoringScheduleName;
        private String monitoringAlertName;
        private Instant creationTime;
        private String alertStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(MonitoringAlertHistorySummary model) {
            this.monitoringScheduleName(model.monitoringScheduleName);
            this.monitoringAlertName(model.monitoringAlertName);
            this.creationTime(model.creationTime);
            this.alertStatus(model.alertStatus);
        }

        public final String getMonitoringScheduleName() {
            return this.monitoringScheduleName;
        }

        public final void setMonitoringScheduleName(String monitoringScheduleName) {
            this.monitoringScheduleName = monitoringScheduleName;
        }

        @Override
        public final Builder monitoringScheduleName(String monitoringScheduleName) {
            this.monitoringScheduleName = monitoringScheduleName;
            return this;
        }

        public final String getMonitoringAlertName() {
            return this.monitoringAlertName;
        }

        public final void setMonitoringAlertName(String monitoringAlertName) {
            this.monitoringAlertName = monitoringAlertName;
        }

        @Override
        public final Builder monitoringAlertName(String monitoringAlertName) {
            this.monitoringAlertName = monitoringAlertName;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getAlertStatus() {
            return this.alertStatus;
        }

        public final void setAlertStatus(String alertStatus) {
            this.alertStatus = alertStatus;
        }

        @Override
        public final Builder alertStatus(String alertStatus) {
            this.alertStatus = alertStatus;
            return this;
        }

        @Override
        public final Builder alertStatus(MonitoringAlertStatus alertStatus) {
            this.alertStatus(alertStatus == null ? null : alertStatus.toString());
            return this;
        }

        public MonitoringAlertHistorySummary build() {
            return new MonitoringAlertHistorySummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MonitoringAlertHistorySummary> {
        public Builder monitoringScheduleName(String var1);

        public Builder monitoringAlertName(String var1);

        public Builder creationTime(Instant var1);

        public Builder alertStatus(String var1);

        public Builder alertStatus(MonitoringAlertStatus var1);
    }
}

