/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.AgentVersion;
import software.amazon.awssdk.services.sagemaker.model.AgentVersionsCopier;
import software.amazon.awssdk.services.sagemaker.model.DeviceStats;
import software.amazon.awssdk.services.sagemaker.model.EdgeModelStat;
import software.amazon.awssdk.services.sagemaker.model.EdgeModelStatsCopier;
import software.amazon.awssdk.services.sagemaker.model.EdgeOutputConfig;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDeviceFleetReportResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, GetDeviceFleetReportResponse> {
    private static final SdkField<String> DEVICE_FLEET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceFleetArn").getter(GetDeviceFleetReportResponse.getter(GetDeviceFleetReportResponse::deviceFleetArn)).setter(GetDeviceFleetReportResponse.setter(Builder::deviceFleetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceFleetArn").build()}).build();
    private static final SdkField<String> DEVICE_FLEET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceFleetName").getter(GetDeviceFleetReportResponse.getter(GetDeviceFleetReportResponse::deviceFleetName)).setter(GetDeviceFleetReportResponse.setter(Builder::deviceFleetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceFleetName").build()}).build();
    private static final SdkField<EdgeOutputConfig> OUTPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutputConfig").getter(GetDeviceFleetReportResponse.getter(GetDeviceFleetReportResponse::outputConfig)).setter(GetDeviceFleetReportResponse.setter(Builder::outputConfig)).constructor(EdgeOutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(GetDeviceFleetReportResponse.getter(GetDeviceFleetReportResponse::description)).setter(GetDeviceFleetReportResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Instant> REPORT_GENERATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ReportGenerated").getter(GetDeviceFleetReportResponse.getter(GetDeviceFleetReportResponse::reportGenerated)).setter(GetDeviceFleetReportResponse.setter(Builder::reportGenerated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportGenerated").build()}).build();
    private static final SdkField<DeviceStats> DEVICE_STATS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeviceStats").getter(GetDeviceFleetReportResponse.getter(GetDeviceFleetReportResponse::deviceStats)).setter(GetDeviceFleetReportResponse.setter(Builder::deviceStats)).constructor(DeviceStats::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceStats").build()}).build();
    private static final SdkField<List<AgentVersion>> AGENT_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AgentVersions").getter(GetDeviceFleetReportResponse.getter(GetDeviceFleetReportResponse::agentVersions)).setter(GetDeviceFleetReportResponse.setter(Builder::agentVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AgentVersion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<EdgeModelStat>> MODEL_STATS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ModelStats").getter(GetDeviceFleetReportResponse.getter(GetDeviceFleetReportResponse::modelStats)).setter(GetDeviceFleetReportResponse.setter(Builder::modelStats)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelStats").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EdgeModelStat::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_FLEET_ARN_FIELD, DEVICE_FLEET_NAME_FIELD, OUTPUT_CONFIG_FIELD, DESCRIPTION_FIELD, REPORT_GENERATED_FIELD, DEVICE_STATS_FIELD, AGENT_VERSIONS_FIELD, MODEL_STATS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetDeviceFleetReportResponse.memberNameToFieldInitializer();
    private final String deviceFleetArn;
    private final String deviceFleetName;
    private final EdgeOutputConfig outputConfig;
    private final String description;
    private final Instant reportGenerated;
    private final DeviceStats deviceStats;
    private final List<AgentVersion> agentVersions;
    private final List<EdgeModelStat> modelStats;

    private GetDeviceFleetReportResponse(BuilderImpl builder) {
        super(builder);
        this.deviceFleetArn = builder.deviceFleetArn;
        this.deviceFleetName = builder.deviceFleetName;
        this.outputConfig = builder.outputConfig;
        this.description = builder.description;
        this.reportGenerated = builder.reportGenerated;
        this.deviceStats = builder.deviceStats;
        this.agentVersions = builder.agentVersions;
        this.modelStats = builder.modelStats;
    }

    public final String deviceFleetArn() {
        return this.deviceFleetArn;
    }

    public final String deviceFleetName() {
        return this.deviceFleetName;
    }

    public final EdgeOutputConfig outputConfig() {
        return this.outputConfig;
    }

    public final String description() {
        return this.description;
    }

    public final Instant reportGenerated() {
        return this.reportGenerated;
    }

    public final DeviceStats deviceStats() {
        return this.deviceStats;
    }

    public final boolean hasAgentVersions() {
        return this.agentVersions != null && !(this.agentVersions instanceof SdkAutoConstructList);
    }

    public final List<AgentVersion> agentVersions() {
        return this.agentVersions;
    }

    public final boolean hasModelStats() {
        return this.modelStats != null && !(this.modelStats instanceof SdkAutoConstructList);
    }

    public final List<EdgeModelStat> modelStats() {
        return this.modelStats;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceFleetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceFleetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.reportGenerated());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceStats());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAgentVersions() ? this.agentVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasModelStats() ? this.modelStats() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDeviceFleetReportResponse)) {
            return false;
        }
        GetDeviceFleetReportResponse other = (GetDeviceFleetReportResponse)((Object)obj);
        return Objects.equals(this.deviceFleetArn(), other.deviceFleetArn()) && Objects.equals(this.deviceFleetName(), other.deviceFleetName()) && Objects.equals(this.outputConfig(), other.outputConfig()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.reportGenerated(), other.reportGenerated()) && Objects.equals(this.deviceStats(), other.deviceStats()) && this.hasAgentVersions() == other.hasAgentVersions() && Objects.equals(this.agentVersions(), other.agentVersions()) && this.hasModelStats() == other.hasModelStats() && Objects.equals(this.modelStats(), other.modelStats());
    }

    public final String toString() {
        return ToString.builder((String)"GetDeviceFleetReportResponse").add("DeviceFleetArn", (Object)this.deviceFleetArn()).add("DeviceFleetName", (Object)this.deviceFleetName()).add("OutputConfig", (Object)this.outputConfig()).add("Description", (Object)this.description()).add("ReportGenerated", (Object)this.reportGenerated()).add("DeviceStats", (Object)this.deviceStats()).add("AgentVersions", this.hasAgentVersions() ? this.agentVersions() : null).add("ModelStats", this.hasModelStats() ? this.modelStats() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeviceFleetArn": {
                return Optional.ofNullable(clazz.cast(this.deviceFleetArn()));
            }
            case "DeviceFleetName": {
                return Optional.ofNullable(clazz.cast(this.deviceFleetName()));
            }
            case "OutputConfig": {
                return Optional.ofNullable(clazz.cast(this.outputConfig()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ReportGenerated": {
                return Optional.ofNullable(clazz.cast(this.reportGenerated()));
            }
            case "DeviceStats": {
                return Optional.ofNullable(clazz.cast(this.deviceStats()));
            }
            case "AgentVersions": {
                return Optional.ofNullable(clazz.cast(this.agentVersions()));
            }
            case "ModelStats": {
                return Optional.ofNullable(clazz.cast(this.modelStats()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DeviceFleetArn", DEVICE_FLEET_ARN_FIELD);
        map.put("DeviceFleetName", DEVICE_FLEET_NAME_FIELD);
        map.put("OutputConfig", OUTPUT_CONFIG_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ReportGenerated", REPORT_GENERATED_FIELD);
        map.put("DeviceStats", DEVICE_STATS_FIELD);
        map.put("AgentVersions", AGENT_VERSIONS_FIELD);
        map.put("ModelStats", MODEL_STATS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDeviceFleetReportResponse, T> g) {
        return obj -> g.apply((GetDeviceFleetReportResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String deviceFleetArn;
        private String deviceFleetName;
        private EdgeOutputConfig outputConfig;
        private String description;
        private Instant reportGenerated;
        private DeviceStats deviceStats;
        private List<AgentVersion> agentVersions = DefaultSdkAutoConstructList.getInstance();
        private List<EdgeModelStat> modelStats = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDeviceFleetReportResponse model) {
            super(model);
            this.deviceFleetArn(model.deviceFleetArn);
            this.deviceFleetName(model.deviceFleetName);
            this.outputConfig(model.outputConfig);
            this.description(model.description);
            this.reportGenerated(model.reportGenerated);
            this.deviceStats(model.deviceStats);
            this.agentVersions(model.agentVersions);
            this.modelStats(model.modelStats);
        }

        public final String getDeviceFleetArn() {
            return this.deviceFleetArn;
        }

        public final void setDeviceFleetArn(String deviceFleetArn) {
            this.deviceFleetArn = deviceFleetArn;
        }

        @Override
        public final Builder deviceFleetArn(String deviceFleetArn) {
            this.deviceFleetArn = deviceFleetArn;
            return this;
        }

        public final String getDeviceFleetName() {
            return this.deviceFleetName;
        }

        public final void setDeviceFleetName(String deviceFleetName) {
            this.deviceFleetName = deviceFleetName;
        }

        @Override
        public final Builder deviceFleetName(String deviceFleetName) {
            this.deviceFleetName = deviceFleetName;
            return this;
        }

        public final EdgeOutputConfig.Builder getOutputConfig() {
            return this.outputConfig != null ? this.outputConfig.toBuilder() : null;
        }

        public final void setOutputConfig(EdgeOutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        public final Builder outputConfig(EdgeOutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getReportGenerated() {
            return this.reportGenerated;
        }

        public final void setReportGenerated(Instant reportGenerated) {
            this.reportGenerated = reportGenerated;
        }

        @Override
        public final Builder reportGenerated(Instant reportGenerated) {
            this.reportGenerated = reportGenerated;
            return this;
        }

        public final DeviceStats.Builder getDeviceStats() {
            return this.deviceStats != null ? this.deviceStats.toBuilder() : null;
        }

        public final void setDeviceStats(DeviceStats.BuilderImpl deviceStats) {
            this.deviceStats = deviceStats != null ? deviceStats.build() : null;
        }

        @Override
        public final Builder deviceStats(DeviceStats deviceStats) {
            this.deviceStats = deviceStats;
            return this;
        }

        public final List<AgentVersion.Builder> getAgentVersions() {
            List<AgentVersion.Builder> result = AgentVersionsCopier.copyToBuilder(this.agentVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAgentVersions(Collection<AgentVersion.BuilderImpl> agentVersions) {
            this.agentVersions = AgentVersionsCopier.copyFromBuilder(agentVersions);
        }

        @Override
        public final Builder agentVersions(Collection<AgentVersion> agentVersions) {
            this.agentVersions = AgentVersionsCopier.copy(agentVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentVersions(AgentVersion ... agentVersions) {
            this.agentVersions(Arrays.asList(agentVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentVersions(Consumer<AgentVersion.Builder> ... agentVersions) {
            this.agentVersions(Stream.of(agentVersions).map(c -> (AgentVersion)((AgentVersion.Builder)AgentVersion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<EdgeModelStat.Builder> getModelStats() {
            List<EdgeModelStat.Builder> result = EdgeModelStatsCopier.copyToBuilder(this.modelStats);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModelStats(Collection<EdgeModelStat.BuilderImpl> modelStats) {
            this.modelStats = EdgeModelStatsCopier.copyFromBuilder(modelStats);
        }

        @Override
        public final Builder modelStats(Collection<EdgeModelStat> modelStats) {
            this.modelStats = EdgeModelStatsCopier.copy(modelStats);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelStats(EdgeModelStat ... modelStats) {
            this.modelStats(Arrays.asList(modelStats));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelStats(Consumer<EdgeModelStat.Builder> ... modelStats) {
            this.modelStats(Stream.of(modelStats).map(c -> (EdgeModelStat)((EdgeModelStat.Builder)EdgeModelStat.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetDeviceFleetReportResponse build() {
            return new GetDeviceFleetReportResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDeviceFleetReportResponse> {
        public Builder deviceFleetArn(String var1);

        public Builder deviceFleetName(String var1);

        public Builder outputConfig(EdgeOutputConfig var1);

        default public Builder outputConfig(Consumer<EdgeOutputConfig.Builder> outputConfig) {
            return this.outputConfig((EdgeOutputConfig)((EdgeOutputConfig.Builder)EdgeOutputConfig.builder().applyMutation(outputConfig)).build());
        }

        public Builder description(String var1);

        public Builder reportGenerated(Instant var1);

        public Builder deviceStats(DeviceStats var1);

        default public Builder deviceStats(Consumer<DeviceStats.Builder> deviceStats) {
            return this.deviceStats((DeviceStats)((DeviceStats.Builder)DeviceStats.builder().applyMutation(deviceStats)).build());
        }

        public Builder agentVersions(Collection<AgentVersion> var1);

        public Builder agentVersions(AgentVersion ... var1);

        public Builder agentVersions(Consumer<AgentVersion.Builder> ... var1);

        public Builder modelStats(Collection<EdgeModelStat> var1);

        public Builder modelStats(EdgeModelStat ... var1);

        public Builder modelStats(Consumer<EdgeModelStat.Builder> ... var1);
    }
}

