/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.RecommendationJobInferenceBenchmark;
import software.amazon.awssdk.services.sagemaker.model.RecommendationJobStatus;
import software.amazon.awssdk.services.sagemaker.model.RecommendationStepType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InferenceRecommendationsJobStep
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InferenceRecommendationsJobStep> {
    private static final SdkField<String> STEP_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StepType").getter(InferenceRecommendationsJobStep.getter(InferenceRecommendationsJobStep::stepTypeAsString)).setter(InferenceRecommendationsJobStep.setter(Builder::stepType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepType").build()}).build();
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobName").getter(InferenceRecommendationsJobStep.getter(InferenceRecommendationsJobStep::jobName)).setter(InferenceRecommendationsJobStep.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(InferenceRecommendationsJobStep.getter(InferenceRecommendationsJobStep::statusAsString)).setter(InferenceRecommendationsJobStep.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<RecommendationJobInferenceBenchmark> INFERENCE_BENCHMARK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InferenceBenchmark").getter(InferenceRecommendationsJobStep.getter(InferenceRecommendationsJobStep::inferenceBenchmark)).setter(InferenceRecommendationsJobStep.setter(Builder::inferenceBenchmark)).constructor(RecommendationJobInferenceBenchmark::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceBenchmark").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEP_TYPE_FIELD, JOB_NAME_FIELD, STATUS_FIELD, INFERENCE_BENCHMARK_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InferenceRecommendationsJobStep.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String stepType;
    private final String jobName;
    private final String status;
    private final RecommendationJobInferenceBenchmark inferenceBenchmark;

    private InferenceRecommendationsJobStep(BuilderImpl builder) {
        this.stepType = builder.stepType;
        this.jobName = builder.jobName;
        this.status = builder.status;
        this.inferenceBenchmark = builder.inferenceBenchmark;
    }

    public final RecommendationStepType stepType() {
        return RecommendationStepType.fromValue(this.stepType);
    }

    public final String stepTypeAsString() {
        return this.stepType;
    }

    public final String jobName() {
        return this.jobName;
    }

    public final RecommendationJobStatus status() {
        return RecommendationJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final RecommendationJobInferenceBenchmark inferenceBenchmark() {
        return this.inferenceBenchmark;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stepTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceBenchmark());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferenceRecommendationsJobStep)) {
            return false;
        }
        InferenceRecommendationsJobStep other = (InferenceRecommendationsJobStep)obj;
        return Objects.equals(this.stepTypeAsString(), other.stepTypeAsString()) && Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.inferenceBenchmark(), other.inferenceBenchmark());
    }

    public final String toString() {
        return ToString.builder((String)"InferenceRecommendationsJobStep").add("StepType", (Object)this.stepTypeAsString()).add("JobName", (Object)this.jobName()).add("Status", (Object)this.statusAsString()).add("InferenceBenchmark", (Object)this.inferenceBenchmark()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StepType": {
                return Optional.ofNullable(clazz.cast(this.stepTypeAsString()));
            }
            case "JobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "InferenceBenchmark": {
                return Optional.ofNullable(clazz.cast(this.inferenceBenchmark()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StepType", STEP_TYPE_FIELD);
        map.put("JobName", JOB_NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("InferenceBenchmark", INFERENCE_BENCHMARK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InferenceRecommendationsJobStep, T> g) {
        return obj -> g.apply((InferenceRecommendationsJobStep)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String stepType;
        private String jobName;
        private String status;
        private RecommendationJobInferenceBenchmark inferenceBenchmark;

        private BuilderImpl() {
        }

        private BuilderImpl(InferenceRecommendationsJobStep model) {
            this.stepType(model.stepType);
            this.jobName(model.jobName);
            this.status(model.status);
            this.inferenceBenchmark(model.inferenceBenchmark);
        }

        public final String getStepType() {
            return this.stepType;
        }

        public final void setStepType(String stepType) {
            this.stepType = stepType;
        }

        @Override
        public final Builder stepType(String stepType) {
            this.stepType = stepType;
            return this;
        }

        @Override
        public final Builder stepType(RecommendationStepType stepType) {
            this.stepType(stepType == null ? null : stepType.toString());
            return this;
        }

        public final String getJobName() {
            return this.jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RecommendationJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final RecommendationJobInferenceBenchmark.Builder getInferenceBenchmark() {
            return this.inferenceBenchmark != null ? this.inferenceBenchmark.toBuilder() : null;
        }

        public final void setInferenceBenchmark(RecommendationJobInferenceBenchmark.BuilderImpl inferenceBenchmark) {
            this.inferenceBenchmark = inferenceBenchmark != null ? inferenceBenchmark.build() : null;
        }

        @Override
        public final Builder inferenceBenchmark(RecommendationJobInferenceBenchmark inferenceBenchmark) {
            this.inferenceBenchmark = inferenceBenchmark;
            return this;
        }

        public InferenceRecommendationsJobStep build() {
            return new InferenceRecommendationsJobStep(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InferenceRecommendationsJobStep> {
        public Builder stepType(String var1);

        public Builder stepType(RecommendationStepType var1);

        public Builder jobName(String var1);

        public Builder status(String var1);

        public Builder status(RecommendationJobStatus var1);

        public Builder inferenceBenchmark(RecommendationJobInferenceBenchmark var1);

        default public Builder inferenceBenchmark(Consumer<RecommendationJobInferenceBenchmark.Builder> inferenceBenchmark) {
            return this.inferenceBenchmark((RecommendationJobInferenceBenchmark)((RecommendationJobInferenceBenchmark.Builder)RecommendationJobInferenceBenchmark.builder().applyMutation(inferenceBenchmark)).build());
        }
    }
}

