/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.EndpointMetadata;
import software.amazon.awssdk.services.sagemaker.model.InferenceExperimentDataStorageConfig;
import software.amazon.awssdk.services.sagemaker.model.InferenceExperimentSchedule;
import software.amazon.awssdk.services.sagemaker.model.InferenceExperimentStatus;
import software.amazon.awssdk.services.sagemaker.model.InferenceExperimentType;
import software.amazon.awssdk.services.sagemaker.model.ModelVariantConfigSummary;
import software.amazon.awssdk.services.sagemaker.model.ModelVariantConfigSummaryListCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.services.sagemaker.model.ShadowModeConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeInferenceExperimentResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, DescribeInferenceExperimentResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(DescribeInferenceExperimentResponse.getter(DescribeInferenceExperimentResponse::arn)).setter(DescribeInferenceExperimentResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DescribeInferenceExperimentResponse.getter(DescribeInferenceExperimentResponse::name)).setter(DescribeInferenceExperimentResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(DescribeInferenceExperimentResponse.getter(DescribeInferenceExperimentResponse::typeAsString)).setter(DescribeInferenceExperimentResponse.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<InferenceExperimentSchedule> SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Schedule").getter(DescribeInferenceExperimentResponse.getter(DescribeInferenceExperimentResponse::schedule)).setter(DescribeInferenceExperimentResponse.setter(Builder::schedule)).constructor(InferenceExperimentSchedule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribeInferenceExperimentResponse.getter(DescribeInferenceExperimentResponse::statusAsString)).setter(DescribeInferenceExperimentResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusReason").getter(DescribeInferenceExperimentResponse.getter(DescribeInferenceExperimentResponse::statusReason)).setter(DescribeInferenceExperimentResponse.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DescribeInferenceExperimentResponse.getter(DescribeInferenceExperimentResponse::description)).setter(DescribeInferenceExperimentResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeInferenceExperimentResponse.getter(DescribeInferenceExperimentResponse::creationTime)).setter(DescribeInferenceExperimentResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> COMPLETION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CompletionTime").getter(DescribeInferenceExperimentResponse.getter(DescribeInferenceExperimentResponse::completionTime)).setter(DescribeInferenceExperimentResponse.setter(Builder::completionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(DescribeInferenceExperimentResponse.getter(DescribeInferenceExperimentResponse::lastModifiedTime)).setter(DescribeInferenceExperimentResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(DescribeInferenceExperimentResponse.getter(DescribeInferenceExperimentResponse::roleArn)).setter(DescribeInferenceExperimentResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<EndpointMetadata> ENDPOINT_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EndpointMetadata").getter(DescribeInferenceExperimentResponse.getter(DescribeInferenceExperimentResponse::endpointMetadata)).setter(DescribeInferenceExperimentResponse.setter(Builder::endpointMetadata)).constructor(EndpointMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointMetadata").build()}).build();
    private static final SdkField<List<ModelVariantConfigSummary>> MODEL_VARIANTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ModelVariants").getter(DescribeInferenceExperimentResponse.getter(DescribeInferenceExperimentResponse::modelVariants)).setter(DescribeInferenceExperimentResponse.setter(Builder::modelVariants)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelVariants").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ModelVariantConfigSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<InferenceExperimentDataStorageConfig> DATA_STORAGE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataStorageConfig").getter(DescribeInferenceExperimentResponse.getter(DescribeInferenceExperimentResponse::dataStorageConfig)).setter(DescribeInferenceExperimentResponse.setter(Builder::dataStorageConfig)).constructor(InferenceExperimentDataStorageConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataStorageConfig").build()}).build();
    private static final SdkField<ShadowModeConfig> SHADOW_MODE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ShadowModeConfig").getter(DescribeInferenceExperimentResponse.getter(DescribeInferenceExperimentResponse::shadowModeConfig)).setter(DescribeInferenceExperimentResponse.setter(Builder::shadowModeConfig)).constructor(ShadowModeConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShadowModeConfig").build()}).build();
    private static final SdkField<String> KMS_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKey").getter(DescribeInferenceExperimentResponse.getter(DescribeInferenceExperimentResponse::kmsKey)).setter(DescribeInferenceExperimentResponse.setter(Builder::kmsKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKey").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, TYPE_FIELD, SCHEDULE_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, DESCRIPTION_FIELD, CREATION_TIME_FIELD, COMPLETION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, ROLE_ARN_FIELD, ENDPOINT_METADATA_FIELD, MODEL_VARIANTS_FIELD, DATA_STORAGE_CONFIG_FIELD, SHADOW_MODE_CONFIG_FIELD, KMS_KEY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeInferenceExperimentResponse.memberNameToFieldInitializer();
    private final String arn;
    private final String name;
    private final String type;
    private final InferenceExperimentSchedule schedule;
    private final String status;
    private final String statusReason;
    private final String description;
    private final Instant creationTime;
    private final Instant completionTime;
    private final Instant lastModifiedTime;
    private final String roleArn;
    private final EndpointMetadata endpointMetadata;
    private final List<ModelVariantConfigSummary> modelVariants;
    private final InferenceExperimentDataStorageConfig dataStorageConfig;
    private final ShadowModeConfig shadowModeConfig;
    private final String kmsKey;

    private DescribeInferenceExperimentResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.type = builder.type;
        this.schedule = builder.schedule;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.description = builder.description;
        this.creationTime = builder.creationTime;
        this.completionTime = builder.completionTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.roleArn = builder.roleArn;
        this.endpointMetadata = builder.endpointMetadata;
        this.modelVariants = builder.modelVariants;
        this.dataStorageConfig = builder.dataStorageConfig;
        this.shadowModeConfig = builder.shadowModeConfig;
        this.kmsKey = builder.kmsKey;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final InferenceExperimentType type() {
        return InferenceExperimentType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final InferenceExperimentSchedule schedule() {
        return this.schedule;
    }

    public final InferenceExperimentStatus status() {
        return InferenceExperimentStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final String description() {
        return this.description;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant completionTime() {
        return this.completionTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final EndpointMetadata endpointMetadata() {
        return this.endpointMetadata;
    }

    public final boolean hasModelVariants() {
        return this.modelVariants != null && !(this.modelVariants instanceof SdkAutoConstructList);
    }

    public final List<ModelVariantConfigSummary> modelVariants() {
        return this.modelVariants;
    }

    public final InferenceExperimentDataStorageConfig dataStorageConfig() {
        return this.dataStorageConfig;
    }

    public final ShadowModeConfig shadowModeConfig() {
        return this.shadowModeConfig;
    }

    public final String kmsKey() {
        return this.kmsKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.completionTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasModelVariants() ? this.modelVariants() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dataStorageConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.shadowModeConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKey());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInferenceExperimentResponse)) {
            return false;
        }
        DescribeInferenceExperimentResponse other = (DescribeInferenceExperimentResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.schedule(), other.schedule()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.completionTime(), other.completionTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.endpointMetadata(), other.endpointMetadata()) && this.hasModelVariants() == other.hasModelVariants() && Objects.equals(this.modelVariants(), other.modelVariants()) && Objects.equals(this.dataStorageConfig(), other.dataStorageConfig()) && Objects.equals(this.shadowModeConfig(), other.shadowModeConfig()) && Objects.equals(this.kmsKey(), other.kmsKey());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeInferenceExperimentResponse").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("Type", (Object)this.typeAsString()).add("Schedule", (Object)this.schedule()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("Description", (Object)this.description()).add("CreationTime", (Object)this.creationTime()).add("CompletionTime", (Object)this.completionTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("RoleArn", (Object)this.roleArn()).add("EndpointMetadata", (Object)this.endpointMetadata()).add("ModelVariants", this.hasModelVariants() ? this.modelVariants() : null).add("DataStorageConfig", (Object)this.dataStorageConfig()).add("ShadowModeConfig", (Object)this.shadowModeConfig()).add("KmsKey", (Object)this.kmsKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Schedule": {
                return Optional.ofNullable(clazz.cast(this.schedule()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "CompletionTime": {
                return Optional.ofNullable(clazz.cast(this.completionTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "EndpointMetadata": {
                return Optional.ofNullable(clazz.cast(this.endpointMetadata()));
            }
            case "ModelVariants": {
                return Optional.ofNullable(clazz.cast(this.modelVariants()));
            }
            case "DataStorageConfig": {
                return Optional.ofNullable(clazz.cast(this.dataStorageConfig()));
            }
            case "ShadowModeConfig": {
                return Optional.ofNullable(clazz.cast(this.shadowModeConfig()));
            }
            case "KmsKey": {
                return Optional.ofNullable(clazz.cast(this.kmsKey()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Arn", ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("Schedule", SCHEDULE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusReason", STATUS_REASON_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("CompletionTime", COMPLETION_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("EndpointMetadata", ENDPOINT_METADATA_FIELD);
        map.put("ModelVariants", MODEL_VARIANTS_FIELD);
        map.put("DataStorageConfig", DATA_STORAGE_CONFIG_FIELD);
        map.put("ShadowModeConfig", SHADOW_MODE_CONFIG_FIELD);
        map.put("KmsKey", KMS_KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeInferenceExperimentResponse, T> g) {
        return obj -> g.apply((DescribeInferenceExperimentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String type;
        private InferenceExperimentSchedule schedule;
        private String status;
        private String statusReason;
        private String description;
        private Instant creationTime;
        private Instant completionTime;
        private Instant lastModifiedTime;
        private String roleArn;
        private EndpointMetadata endpointMetadata;
        private List<ModelVariantConfigSummary> modelVariants = DefaultSdkAutoConstructList.getInstance();
        private InferenceExperimentDataStorageConfig dataStorageConfig;
        private ShadowModeConfig shadowModeConfig;
        private String kmsKey;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInferenceExperimentResponse model) {
            super(model);
            this.arn(model.arn);
            this.name(model.name);
            this.type(model.type);
            this.schedule(model.schedule);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.description(model.description);
            this.creationTime(model.creationTime);
            this.completionTime(model.completionTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.roleArn(model.roleArn);
            this.endpointMetadata(model.endpointMetadata);
            this.modelVariants(model.modelVariants);
            this.dataStorageConfig(model.dataStorageConfig);
            this.shadowModeConfig(model.shadowModeConfig);
            this.kmsKey(model.kmsKey);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(InferenceExperimentType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final InferenceExperimentSchedule.Builder getSchedule() {
            return this.schedule != null ? this.schedule.toBuilder() : null;
        }

        public final void setSchedule(InferenceExperimentSchedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        @Override
        public final Builder schedule(InferenceExperimentSchedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(InferenceExperimentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getCompletionTime() {
            return this.completionTime;
        }

        public final void setCompletionTime(Instant completionTime) {
            this.completionTime = completionTime;
        }

        @Override
        public final Builder completionTime(Instant completionTime) {
            this.completionTime = completionTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final EndpointMetadata.Builder getEndpointMetadata() {
            return this.endpointMetadata != null ? this.endpointMetadata.toBuilder() : null;
        }

        public final void setEndpointMetadata(EndpointMetadata.BuilderImpl endpointMetadata) {
            this.endpointMetadata = endpointMetadata != null ? endpointMetadata.build() : null;
        }

        @Override
        public final Builder endpointMetadata(EndpointMetadata endpointMetadata) {
            this.endpointMetadata = endpointMetadata;
            return this;
        }

        public final List<ModelVariantConfigSummary.Builder> getModelVariants() {
            List<ModelVariantConfigSummary.Builder> result = ModelVariantConfigSummaryListCopier.copyToBuilder(this.modelVariants);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModelVariants(Collection<ModelVariantConfigSummary.BuilderImpl> modelVariants) {
            this.modelVariants = ModelVariantConfigSummaryListCopier.copyFromBuilder(modelVariants);
        }

        @Override
        public final Builder modelVariants(Collection<ModelVariantConfigSummary> modelVariants) {
            this.modelVariants = ModelVariantConfigSummaryListCopier.copy(modelVariants);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelVariants(ModelVariantConfigSummary ... modelVariants) {
            this.modelVariants(Arrays.asList(modelVariants));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelVariants(Consumer<ModelVariantConfigSummary.Builder> ... modelVariants) {
            this.modelVariants(Stream.of(modelVariants).map(c -> (ModelVariantConfigSummary)((ModelVariantConfigSummary.Builder)ModelVariantConfigSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final InferenceExperimentDataStorageConfig.Builder getDataStorageConfig() {
            return this.dataStorageConfig != null ? this.dataStorageConfig.toBuilder() : null;
        }

        public final void setDataStorageConfig(InferenceExperimentDataStorageConfig.BuilderImpl dataStorageConfig) {
            this.dataStorageConfig = dataStorageConfig != null ? dataStorageConfig.build() : null;
        }

        @Override
        public final Builder dataStorageConfig(InferenceExperimentDataStorageConfig dataStorageConfig) {
            this.dataStorageConfig = dataStorageConfig;
            return this;
        }

        public final ShadowModeConfig.Builder getShadowModeConfig() {
            return this.shadowModeConfig != null ? this.shadowModeConfig.toBuilder() : null;
        }

        public final void setShadowModeConfig(ShadowModeConfig.BuilderImpl shadowModeConfig) {
            this.shadowModeConfig = shadowModeConfig != null ? shadowModeConfig.build() : null;
        }

        @Override
        public final Builder shadowModeConfig(ShadowModeConfig shadowModeConfig) {
            this.shadowModeConfig = shadowModeConfig;
            return this;
        }

        public final String getKmsKey() {
            return this.kmsKey;
        }

        public final void setKmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
        }

        @Override
        public final Builder kmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        @Override
        public DescribeInferenceExperimentResponse build() {
            return new DescribeInferenceExperimentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeInferenceExperimentResponse> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(InferenceExperimentType var1);

        public Builder schedule(InferenceExperimentSchedule var1);

        default public Builder schedule(Consumer<InferenceExperimentSchedule.Builder> schedule) {
            return this.schedule((InferenceExperimentSchedule)((InferenceExperimentSchedule.Builder)InferenceExperimentSchedule.builder().applyMutation(schedule)).build());
        }

        public Builder status(String var1);

        public Builder status(InferenceExperimentStatus var1);

        public Builder statusReason(String var1);

        public Builder description(String var1);

        public Builder creationTime(Instant var1);

        public Builder completionTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder roleArn(String var1);

        public Builder endpointMetadata(EndpointMetadata var1);

        default public Builder endpointMetadata(Consumer<EndpointMetadata.Builder> endpointMetadata) {
            return this.endpointMetadata((EndpointMetadata)((EndpointMetadata.Builder)EndpointMetadata.builder().applyMutation(endpointMetadata)).build());
        }

        public Builder modelVariants(Collection<ModelVariantConfigSummary> var1);

        public Builder modelVariants(ModelVariantConfigSummary ... var1);

        public Builder modelVariants(Consumer<ModelVariantConfigSummary.Builder> ... var1);

        public Builder dataStorageConfig(InferenceExperimentDataStorageConfig var1);

        default public Builder dataStorageConfig(Consumer<InferenceExperimentDataStorageConfig.Builder> dataStorageConfig) {
            return this.dataStorageConfig((InferenceExperimentDataStorageConfig)((InferenceExperimentDataStorageConfig.Builder)InferenceExperimentDataStorageConfig.builder().applyMutation(dataStorageConfig)).build());
        }

        public Builder shadowModeConfig(ShadowModeConfig var1);

        default public Builder shadowModeConfig(Consumer<ShadowModeConfig.Builder> shadowModeConfig) {
            return this.shadowModeConfig((ShadowModeConfig)((ShadowModeConfig.Builder)ShadowModeConfig.builder().applyMutation(shadowModeConfig)).build());
        }

        public Builder kmsKey(String var1);
    }
}

