/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.NotebookOutputOption;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SharingSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SharingSettings> {
    private static final SdkField<String> NOTEBOOK_OUTPUT_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NotebookOutputOption").getter(SharingSettings.getter(SharingSettings::notebookOutputOptionAsString)).setter(SharingSettings.setter(Builder::notebookOutputOption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookOutputOption").build()}).build();
    private static final SdkField<String> S3_OUTPUT_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3OutputPath").getter(SharingSettings.getter(SharingSettings::s3OutputPath)).setter(SharingSettings.setter(Builder::s3OutputPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3OutputPath").build()}).build();
    private static final SdkField<String> S3_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3KmsKeyId").getter(SharingSettings.getter(SharingSettings::s3KmsKeyId)).setter(SharingSettings.setter(Builder::s3KmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3KmsKeyId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTEBOOK_OUTPUT_OPTION_FIELD, S3_OUTPUT_PATH_FIELD, S3_KMS_KEY_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SharingSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String notebookOutputOption;
    private final String s3OutputPath;
    private final String s3KmsKeyId;

    private SharingSettings(BuilderImpl builder) {
        this.notebookOutputOption = builder.notebookOutputOption;
        this.s3OutputPath = builder.s3OutputPath;
        this.s3KmsKeyId = builder.s3KmsKeyId;
    }

    public final NotebookOutputOption notebookOutputOption() {
        return NotebookOutputOption.fromValue(this.notebookOutputOption);
    }

    public final String notebookOutputOptionAsString() {
        return this.notebookOutputOption;
    }

    public final String s3OutputPath() {
        return this.s3OutputPath;
    }

    public final String s3KmsKeyId() {
        return this.s3KmsKeyId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.notebookOutputOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3OutputPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3KmsKeyId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SharingSettings)) {
            return false;
        }
        SharingSettings other = (SharingSettings)obj;
        return Objects.equals(this.notebookOutputOptionAsString(), other.notebookOutputOptionAsString()) && Objects.equals(this.s3OutputPath(), other.s3OutputPath()) && Objects.equals(this.s3KmsKeyId(), other.s3KmsKeyId());
    }

    public final String toString() {
        return ToString.builder((String)"SharingSettings").add("NotebookOutputOption", (Object)this.notebookOutputOptionAsString()).add("S3OutputPath", (Object)this.s3OutputPath()).add("S3KmsKeyId", (Object)this.s3KmsKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NotebookOutputOption": {
                return Optional.ofNullable(clazz.cast(this.notebookOutputOptionAsString()));
            }
            case "S3OutputPath": {
                return Optional.ofNullable(clazz.cast(this.s3OutputPath()));
            }
            case "S3KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.s3KmsKeyId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("NotebookOutputOption", NOTEBOOK_OUTPUT_OPTION_FIELD);
        map.put("S3OutputPath", S3_OUTPUT_PATH_FIELD);
        map.put("S3KmsKeyId", S3_KMS_KEY_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SharingSettings, T> g) {
        return obj -> g.apply((SharingSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String notebookOutputOption;
        private String s3OutputPath;
        private String s3KmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(SharingSettings model) {
            this.notebookOutputOption(model.notebookOutputOption);
            this.s3OutputPath(model.s3OutputPath);
            this.s3KmsKeyId(model.s3KmsKeyId);
        }

        public final String getNotebookOutputOption() {
            return this.notebookOutputOption;
        }

        public final void setNotebookOutputOption(String notebookOutputOption) {
            this.notebookOutputOption = notebookOutputOption;
        }

        @Override
        public final Builder notebookOutputOption(String notebookOutputOption) {
            this.notebookOutputOption = notebookOutputOption;
            return this;
        }

        @Override
        public final Builder notebookOutputOption(NotebookOutputOption notebookOutputOption) {
            this.notebookOutputOption(notebookOutputOption == null ? null : notebookOutputOption.toString());
            return this;
        }

        public final String getS3OutputPath() {
            return this.s3OutputPath;
        }

        public final void setS3OutputPath(String s3OutputPath) {
            this.s3OutputPath = s3OutputPath;
        }

        @Override
        public final Builder s3OutputPath(String s3OutputPath) {
            this.s3OutputPath = s3OutputPath;
            return this;
        }

        public final String getS3KmsKeyId() {
            return this.s3KmsKeyId;
        }

        public final void setS3KmsKeyId(String s3KmsKeyId) {
            this.s3KmsKeyId = s3KmsKeyId;
        }

        @Override
        public final Builder s3KmsKeyId(String s3KmsKeyId) {
            this.s3KmsKeyId = s3KmsKeyId;
            return this;
        }

        public SharingSettings build() {
            return new SharingSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SharingSettings> {
        public Builder notebookOutputOption(String var1);

        public Builder notebookOutputOption(NotebookOutputOption var1);

        public Builder s3OutputPath(String var1);

        public Builder s3KmsKeyId(String var1);
    }
}

