/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ModelInfrastructureConfig;
import software.amazon.awssdk.services.sagemaker.model.ModelVariantStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModelVariantConfigSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ModelVariantConfigSummary> {
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelName").getter(ModelVariantConfigSummary.getter(ModelVariantConfigSummary::modelName)).setter(ModelVariantConfigSummary.setter(Builder::modelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()}).build();
    private static final SdkField<String> VARIANT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VariantName").getter(ModelVariantConfigSummary.getter(ModelVariantConfigSummary::variantName)).setter(ModelVariantConfigSummary.setter(Builder::variantName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VariantName").build()}).build();
    private static final SdkField<ModelInfrastructureConfig> INFRASTRUCTURE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InfrastructureConfig").getter(ModelVariantConfigSummary.getter(ModelVariantConfigSummary::infrastructureConfig)).setter(ModelVariantConfigSummary.setter(Builder::infrastructureConfig)).constructor(ModelInfrastructureConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InfrastructureConfig").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ModelVariantConfigSummary.getter(ModelVariantConfigSummary::statusAsString)).setter(ModelVariantConfigSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_NAME_FIELD, VARIANT_NAME_FIELD, INFRASTRUCTURE_CONFIG_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModelVariantConfigSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String modelName;
    private final String variantName;
    private final ModelInfrastructureConfig infrastructureConfig;
    private final String status;

    private ModelVariantConfigSummary(BuilderImpl builder) {
        this.modelName = builder.modelName;
        this.variantName = builder.variantName;
        this.infrastructureConfig = builder.infrastructureConfig;
        this.status = builder.status;
    }

    public final String modelName() {
        return this.modelName;
    }

    public final String variantName() {
        return this.variantName;
    }

    public final ModelInfrastructureConfig infrastructureConfig() {
        return this.infrastructureConfig;
    }

    public final ModelVariantStatus status() {
        return ModelVariantStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.variantName());
        hashCode = 31 * hashCode + Objects.hashCode(this.infrastructureConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelVariantConfigSummary)) {
            return false;
        }
        ModelVariantConfigSummary other = (ModelVariantConfigSummary)obj;
        return Objects.equals(this.modelName(), other.modelName()) && Objects.equals(this.variantName(), other.variantName()) && Objects.equals(this.infrastructureConfig(), other.infrastructureConfig()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ModelVariantConfigSummary").add("ModelName", (Object)this.modelName()).add("VariantName", (Object)this.variantName()).add("InfrastructureConfig", (Object)this.infrastructureConfig()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelName": {
                return Optional.ofNullable(clazz.cast(this.modelName()));
            }
            case "VariantName": {
                return Optional.ofNullable(clazz.cast(this.variantName()));
            }
            case "InfrastructureConfig": {
                return Optional.ofNullable(clazz.cast(this.infrastructureConfig()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ModelName", MODEL_NAME_FIELD);
        map.put("VariantName", VARIANT_NAME_FIELD);
        map.put("InfrastructureConfig", INFRASTRUCTURE_CONFIG_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModelVariantConfigSummary, T> g) {
        return obj -> g.apply((ModelVariantConfigSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String modelName;
        private String variantName;
        private ModelInfrastructureConfig infrastructureConfig;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelVariantConfigSummary model) {
            this.modelName(model.modelName);
            this.variantName(model.variantName);
            this.infrastructureConfig(model.infrastructureConfig);
            this.status(model.status);
        }

        public final String getModelName() {
            return this.modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final String getVariantName() {
            return this.variantName;
        }

        public final void setVariantName(String variantName) {
            this.variantName = variantName;
        }

        @Override
        public final Builder variantName(String variantName) {
            this.variantName = variantName;
            return this;
        }

        public final ModelInfrastructureConfig.Builder getInfrastructureConfig() {
            return this.infrastructureConfig != null ? this.infrastructureConfig.toBuilder() : null;
        }

        public final void setInfrastructureConfig(ModelInfrastructureConfig.BuilderImpl infrastructureConfig) {
            this.infrastructureConfig = infrastructureConfig != null ? infrastructureConfig.build() : null;
        }

        @Override
        public final Builder infrastructureConfig(ModelInfrastructureConfig infrastructureConfig) {
            this.infrastructureConfig = infrastructureConfig;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ModelVariantStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public ModelVariantConfigSummary build() {
            return new ModelVariantConfigSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ModelVariantConfigSummary> {
        public Builder modelName(String var1);

        public Builder variantName(String var1);

        public Builder infrastructureConfig(ModelInfrastructureConfig var1);

        default public Builder infrastructureConfig(Consumer<ModelInfrastructureConfig.Builder> infrastructureConfig) {
            return this.infrastructureConfig((ModelInfrastructureConfig)((ModelInfrastructureConfig.Builder)ModelInfrastructureConfig.builder().applyMutation(infrastructureConfig)).build());
        }

        public Builder status(String var1);

        public Builder status(ModelVariantStatus var1);
    }
}

