/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ArtifactSourceIdType {
    MD5_HASH("MD5Hash"),
    S3_E_TAG("S3ETag"),
    S3_VERSION("S3Version"),
    CUSTOM("Custom"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ArtifactSourceIdType> VALUE_MAP;
    private final String value;

    private ArtifactSourceIdType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ArtifactSourceIdType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ArtifactSourceIdType> knownValues() {
        EnumSet<ArtifactSourceIdType> knownValues = EnumSet.allOf(ArtifactSourceIdType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ArtifactSourceIdType.class, ArtifactSourceIdType::toString);
    }
}

