/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.ClusterNodeSummariesCopier;
import software.amazon.awssdk.services.sagemaker.model.ClusterNodeSummary;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListClusterNodesResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, ListClusterNodesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListClusterNodesResponse.getter(ListClusterNodesResponse::nextToken)).setter(ListClusterNodesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<ClusterNodeSummary>> CLUSTER_NODE_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ClusterNodeSummaries").getter(ListClusterNodesResponse.getter(ListClusterNodesResponse::clusterNodeSummaries)).setter(ListClusterNodesResponse.setter(Builder::clusterNodeSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterNodeSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ClusterNodeSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, CLUSTER_NODE_SUMMARIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListClusterNodesResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<ClusterNodeSummary> clusterNodeSummaries;

    private ListClusterNodesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.clusterNodeSummaries = builder.clusterNodeSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasClusterNodeSummaries() {
        return this.clusterNodeSummaries != null && !(this.clusterNodeSummaries instanceof SdkAutoConstructList);
    }

    public final List<ClusterNodeSummary> clusterNodeSummaries() {
        return this.clusterNodeSummaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClusterNodeSummaries() ? this.clusterNodeSummaries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListClusterNodesResponse)) {
            return false;
        }
        ListClusterNodesResponse other = (ListClusterNodesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasClusterNodeSummaries() == other.hasClusterNodeSummaries() && Objects.equals(this.clusterNodeSummaries(), other.clusterNodeSummaries());
    }

    public final String toString() {
        return ToString.builder((String)"ListClusterNodesResponse").add("NextToken", (Object)this.nextToken()).add("ClusterNodeSummaries", this.hasClusterNodeSummaries() ? this.clusterNodeSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ClusterNodeSummaries": {
                return Optional.ofNullable(clazz.cast(this.clusterNodeSummaries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("ClusterNodeSummaries", CLUSTER_NODE_SUMMARIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListClusterNodesResponse, T> g) {
        return obj -> g.apply((ListClusterNodesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ClusterNodeSummary> clusterNodeSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListClusterNodesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.clusterNodeSummaries(model.clusterNodeSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ClusterNodeSummary.Builder> getClusterNodeSummaries() {
            List<ClusterNodeSummary.Builder> result = ClusterNodeSummariesCopier.copyToBuilder(this.clusterNodeSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClusterNodeSummaries(Collection<ClusterNodeSummary.BuilderImpl> clusterNodeSummaries) {
            this.clusterNodeSummaries = ClusterNodeSummariesCopier.copyFromBuilder(clusterNodeSummaries);
        }

        @Override
        public final Builder clusterNodeSummaries(Collection<ClusterNodeSummary> clusterNodeSummaries) {
            this.clusterNodeSummaries = ClusterNodeSummariesCopier.copy(clusterNodeSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterNodeSummaries(ClusterNodeSummary ... clusterNodeSummaries) {
            this.clusterNodeSummaries(Arrays.asList(clusterNodeSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterNodeSummaries(Consumer<ClusterNodeSummary.Builder> ... clusterNodeSummaries) {
            this.clusterNodeSummaries(Stream.of(clusterNodeSummaries).map(c -> (ClusterNodeSummary)((ClusterNodeSummary.Builder)ClusterNodeSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListClusterNodesResponse build() {
            return new ListClusterNodesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListClusterNodesResponse> {
        public Builder nextToken(String var1);

        public Builder clusterNodeSummaries(Collection<ClusterNodeSummary> var1);

        public Builder clusterNodeSummaries(ClusterNodeSummary ... var1);

        public Builder clusterNodeSummaries(Consumer<ClusterNodeSummary.Builder> ... var1);
    }
}

