/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.ListPipelineExecutionStepsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListPipelineExecutionStepsResponse;
import software.amazon.awssdk.services.sagemaker.model.PipelineExecutionStep;

public class ListPipelineExecutionStepsIterable
implements SdkIterable<ListPipelineExecutionStepsResponse> {
    private final SageMakerClient client;
    private final ListPipelineExecutionStepsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPipelineExecutionStepsIterable(SageMakerClient client, ListPipelineExecutionStepsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPipelineExecutionStepsResponseFetcher();
    }

    public Iterator<ListPipelineExecutionStepsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PipelineExecutionStep> pipelineExecutionSteps() {
        Function<ListPipelineExecutionStepsResponse, Iterator> getIterator = response -> {
            if (response != null && response.pipelineExecutionSteps() != null) {
                return response.pipelineExecutionSteps().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPipelineExecutionStepsResponseFetcher
    implements SyncPageFetcher<ListPipelineExecutionStepsResponse> {
        private ListPipelineExecutionStepsResponseFetcher() {
        }

        public boolean hasNextPage(ListPipelineExecutionStepsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPipelineExecutionStepsResponse nextPage(ListPipelineExecutionStepsResponse previousPage) {
            if (previousPage == null) {
                return ListPipelineExecutionStepsIterable.this.client.listPipelineExecutionSteps(ListPipelineExecutionStepsIterable.this.firstRequest);
            }
            return ListPipelineExecutionStepsIterable.this.client.listPipelineExecutionSteps((ListPipelineExecutionStepsRequest)((Object)ListPipelineExecutionStepsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

