/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.FileSystemConfig;
import software.amazon.awssdk.services.sagemaker.model.KernelSpec;
import software.amazon.awssdk.services.sagemaker.model.KernelSpecsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KernelGatewayImageConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KernelGatewayImageConfig> {
    private static final SdkField<List<KernelSpec>> KERNEL_SPECS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("KernelSpecs").getter(KernelGatewayImageConfig.getter(KernelGatewayImageConfig::kernelSpecs)).setter(KernelGatewayImageConfig.setter(Builder::kernelSpecs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KernelSpecs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KernelSpec::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<FileSystemConfig> FILE_SYSTEM_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FileSystemConfig").getter(KernelGatewayImageConfig.getter(KernelGatewayImageConfig::fileSystemConfig)).setter(KernelGatewayImageConfig.setter(Builder::fileSystemConfig)).constructor(FileSystemConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KERNEL_SPECS_FIELD, FILE_SYSTEM_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = KernelGatewayImageConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<KernelSpec> kernelSpecs;
    private final FileSystemConfig fileSystemConfig;

    private KernelGatewayImageConfig(BuilderImpl builder) {
        this.kernelSpecs = builder.kernelSpecs;
        this.fileSystemConfig = builder.fileSystemConfig;
    }

    public final boolean hasKernelSpecs() {
        return this.kernelSpecs != null && !(this.kernelSpecs instanceof SdkAutoConstructList);
    }

    public final List<KernelSpec> kernelSpecs() {
        return this.kernelSpecs;
    }

    public final FileSystemConfig fileSystemConfig() {
        return this.fileSystemConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKernelSpecs() ? this.kernelSpecs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KernelGatewayImageConfig)) {
            return false;
        }
        KernelGatewayImageConfig other = (KernelGatewayImageConfig)obj;
        return this.hasKernelSpecs() == other.hasKernelSpecs() && Objects.equals(this.kernelSpecs(), other.kernelSpecs()) && Objects.equals(this.fileSystemConfig(), other.fileSystemConfig());
    }

    public final String toString() {
        return ToString.builder((String)"KernelGatewayImageConfig").add("KernelSpecs", this.hasKernelSpecs() ? this.kernelSpecs() : null).add("FileSystemConfig", (Object)this.fileSystemConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KernelSpecs": {
                return Optional.ofNullable(clazz.cast(this.kernelSpecs()));
            }
            case "FileSystemConfig": {
                return Optional.ofNullable(clazz.cast(this.fileSystemConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("KernelSpecs", KERNEL_SPECS_FIELD);
        map.put("FileSystemConfig", FILE_SYSTEM_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KernelGatewayImageConfig, T> g) {
        return obj -> g.apply((KernelGatewayImageConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<KernelSpec> kernelSpecs = DefaultSdkAutoConstructList.getInstance();
        private FileSystemConfig fileSystemConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(KernelGatewayImageConfig model) {
            this.kernelSpecs(model.kernelSpecs);
            this.fileSystemConfig(model.fileSystemConfig);
        }

        public final List<KernelSpec.Builder> getKernelSpecs() {
            List<KernelSpec.Builder> result = KernelSpecsCopier.copyToBuilder(this.kernelSpecs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setKernelSpecs(Collection<KernelSpec.BuilderImpl> kernelSpecs) {
            this.kernelSpecs = KernelSpecsCopier.copyFromBuilder(kernelSpecs);
        }

        @Override
        public final Builder kernelSpecs(Collection<KernelSpec> kernelSpecs) {
            this.kernelSpecs = KernelSpecsCopier.copy(kernelSpecs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder kernelSpecs(KernelSpec ... kernelSpecs) {
            this.kernelSpecs(Arrays.asList(kernelSpecs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder kernelSpecs(Consumer<KernelSpec.Builder> ... kernelSpecs) {
            this.kernelSpecs(Stream.of(kernelSpecs).map(c -> (KernelSpec)((KernelSpec.Builder)KernelSpec.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final FileSystemConfig.Builder getFileSystemConfig() {
            return this.fileSystemConfig != null ? this.fileSystemConfig.toBuilder() : null;
        }

        public final void setFileSystemConfig(FileSystemConfig.BuilderImpl fileSystemConfig) {
            this.fileSystemConfig = fileSystemConfig != null ? fileSystemConfig.build() : null;
        }

        @Override
        public final Builder fileSystemConfig(FileSystemConfig fileSystemConfig) {
            this.fileSystemConfig = fileSystemConfig;
            return this;
        }

        public KernelGatewayImageConfig build() {
            return new KernelGatewayImageConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KernelGatewayImageConfig> {
        public Builder kernelSpecs(Collection<KernelSpec> var1);

        public Builder kernelSpecs(KernelSpec ... var1);

        public Builder kernelSpecs(Consumer<KernelSpec.Builder> ... var1);

        public Builder fileSystemConfig(FileSystemConfig var1);

        default public Builder fileSystemConfig(Consumer<FileSystemConfig.Builder> fileSystemConfig) {
            return this.fileSystemConfig((FileSystemConfig)((FileSystemConfig.Builder)FileSystemConfig.builder().applyMutation(fileSystemConfig)).build());
        }
    }
}

