/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.DeviceDeploymentSummariesCopier;
import software.amazon.awssdk.services.sagemaker.model.DeviceDeploymentSummary;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListStageDevicesResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, ListStageDevicesResponse> {
    private static final SdkField<List<DeviceDeploymentSummary>> DEVICE_DEPLOYMENT_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DeviceDeploymentSummaries").getter(ListStageDevicesResponse.getter(ListStageDevicesResponse::deviceDeploymentSummaries)).setter(ListStageDevicesResponse.setter(Builder::deviceDeploymentSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceDeploymentSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DeviceDeploymentSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListStageDevicesResponse.getter(ListStageDevicesResponse::nextToken)).setter(ListStageDevicesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_DEPLOYMENT_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListStageDevicesResponse.memberNameToFieldInitializer();
    private final List<DeviceDeploymentSummary> deviceDeploymentSummaries;
    private final String nextToken;

    private ListStageDevicesResponse(BuilderImpl builder) {
        super(builder);
        this.deviceDeploymentSummaries = builder.deviceDeploymentSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDeviceDeploymentSummaries() {
        return this.deviceDeploymentSummaries != null && !(this.deviceDeploymentSummaries instanceof SdkAutoConstructList);
    }

    public final List<DeviceDeploymentSummary> deviceDeploymentSummaries() {
        return this.deviceDeploymentSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeviceDeploymentSummaries() ? this.deviceDeploymentSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStageDevicesResponse)) {
            return false;
        }
        ListStageDevicesResponse other = (ListStageDevicesResponse)((Object)obj);
        return this.hasDeviceDeploymentSummaries() == other.hasDeviceDeploymentSummaries() && Objects.equals(this.deviceDeploymentSummaries(), other.deviceDeploymentSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListStageDevicesResponse").add("DeviceDeploymentSummaries", this.hasDeviceDeploymentSummaries() ? this.deviceDeploymentSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeviceDeploymentSummaries": {
                return Optional.ofNullable(clazz.cast(this.deviceDeploymentSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DeviceDeploymentSummaries", DEVICE_DEPLOYMENT_SUMMARIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListStageDevicesResponse, T> g) {
        return obj -> g.apply((ListStageDevicesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private List<DeviceDeploymentSummary> deviceDeploymentSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStageDevicesResponse model) {
            super(model);
            this.deviceDeploymentSummaries(model.deviceDeploymentSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<DeviceDeploymentSummary.Builder> getDeviceDeploymentSummaries() {
            List<DeviceDeploymentSummary.Builder> result = DeviceDeploymentSummariesCopier.copyToBuilder(this.deviceDeploymentSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDeviceDeploymentSummaries(Collection<DeviceDeploymentSummary.BuilderImpl> deviceDeploymentSummaries) {
            this.deviceDeploymentSummaries = DeviceDeploymentSummariesCopier.copyFromBuilder(deviceDeploymentSummaries);
        }

        @Override
        public final Builder deviceDeploymentSummaries(Collection<DeviceDeploymentSummary> deviceDeploymentSummaries) {
            this.deviceDeploymentSummaries = DeviceDeploymentSummariesCopier.copy(deviceDeploymentSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceDeploymentSummaries(DeviceDeploymentSummary ... deviceDeploymentSummaries) {
            this.deviceDeploymentSummaries(Arrays.asList(deviceDeploymentSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceDeploymentSummaries(Consumer<DeviceDeploymentSummary.Builder> ... deviceDeploymentSummaries) {
            this.deviceDeploymentSummaries(Stream.of(deviceDeploymentSummaries).map(c -> (DeviceDeploymentSummary)((DeviceDeploymentSummary.Builder)DeviceDeploymentSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListStageDevicesResponse build() {
            return new ListStageDevicesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListStageDevicesResponse> {
        public Builder deviceDeploymentSummaries(Collection<DeviceDeploymentSummary> var1);

        public Builder deviceDeploymentSummaries(DeviceDeploymentSummary ... var1);

        public Builder deviceDeploymentSummaries(Consumer<DeviceDeploymentSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

