/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.ModelPackageStatusItem;
import software.amazon.awssdk.services.sagemaker.model.ModelPackageStatusItemListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModelPackageStatusDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ModelPackageStatusDetails> {
    private static final SdkField<List<ModelPackageStatusItem>> VALIDATION_STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ValidationStatuses").getter(ModelPackageStatusDetails.getter(ModelPackageStatusDetails::validationStatuses)).setter(ModelPackageStatusDetails.setter(Builder::validationStatuses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationStatuses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ModelPackageStatusItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ModelPackageStatusItem>> IMAGE_SCAN_STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ImageScanStatuses").getter(ModelPackageStatusDetails.getter(ModelPackageStatusDetails::imageScanStatuses)).setter(ModelPackageStatusDetails.setter(Builder::imageScanStatuses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageScanStatuses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ModelPackageStatusItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALIDATION_STATUSES_FIELD, IMAGE_SCAN_STATUSES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModelPackageStatusDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<ModelPackageStatusItem> validationStatuses;
    private final List<ModelPackageStatusItem> imageScanStatuses;

    private ModelPackageStatusDetails(BuilderImpl builder) {
        this.validationStatuses = builder.validationStatuses;
        this.imageScanStatuses = builder.imageScanStatuses;
    }

    public final boolean hasValidationStatuses() {
        return this.validationStatuses != null && !(this.validationStatuses instanceof SdkAutoConstructList);
    }

    public final List<ModelPackageStatusItem> validationStatuses() {
        return this.validationStatuses;
    }

    public final boolean hasImageScanStatuses() {
        return this.imageScanStatuses != null && !(this.imageScanStatuses instanceof SdkAutoConstructList);
    }

    public final List<ModelPackageStatusItem> imageScanStatuses() {
        return this.imageScanStatuses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValidationStatuses() ? this.validationStatuses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImageScanStatuses() ? this.imageScanStatuses() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelPackageStatusDetails)) {
            return false;
        }
        ModelPackageStatusDetails other = (ModelPackageStatusDetails)obj;
        return this.hasValidationStatuses() == other.hasValidationStatuses() && Objects.equals(this.validationStatuses(), other.validationStatuses()) && this.hasImageScanStatuses() == other.hasImageScanStatuses() && Objects.equals(this.imageScanStatuses(), other.imageScanStatuses());
    }

    public final String toString() {
        return ToString.builder((String)"ModelPackageStatusDetails").add("ValidationStatuses", this.hasValidationStatuses() ? this.validationStatuses() : null).add("ImageScanStatuses", this.hasImageScanStatuses() ? this.imageScanStatuses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ValidationStatuses": {
                return Optional.ofNullable(clazz.cast(this.validationStatuses()));
            }
            case "ImageScanStatuses": {
                return Optional.ofNullable(clazz.cast(this.imageScanStatuses()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<ModelPackageStatusItem>>> map = new HashMap<String, SdkField<List<ModelPackageStatusItem>>>();
        map.put("ValidationStatuses", VALIDATION_STATUSES_FIELD);
        map.put("ImageScanStatuses", IMAGE_SCAN_STATUSES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModelPackageStatusDetails, T> g) {
        return obj -> g.apply((ModelPackageStatusDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ModelPackageStatusItem> validationStatuses = DefaultSdkAutoConstructList.getInstance();
        private List<ModelPackageStatusItem> imageScanStatuses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModelPackageStatusDetails model) {
            this.validationStatuses(model.validationStatuses);
            this.imageScanStatuses(model.imageScanStatuses);
        }

        public final List<ModelPackageStatusItem.Builder> getValidationStatuses() {
            List<ModelPackageStatusItem.Builder> result = ModelPackageStatusItemListCopier.copyToBuilder(this.validationStatuses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValidationStatuses(Collection<ModelPackageStatusItem.BuilderImpl> validationStatuses) {
            this.validationStatuses = ModelPackageStatusItemListCopier.copyFromBuilder(validationStatuses);
        }

        @Override
        public final Builder validationStatuses(Collection<ModelPackageStatusItem> validationStatuses) {
            this.validationStatuses = ModelPackageStatusItemListCopier.copy(validationStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationStatuses(ModelPackageStatusItem ... validationStatuses) {
            this.validationStatuses(Arrays.asList(validationStatuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationStatuses(Consumer<ModelPackageStatusItem.Builder> ... validationStatuses) {
            this.validationStatuses(Stream.of(validationStatuses).map(c -> (ModelPackageStatusItem)((ModelPackageStatusItem.Builder)ModelPackageStatusItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ModelPackageStatusItem.Builder> getImageScanStatuses() {
            List<ModelPackageStatusItem.Builder> result = ModelPackageStatusItemListCopier.copyToBuilder(this.imageScanStatuses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImageScanStatuses(Collection<ModelPackageStatusItem.BuilderImpl> imageScanStatuses) {
            this.imageScanStatuses = ModelPackageStatusItemListCopier.copyFromBuilder(imageScanStatuses);
        }

        @Override
        public final Builder imageScanStatuses(Collection<ModelPackageStatusItem> imageScanStatuses) {
            this.imageScanStatuses = ModelPackageStatusItemListCopier.copy(imageScanStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageScanStatuses(ModelPackageStatusItem ... imageScanStatuses) {
            this.imageScanStatuses(Arrays.asList(imageScanStatuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageScanStatuses(Consumer<ModelPackageStatusItem.Builder> ... imageScanStatuses) {
            this.imageScanStatuses(Stream.of(imageScanStatuses).map(c -> (ModelPackageStatusItem)((ModelPackageStatusItem.Builder)ModelPackageStatusItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ModelPackageStatusDetails build() {
            return new ModelPackageStatusDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ModelPackageStatusDetails> {
        public Builder validationStatuses(Collection<ModelPackageStatusItem> var1);

        public Builder validationStatuses(ModelPackageStatusItem ... var1);

        public Builder validationStatuses(Consumer<ModelPackageStatusItem.Builder> ... var1);

        public Builder imageScanStatuses(Collection<ModelPackageStatusItem> var1);

        public Builder imageScanStatuses(ModelPackageStatusItem ... var1);

        public Builder imageScanStatuses(Consumer<ModelPackageStatusItem.Builder> ... var1);
    }
}

