/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.IsTrackingServerActive;
import software.amazon.awssdk.services.sagemaker.model.TrackingServerStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TrackingServerSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TrackingServerSummary> {
    private static final SdkField<String> TRACKING_SERVER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrackingServerArn").getter(TrackingServerSummary.getter(TrackingServerSummary::trackingServerArn)).setter(TrackingServerSummary.setter(Builder::trackingServerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrackingServerArn").build()}).build();
    private static final SdkField<String> TRACKING_SERVER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrackingServerName").getter(TrackingServerSummary.getter(TrackingServerSummary::trackingServerName)).setter(TrackingServerSummary.setter(Builder::trackingServerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrackingServerName").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(TrackingServerSummary.getter(TrackingServerSummary::creationTime)).setter(TrackingServerSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(TrackingServerSummary.getter(TrackingServerSummary::lastModifiedTime)).setter(TrackingServerSummary.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> TRACKING_SERVER_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrackingServerStatus").getter(TrackingServerSummary.getter(TrackingServerSummary::trackingServerStatusAsString)).setter(TrackingServerSummary.setter(Builder::trackingServerStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrackingServerStatus").build()}).build();
    private static final SdkField<String> IS_ACTIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IsActive").getter(TrackingServerSummary.getter(TrackingServerSummary::isActiveAsString)).setter(TrackingServerSummary.setter(Builder::isActive)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsActive").build()}).build();
    private static final SdkField<String> MLFLOW_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MlflowVersion").getter(TrackingServerSummary.getter(TrackingServerSummary::mlflowVersion)).setter(TrackingServerSummary.setter(Builder::mlflowVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MlflowVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRACKING_SERVER_ARN_FIELD, TRACKING_SERVER_NAME_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, TRACKING_SERVER_STATUS_FIELD, IS_ACTIVE_FIELD, MLFLOW_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TrackingServerSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String trackingServerArn;
    private final String trackingServerName;
    private final Instant creationTime;
    private final Instant lastModifiedTime;
    private final String trackingServerStatus;
    private final String isActive;
    private final String mlflowVersion;

    private TrackingServerSummary(BuilderImpl builder) {
        this.trackingServerArn = builder.trackingServerArn;
        this.trackingServerName = builder.trackingServerName;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.trackingServerStatus = builder.trackingServerStatus;
        this.isActive = builder.isActive;
        this.mlflowVersion = builder.mlflowVersion;
    }

    public final String trackingServerArn() {
        return this.trackingServerArn;
    }

    public final String trackingServerName() {
        return this.trackingServerName;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final TrackingServerStatus trackingServerStatus() {
        return TrackingServerStatus.fromValue(this.trackingServerStatus);
    }

    public final String trackingServerStatusAsString() {
        return this.trackingServerStatus;
    }

    public final IsTrackingServerActive isActive() {
        return IsTrackingServerActive.fromValue(this.isActive);
    }

    public final String isActiveAsString() {
        return this.isActive;
    }

    public final String mlflowVersion() {
        return this.mlflowVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.trackingServerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.trackingServerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.trackingServerStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.isActiveAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.mlflowVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrackingServerSummary)) {
            return false;
        }
        TrackingServerSummary other = (TrackingServerSummary)obj;
        return Objects.equals(this.trackingServerArn(), other.trackingServerArn()) && Objects.equals(this.trackingServerName(), other.trackingServerName()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.trackingServerStatusAsString(), other.trackingServerStatusAsString()) && Objects.equals(this.isActiveAsString(), other.isActiveAsString()) && Objects.equals(this.mlflowVersion(), other.mlflowVersion());
    }

    public final String toString() {
        return ToString.builder((String)"TrackingServerSummary").add("TrackingServerArn", (Object)this.trackingServerArn()).add("TrackingServerName", (Object)this.trackingServerName()).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("TrackingServerStatus", (Object)this.trackingServerStatusAsString()).add("IsActive", (Object)this.isActiveAsString()).add("MlflowVersion", (Object)this.mlflowVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrackingServerArn": {
                return Optional.ofNullable(clazz.cast(this.trackingServerArn()));
            }
            case "TrackingServerName": {
                return Optional.ofNullable(clazz.cast(this.trackingServerName()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "TrackingServerStatus": {
                return Optional.ofNullable(clazz.cast(this.trackingServerStatusAsString()));
            }
            case "IsActive": {
                return Optional.ofNullable(clazz.cast(this.isActiveAsString()));
            }
            case "MlflowVersion": {
                return Optional.ofNullable(clazz.cast(this.mlflowVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TrackingServerArn", TRACKING_SERVER_ARN_FIELD);
        map.put("TrackingServerName", TRACKING_SERVER_NAME_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("TrackingServerStatus", TRACKING_SERVER_STATUS_FIELD);
        map.put("IsActive", IS_ACTIVE_FIELD);
        map.put("MlflowVersion", MLFLOW_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TrackingServerSummary, T> g) {
        return obj -> g.apply((TrackingServerSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String trackingServerArn;
        private String trackingServerName;
        private Instant creationTime;
        private Instant lastModifiedTime;
        private String trackingServerStatus;
        private String isActive;
        private String mlflowVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(TrackingServerSummary model) {
            this.trackingServerArn(model.trackingServerArn);
            this.trackingServerName(model.trackingServerName);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.trackingServerStatus(model.trackingServerStatus);
            this.isActive(model.isActive);
            this.mlflowVersion(model.mlflowVersion);
        }

        public final String getTrackingServerArn() {
            return this.trackingServerArn;
        }

        public final void setTrackingServerArn(String trackingServerArn) {
            this.trackingServerArn = trackingServerArn;
        }

        @Override
        public final Builder trackingServerArn(String trackingServerArn) {
            this.trackingServerArn = trackingServerArn;
            return this;
        }

        public final String getTrackingServerName() {
            return this.trackingServerName;
        }

        public final void setTrackingServerName(String trackingServerName) {
            this.trackingServerName = trackingServerName;
        }

        @Override
        public final Builder trackingServerName(String trackingServerName) {
            this.trackingServerName = trackingServerName;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getTrackingServerStatus() {
            return this.trackingServerStatus;
        }

        public final void setTrackingServerStatus(String trackingServerStatus) {
            this.trackingServerStatus = trackingServerStatus;
        }

        @Override
        public final Builder trackingServerStatus(String trackingServerStatus) {
            this.trackingServerStatus = trackingServerStatus;
            return this;
        }

        @Override
        public final Builder trackingServerStatus(TrackingServerStatus trackingServerStatus) {
            this.trackingServerStatus(trackingServerStatus == null ? null : trackingServerStatus.toString());
            return this;
        }

        public final String getIsActive() {
            return this.isActive;
        }

        public final void setIsActive(String isActive) {
            this.isActive = isActive;
        }

        @Override
        public final Builder isActive(String isActive) {
            this.isActive = isActive;
            return this;
        }

        @Override
        public final Builder isActive(IsTrackingServerActive isActive) {
            this.isActive(isActive == null ? null : isActive.toString());
            return this;
        }

        public final String getMlflowVersion() {
            return this.mlflowVersion;
        }

        public final void setMlflowVersion(String mlflowVersion) {
            this.mlflowVersion = mlflowVersion;
        }

        @Override
        public final Builder mlflowVersion(String mlflowVersion) {
            this.mlflowVersion = mlflowVersion;
            return this;
        }

        public TrackingServerSummary build() {
            return new TrackingServerSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TrackingServerSummary> {
        public Builder trackingServerArn(String var1);

        public Builder trackingServerName(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder trackingServerStatus(String var1);

        public Builder trackingServerStatus(TrackingServerStatus var1);

        public Builder isActive(String var1);

        public Builder isActive(IsTrackingServerActive var1);

        public Builder mlflowVersion(String var1);
    }
}

