/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.SchedulerResourceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClusterSchedulerConfigSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClusterSchedulerConfigSummary> {
    private static final SdkField<String> CLUSTER_SCHEDULER_CONFIG_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterSchedulerConfigArn").getter(ClusterSchedulerConfigSummary.getter(ClusterSchedulerConfigSummary::clusterSchedulerConfigArn)).setter(ClusterSchedulerConfigSummary.setter(Builder::clusterSchedulerConfigArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterSchedulerConfigArn").build()}).build();
    private static final SdkField<String> CLUSTER_SCHEDULER_CONFIG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterSchedulerConfigId").getter(ClusterSchedulerConfigSummary.getter(ClusterSchedulerConfigSummary::clusterSchedulerConfigId)).setter(ClusterSchedulerConfigSummary.setter(Builder::clusterSchedulerConfigId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterSchedulerConfigId").build()}).build();
    private static final SdkField<Integer> CLUSTER_SCHEDULER_CONFIG_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ClusterSchedulerConfigVersion").getter(ClusterSchedulerConfigSummary.getter(ClusterSchedulerConfigSummary::clusterSchedulerConfigVersion)).setter(ClusterSchedulerConfigSummary.setter(Builder::clusterSchedulerConfigVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterSchedulerConfigVersion").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ClusterSchedulerConfigSummary.getter(ClusterSchedulerConfigSummary::name)).setter(ClusterSchedulerConfigSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(ClusterSchedulerConfigSummary.getter(ClusterSchedulerConfigSummary::creationTime)).setter(ClusterSchedulerConfigSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(ClusterSchedulerConfigSummary.getter(ClusterSchedulerConfigSummary::lastModifiedTime)).setter(ClusterSchedulerConfigSummary.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ClusterSchedulerConfigSummary.getter(ClusterSchedulerConfigSummary::statusAsString)).setter(ClusterSchedulerConfigSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterArn").getter(ClusterSchedulerConfigSummary.getter(ClusterSchedulerConfigSummary::clusterArn)).setter(ClusterSchedulerConfigSummary.setter(Builder::clusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_SCHEDULER_CONFIG_ARN_FIELD, CLUSTER_SCHEDULER_CONFIG_ID_FIELD, CLUSTER_SCHEDULER_CONFIG_VERSION_FIELD, NAME_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, STATUS_FIELD, CLUSTER_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ClusterSchedulerConfigSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String clusterSchedulerConfigArn;
    private final String clusterSchedulerConfigId;
    private final Integer clusterSchedulerConfigVersion;
    private final String name;
    private final Instant creationTime;
    private final Instant lastModifiedTime;
    private final String status;
    private final String clusterArn;

    private ClusterSchedulerConfigSummary(BuilderImpl builder) {
        this.clusterSchedulerConfigArn = builder.clusterSchedulerConfigArn;
        this.clusterSchedulerConfigId = builder.clusterSchedulerConfigId;
        this.clusterSchedulerConfigVersion = builder.clusterSchedulerConfigVersion;
        this.name = builder.name;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.status = builder.status;
        this.clusterArn = builder.clusterArn;
    }

    public final String clusterSchedulerConfigArn() {
        return this.clusterSchedulerConfigArn;
    }

    public final String clusterSchedulerConfigId() {
        return this.clusterSchedulerConfigId;
    }

    public final Integer clusterSchedulerConfigVersion() {
        return this.clusterSchedulerConfigVersion;
    }

    public final String name() {
        return this.name;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final SchedulerResourceStatus status() {
        return SchedulerResourceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String clusterArn() {
        return this.clusterArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterSchedulerConfigArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterSchedulerConfigId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterSchedulerConfigVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterSchedulerConfigSummary)) {
            return false;
        }
        ClusterSchedulerConfigSummary other = (ClusterSchedulerConfigSummary)obj;
        return Objects.equals(this.clusterSchedulerConfigArn(), other.clusterSchedulerConfigArn()) && Objects.equals(this.clusterSchedulerConfigId(), other.clusterSchedulerConfigId()) && Objects.equals(this.clusterSchedulerConfigVersion(), other.clusterSchedulerConfigVersion()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.clusterArn(), other.clusterArn());
    }

    public final String toString() {
        return ToString.builder((String)"ClusterSchedulerConfigSummary").add("ClusterSchedulerConfigArn", (Object)this.clusterSchedulerConfigArn()).add("ClusterSchedulerConfigId", (Object)this.clusterSchedulerConfigId()).add("ClusterSchedulerConfigVersion", (Object)this.clusterSchedulerConfigVersion()).add("Name", (Object)this.name()).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("Status", (Object)this.statusAsString()).add("ClusterArn", (Object)this.clusterArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterSchedulerConfigArn": {
                return Optional.ofNullable(clazz.cast(this.clusterSchedulerConfigArn()));
            }
            case "ClusterSchedulerConfigId": {
                return Optional.ofNullable(clazz.cast(this.clusterSchedulerConfigId()));
            }
            case "ClusterSchedulerConfigVersion": {
                return Optional.ofNullable(clazz.cast(this.clusterSchedulerConfigVersion()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "ClusterArn": {
                return Optional.ofNullable(clazz.cast(this.clusterArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ClusterSchedulerConfigArn", CLUSTER_SCHEDULER_CONFIG_ARN_FIELD);
        map.put("ClusterSchedulerConfigId", CLUSTER_SCHEDULER_CONFIG_ID_FIELD);
        map.put("ClusterSchedulerConfigVersion", CLUSTER_SCHEDULER_CONFIG_VERSION_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("ClusterArn", CLUSTER_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClusterSchedulerConfigSummary, T> g) {
        return obj -> g.apply((ClusterSchedulerConfigSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clusterSchedulerConfigArn;
        private String clusterSchedulerConfigId;
        private Integer clusterSchedulerConfigVersion;
        private String name;
        private Instant creationTime;
        private Instant lastModifiedTime;
        private String status;
        private String clusterArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterSchedulerConfigSummary model) {
            this.clusterSchedulerConfigArn(model.clusterSchedulerConfigArn);
            this.clusterSchedulerConfigId(model.clusterSchedulerConfigId);
            this.clusterSchedulerConfigVersion(model.clusterSchedulerConfigVersion);
            this.name(model.name);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.status(model.status);
            this.clusterArn(model.clusterArn);
        }

        public final String getClusterSchedulerConfigArn() {
            return this.clusterSchedulerConfigArn;
        }

        public final void setClusterSchedulerConfigArn(String clusterSchedulerConfigArn) {
            this.clusterSchedulerConfigArn = clusterSchedulerConfigArn;
        }

        @Override
        public final Builder clusterSchedulerConfigArn(String clusterSchedulerConfigArn) {
            this.clusterSchedulerConfigArn = clusterSchedulerConfigArn;
            return this;
        }

        public final String getClusterSchedulerConfigId() {
            return this.clusterSchedulerConfigId;
        }

        public final void setClusterSchedulerConfigId(String clusterSchedulerConfigId) {
            this.clusterSchedulerConfigId = clusterSchedulerConfigId;
        }

        @Override
        public final Builder clusterSchedulerConfigId(String clusterSchedulerConfigId) {
            this.clusterSchedulerConfigId = clusterSchedulerConfigId;
            return this;
        }

        public final Integer getClusterSchedulerConfigVersion() {
            return this.clusterSchedulerConfigVersion;
        }

        public final void setClusterSchedulerConfigVersion(Integer clusterSchedulerConfigVersion) {
            this.clusterSchedulerConfigVersion = clusterSchedulerConfigVersion;
        }

        @Override
        public final Builder clusterSchedulerConfigVersion(Integer clusterSchedulerConfigVersion) {
            this.clusterSchedulerConfigVersion = clusterSchedulerConfigVersion;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SchedulerResourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getClusterArn() {
            return this.clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public ClusterSchedulerConfigSummary build() {
            return new ClusterSchedulerConfigSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClusterSchedulerConfigSummary> {
        public Builder clusterSchedulerConfigArn(String var1);

        public Builder clusterSchedulerConfigId(String var1);

        public Builder clusterSchedulerConfigVersion(Integer var1);

        public Builder name(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder status(String var1);

        public Builder status(SchedulerResourceStatus var1);

        public Builder clusterArn(String var1);
    }
}

