/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.ListPartnerAppsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListPartnerAppsResponse;
import software.amazon.awssdk.services.sagemaker.model.PartnerAppSummary;

public class ListPartnerAppsIterable
implements SdkIterable<ListPartnerAppsResponse> {
    private final SageMakerClient client;
    private final ListPartnerAppsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPartnerAppsIterable(SageMakerClient client, ListPartnerAppsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPartnerAppsResponseFetcher();
    }

    public Iterator<ListPartnerAppsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PartnerAppSummary> summaries() {
        Function<ListPartnerAppsResponse, Iterator> getIterator = response -> {
            if (response != null && response.summaries() != null) {
                return response.summaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPartnerAppsResponseFetcher
    implements SyncPageFetcher<ListPartnerAppsResponse> {
        private ListPartnerAppsResponseFetcher() {
        }

        public boolean hasNextPage(ListPartnerAppsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPartnerAppsResponse nextPage(ListPartnerAppsResponse previousPage) {
            if (previousPage == null) {
                return ListPartnerAppsIterable.this.client.listPartnerApps(ListPartnerAppsIterable.this.firstRequest);
            }
            return ListPartnerAppsIterable.this.client.listPartnerApps((ListPartnerAppsRequest)((Object)ListPartnerAppsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

