/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeviceStats
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeviceStats> {
    private static final SdkField<Long> CONNECTED_DEVICE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ConnectedDeviceCount").getter(DeviceStats.getter(DeviceStats::connectedDeviceCount)).setter(DeviceStats.setter(Builder::connectedDeviceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectedDeviceCount").build()}).build();
    private static final SdkField<Long> REGISTERED_DEVICE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("RegisteredDeviceCount").getter(DeviceStats.getter(DeviceStats::registeredDeviceCount)).setter(DeviceStats.setter(Builder::registeredDeviceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegisteredDeviceCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTED_DEVICE_COUNT_FIELD, REGISTERED_DEVICE_COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeviceStats.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Long connectedDeviceCount;
    private final Long registeredDeviceCount;

    private DeviceStats(BuilderImpl builder) {
        this.connectedDeviceCount = builder.connectedDeviceCount;
        this.registeredDeviceCount = builder.registeredDeviceCount;
    }

    public final Long connectedDeviceCount() {
        return this.connectedDeviceCount;
    }

    public final Long registeredDeviceCount() {
        return this.registeredDeviceCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.connectedDeviceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.registeredDeviceCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceStats)) {
            return false;
        }
        DeviceStats other = (DeviceStats)obj;
        return Objects.equals(this.connectedDeviceCount(), other.connectedDeviceCount()) && Objects.equals(this.registeredDeviceCount(), other.registeredDeviceCount());
    }

    public final String toString() {
        return ToString.builder((String)"DeviceStats").add("ConnectedDeviceCount", (Object)this.connectedDeviceCount()).add("RegisteredDeviceCount", (Object)this.registeredDeviceCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectedDeviceCount": {
                return Optional.ofNullable(clazz.cast(this.connectedDeviceCount()));
            }
            case "RegisteredDeviceCount": {
                return Optional.ofNullable(clazz.cast(this.registeredDeviceCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Long>> map = new HashMap<String, SdkField<Long>>();
        map.put("ConnectedDeviceCount", CONNECTED_DEVICE_COUNT_FIELD);
        map.put("RegisteredDeviceCount", REGISTERED_DEVICE_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeviceStats, T> g) {
        return obj -> g.apply((DeviceStats)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long connectedDeviceCount;
        private Long registeredDeviceCount;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceStats model) {
            this.connectedDeviceCount(model.connectedDeviceCount);
            this.registeredDeviceCount(model.registeredDeviceCount);
        }

        public final Long getConnectedDeviceCount() {
            return this.connectedDeviceCount;
        }

        public final void setConnectedDeviceCount(Long connectedDeviceCount) {
            this.connectedDeviceCount = connectedDeviceCount;
        }

        @Override
        public final Builder connectedDeviceCount(Long connectedDeviceCount) {
            this.connectedDeviceCount = connectedDeviceCount;
            return this;
        }

        public final Long getRegisteredDeviceCount() {
            return this.registeredDeviceCount;
        }

        public final void setRegisteredDeviceCount(Long registeredDeviceCount) {
            this.registeredDeviceCount = registeredDeviceCount;
        }

        @Override
        public final Builder registeredDeviceCount(Long registeredDeviceCount) {
            this.registeredDeviceCount = registeredDeviceCount;
            return this;
        }

        public DeviceStats build() {
            return new DeviceStats(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeviceStats> {
        public Builder connectedDeviceCount(Long var1);

        public Builder registeredDeviceCount(Long var1);
    }
}

