/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.ListMonitoringAlertHistoryRequest;
import software.amazon.awssdk.services.sagemaker.model.ListMonitoringAlertHistoryResponse;
import software.amazon.awssdk.services.sagemaker.model.MonitoringAlertHistorySummary;

public class ListMonitoringAlertHistoryIterable
implements SdkIterable<ListMonitoringAlertHistoryResponse> {
    private final SageMakerClient client;
    private final ListMonitoringAlertHistoryRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMonitoringAlertHistoryIterable(SageMakerClient client, ListMonitoringAlertHistoryRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListMonitoringAlertHistoryResponseFetcher();
    }

    public Iterator<ListMonitoringAlertHistoryResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MonitoringAlertHistorySummary> monitoringAlertHistory() {
        Function<ListMonitoringAlertHistoryResponse, Iterator> getIterator = response -> {
            if (response != null && response.monitoringAlertHistory() != null) {
                return response.monitoringAlertHistory().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListMonitoringAlertHistoryResponseFetcher
    implements SyncPageFetcher<ListMonitoringAlertHistoryResponse> {
        private ListMonitoringAlertHistoryResponseFetcher() {
        }

        public boolean hasNextPage(ListMonitoringAlertHistoryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListMonitoringAlertHistoryResponse nextPage(ListMonitoringAlertHistoryResponse previousPage) {
            if (previousPage == null) {
                return ListMonitoringAlertHistoryIterable.this.client.listMonitoringAlertHistory(ListMonitoringAlertHistoryIterable.this.firstRequest);
            }
            return ListMonitoringAlertHistoryIterable.this.client.listMonitoringAlertHistory((ListMonitoringAlertHistoryRequest)((Object)ListMonitoringAlertHistoryIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

