/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.AutoRollbackConfig;
import software.amazon.awssdk.services.sagemaker.model.InferenceComponentRollingUpdatePolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InferenceComponentDeploymentConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InferenceComponentDeploymentConfig> {
    private static final SdkField<InferenceComponentRollingUpdatePolicy> ROLLING_UPDATE_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RollingUpdatePolicy").getter(InferenceComponentDeploymentConfig.getter(InferenceComponentDeploymentConfig::rollingUpdatePolicy)).setter(InferenceComponentDeploymentConfig.setter(Builder::rollingUpdatePolicy)).constructor(InferenceComponentRollingUpdatePolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RollingUpdatePolicy").build()}).build();
    private static final SdkField<AutoRollbackConfig> AUTO_ROLLBACK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AutoRollbackConfiguration").getter(InferenceComponentDeploymentConfig.getter(InferenceComponentDeploymentConfig::autoRollbackConfiguration)).setter(InferenceComponentDeploymentConfig.setter(Builder::autoRollbackConfiguration)).constructor(AutoRollbackConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoRollbackConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLLING_UPDATE_POLICY_FIELD, AUTO_ROLLBACK_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InferenceComponentDeploymentConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final InferenceComponentRollingUpdatePolicy rollingUpdatePolicy;
    private final AutoRollbackConfig autoRollbackConfiguration;

    private InferenceComponentDeploymentConfig(BuilderImpl builder) {
        this.rollingUpdatePolicy = builder.rollingUpdatePolicy;
        this.autoRollbackConfiguration = builder.autoRollbackConfiguration;
    }

    public final InferenceComponentRollingUpdatePolicy rollingUpdatePolicy() {
        return this.rollingUpdatePolicy;
    }

    public final AutoRollbackConfig autoRollbackConfiguration() {
        return this.autoRollbackConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.rollingUpdatePolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoRollbackConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferenceComponentDeploymentConfig)) {
            return false;
        }
        InferenceComponentDeploymentConfig other = (InferenceComponentDeploymentConfig)obj;
        return Objects.equals(this.rollingUpdatePolicy(), other.rollingUpdatePolicy()) && Objects.equals(this.autoRollbackConfiguration(), other.autoRollbackConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"InferenceComponentDeploymentConfig").add("RollingUpdatePolicy", (Object)this.rollingUpdatePolicy()).add("AutoRollbackConfiguration", (Object)this.autoRollbackConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RollingUpdatePolicy": {
                return Optional.ofNullable(clazz.cast(this.rollingUpdatePolicy()));
            }
            case "AutoRollbackConfiguration": {
                return Optional.ofNullable(clazz.cast(this.autoRollbackConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RollingUpdatePolicy", ROLLING_UPDATE_POLICY_FIELD);
        map.put("AutoRollbackConfiguration", AUTO_ROLLBACK_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InferenceComponentDeploymentConfig, T> g) {
        return obj -> g.apply((InferenceComponentDeploymentConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private InferenceComponentRollingUpdatePolicy rollingUpdatePolicy;
        private AutoRollbackConfig autoRollbackConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(InferenceComponentDeploymentConfig model) {
            this.rollingUpdatePolicy(model.rollingUpdatePolicy);
            this.autoRollbackConfiguration(model.autoRollbackConfiguration);
        }

        public final InferenceComponentRollingUpdatePolicy.Builder getRollingUpdatePolicy() {
            return this.rollingUpdatePolicy != null ? this.rollingUpdatePolicy.toBuilder() : null;
        }

        public final void setRollingUpdatePolicy(InferenceComponentRollingUpdatePolicy.BuilderImpl rollingUpdatePolicy) {
            this.rollingUpdatePolicy = rollingUpdatePolicy != null ? rollingUpdatePolicy.build() : null;
        }

        @Override
        public final Builder rollingUpdatePolicy(InferenceComponentRollingUpdatePolicy rollingUpdatePolicy) {
            this.rollingUpdatePolicy = rollingUpdatePolicy;
            return this;
        }

        public final AutoRollbackConfig.Builder getAutoRollbackConfiguration() {
            return this.autoRollbackConfiguration != null ? this.autoRollbackConfiguration.toBuilder() : null;
        }

        public final void setAutoRollbackConfiguration(AutoRollbackConfig.BuilderImpl autoRollbackConfiguration) {
            this.autoRollbackConfiguration = autoRollbackConfiguration != null ? autoRollbackConfiguration.build() : null;
        }

        @Override
        public final Builder autoRollbackConfiguration(AutoRollbackConfig autoRollbackConfiguration) {
            this.autoRollbackConfiguration = autoRollbackConfiguration;
            return this;
        }

        public InferenceComponentDeploymentConfig build() {
            return new InferenceComponentDeploymentConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InferenceComponentDeploymentConfig> {
        public Builder rollingUpdatePolicy(InferenceComponentRollingUpdatePolicy var1);

        default public Builder rollingUpdatePolicy(Consumer<InferenceComponentRollingUpdatePolicy.Builder> rollingUpdatePolicy) {
            return this.rollingUpdatePolicy((InferenceComponentRollingUpdatePolicy)((InferenceComponentRollingUpdatePolicy.Builder)InferenceComponentRollingUpdatePolicy.builder().applyMutation(rollingUpdatePolicy)).build());
        }

        public Builder autoRollbackConfiguration(AutoRollbackConfig var1);

        default public Builder autoRollbackConfiguration(Consumer<AutoRollbackConfig.Builder> autoRollbackConfiguration) {
            return this.autoRollbackConfiguration((AutoRollbackConfig)((AutoRollbackConfig.Builder)AutoRollbackConfig.builder().applyMutation(autoRollbackConfiguration)).build());
        }
    }
}

