/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.InferenceComponentSummary;
import software.amazon.awssdk.services.sagemaker.model.ListInferenceComponentsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListInferenceComponentsResponse;

public class ListInferenceComponentsPublisher
implements SdkPublisher<ListInferenceComponentsResponse> {
    private final SageMakerAsyncClient client;
    private final ListInferenceComponentsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListInferenceComponentsPublisher(SageMakerAsyncClient client, ListInferenceComponentsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListInferenceComponentsPublisher(SageMakerAsyncClient client, ListInferenceComponentsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListInferenceComponentsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListInferenceComponentsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<InferenceComponentSummary> inferenceComponents() {
        Function<ListInferenceComponentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.inferenceComponents() != null) {
                return response.inferenceComponents().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListInferenceComponentsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListInferenceComponentsResponseFetcher
    implements AsyncPageFetcher<ListInferenceComponentsResponse> {
        private ListInferenceComponentsResponseFetcher() {
        }

        public boolean hasNextPage(ListInferenceComponentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListInferenceComponentsResponse> nextPage(ListInferenceComponentsResponse previousPage) {
            if (previousPage == null) {
                return ListInferenceComponentsPublisher.this.client.listInferenceComponents(ListInferenceComponentsPublisher.this.firstRequest);
            }
            return ListInferenceComponentsPublisher.this.client.listInferenceComponents((ListInferenceComponentsRequest)((Object)ListInferenceComponentsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

