/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.DataSourceName;
import software.amazon.awssdk.services.sagemaker.model.FeatureStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IdentityProviderOAuthSetting
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IdentityProviderOAuthSetting> {
    private static final SdkField<String> DATA_SOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSourceName").getter(IdentityProviderOAuthSetting.getter(IdentityProviderOAuthSetting::dataSourceNameAsString)).setter(IdentityProviderOAuthSetting.setter(Builder::dataSourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(IdentityProviderOAuthSetting.getter(IdentityProviderOAuthSetting::statusAsString)).setter(IdentityProviderOAuthSetting.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretArn").getter(IdentityProviderOAuthSetting.getter(IdentityProviderOAuthSetting::secretArn)).setter(IdentityProviderOAuthSetting.setter(Builder::secretArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_NAME_FIELD, STATUS_FIELD, SECRET_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IdentityProviderOAuthSetting.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String dataSourceName;
    private final String status;
    private final String secretArn;

    private IdentityProviderOAuthSetting(BuilderImpl builder) {
        this.dataSourceName = builder.dataSourceName;
        this.status = builder.status;
        this.secretArn = builder.secretArn;
    }

    public final DataSourceName dataSourceName() {
        return DataSourceName.fromValue(this.dataSourceName);
    }

    public final String dataSourceNameAsString() {
        return this.dataSourceName;
    }

    public final FeatureStatus status() {
        return FeatureStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String secretArn() {
        return this.secretArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentityProviderOAuthSetting)) {
            return false;
        }
        IdentityProviderOAuthSetting other = (IdentityProviderOAuthSetting)obj;
        return Objects.equals(this.dataSourceNameAsString(), other.dataSourceNameAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.secretArn(), other.secretArn());
    }

    public final String toString() {
        return ToString.builder((String)"IdentityProviderOAuthSetting").add("DataSourceName", (Object)this.dataSourceNameAsString()).add("Status", (Object)this.statusAsString()).add("SecretArn", (Object)this.secretArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataSourceName": {
                return Optional.ofNullable(clazz.cast(this.dataSourceNameAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "SecretArn": {
                return Optional.ofNullable(clazz.cast(this.secretArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("DataSourceName", DATA_SOURCE_NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("SecretArn", SECRET_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IdentityProviderOAuthSetting, T> g) {
        return obj -> g.apply((IdentityProviderOAuthSetting)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dataSourceName;
        private String status;
        private String secretArn;

        private BuilderImpl() {
        }

        private BuilderImpl(IdentityProviderOAuthSetting model) {
            this.dataSourceName(model.dataSourceName);
            this.status(model.status);
            this.secretArn(model.secretArn);
        }

        public final String getDataSourceName() {
            return this.dataSourceName;
        }

        public final void setDataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
        }

        @Override
        public final Builder dataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
            return this;
        }

        @Override
        public final Builder dataSourceName(DataSourceName dataSourceName) {
            this.dataSourceName(dataSourceName == null ? null : dataSourceName.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FeatureStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getSecretArn() {
            return this.secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public IdentityProviderOAuthSetting build() {
            return new IdentityProviderOAuthSetting(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IdentityProviderOAuthSetting> {
        public Builder dataSourceName(String var1);

        public Builder dataSourceName(DataSourceName var1);

        public Builder status(String var1);

        public Builder status(FeatureStatus var1);

        public Builder secretArn(String var1);
    }
}

