/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.CompilationJobStatus;
import software.amazon.awssdk.services.sagemaker.model.DerivedInformation;
import software.amazon.awssdk.services.sagemaker.model.InputConfig;
import software.amazon.awssdk.services.sagemaker.model.ModelArtifacts;
import software.amazon.awssdk.services.sagemaker.model.ModelDigests;
import software.amazon.awssdk.services.sagemaker.model.NeoVpcConfig;
import software.amazon.awssdk.services.sagemaker.model.OutputConfig;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.services.sagemaker.model.StoppingCondition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeCompilationJobResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, DescribeCompilationJobResponse> {
    private static final SdkField<String> COMPILATION_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CompilationJobName").getter(DescribeCompilationJobResponse.getter(DescribeCompilationJobResponse::compilationJobName)).setter(DescribeCompilationJobResponse.setter(Builder::compilationJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompilationJobName").build()}).build();
    private static final SdkField<String> COMPILATION_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CompilationJobArn").getter(DescribeCompilationJobResponse.getter(DescribeCompilationJobResponse::compilationJobArn)).setter(DescribeCompilationJobResponse.setter(Builder::compilationJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompilationJobArn").build()}).build();
    private static final SdkField<String> COMPILATION_JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CompilationJobStatus").getter(DescribeCompilationJobResponse.getter(DescribeCompilationJobResponse::compilationJobStatusAsString)).setter(DescribeCompilationJobResponse.setter(Builder::compilationJobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompilationJobStatus").build()}).build();
    private static final SdkField<Instant> COMPILATION_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CompilationStartTime").getter(DescribeCompilationJobResponse.getter(DescribeCompilationJobResponse::compilationStartTime)).setter(DescribeCompilationJobResponse.setter(Builder::compilationStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompilationStartTime").build()}).build();
    private static final SdkField<Instant> COMPILATION_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CompilationEndTime").getter(DescribeCompilationJobResponse.getter(DescribeCompilationJobResponse::compilationEndTime)).setter(DescribeCompilationJobResponse.setter(Builder::compilationEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompilationEndTime").build()}).build();
    private static final SdkField<StoppingCondition> STOPPING_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StoppingCondition").getter(DescribeCompilationJobResponse.getter(DescribeCompilationJobResponse::stoppingCondition)).setter(DescribeCompilationJobResponse.setter(Builder::stoppingCondition)).constructor(StoppingCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoppingCondition").build()}).build();
    private static final SdkField<String> INFERENCE_IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InferenceImage").getter(DescribeCompilationJobResponse.getter(DescribeCompilationJobResponse::inferenceImage)).setter(DescribeCompilationJobResponse.setter(Builder::inferenceImage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceImage").build()}).build();
    private static final SdkField<String> MODEL_PACKAGE_VERSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelPackageVersionArn").getter(DescribeCompilationJobResponse.getter(DescribeCompilationJobResponse::modelPackageVersionArn)).setter(DescribeCompilationJobResponse.setter(Builder::modelPackageVersionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageVersionArn").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeCompilationJobResponse.getter(DescribeCompilationJobResponse::creationTime)).setter(DescribeCompilationJobResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(DescribeCompilationJobResponse.getter(DescribeCompilationJobResponse::lastModifiedTime)).setter(DescribeCompilationJobResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(DescribeCompilationJobResponse.getter(DescribeCompilationJobResponse::failureReason)).setter(DescribeCompilationJobResponse.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final SdkField<ModelArtifacts> MODEL_ARTIFACTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModelArtifacts").getter(DescribeCompilationJobResponse.getter(DescribeCompilationJobResponse::modelArtifacts)).setter(DescribeCompilationJobResponse.setter(Builder::modelArtifacts)).constructor(ModelArtifacts::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelArtifacts").build()}).build();
    private static final SdkField<ModelDigests> MODEL_DIGESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModelDigests").getter(DescribeCompilationJobResponse.getter(DescribeCompilationJobResponse::modelDigests)).setter(DescribeCompilationJobResponse.setter(Builder::modelDigests)).constructor(ModelDigests::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelDigests").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(DescribeCompilationJobResponse.getter(DescribeCompilationJobResponse::roleArn)).setter(DescribeCompilationJobResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<InputConfig> INPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InputConfig").getter(DescribeCompilationJobResponse.getter(DescribeCompilationJobResponse::inputConfig)).setter(DescribeCompilationJobResponse.setter(Builder::inputConfig)).constructor(InputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputConfig").build()}).build();
    private static final SdkField<OutputConfig> OUTPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutputConfig").getter(DescribeCompilationJobResponse.getter(DescribeCompilationJobResponse::outputConfig)).setter(DescribeCompilationJobResponse.setter(Builder::outputConfig)).constructor(OutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()}).build();
    private static final SdkField<NeoVpcConfig> VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcConfig").getter(DescribeCompilationJobResponse.getter(DescribeCompilationJobResponse::vpcConfig)).setter(DescribeCompilationJobResponse.setter(Builder::vpcConfig)).constructor(NeoVpcConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()}).build();
    private static final SdkField<DerivedInformation> DERIVED_INFORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DerivedInformation").getter(DescribeCompilationJobResponse.getter(DescribeCompilationJobResponse::derivedInformation)).setter(DescribeCompilationJobResponse.setter(Builder::derivedInformation)).constructor(DerivedInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DerivedInformation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPILATION_JOB_NAME_FIELD, COMPILATION_JOB_ARN_FIELD, COMPILATION_JOB_STATUS_FIELD, COMPILATION_START_TIME_FIELD, COMPILATION_END_TIME_FIELD, STOPPING_CONDITION_FIELD, INFERENCE_IMAGE_FIELD, MODEL_PACKAGE_VERSION_ARN_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, FAILURE_REASON_FIELD, MODEL_ARTIFACTS_FIELD, MODEL_DIGESTS_FIELD, ROLE_ARN_FIELD, INPUT_CONFIG_FIELD, OUTPUT_CONFIG_FIELD, VPC_CONFIG_FIELD, DERIVED_INFORMATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeCompilationJobResponse.memberNameToFieldInitializer();
    private final String compilationJobName;
    private final String compilationJobArn;
    private final String compilationJobStatus;
    private final Instant compilationStartTime;
    private final Instant compilationEndTime;
    private final StoppingCondition stoppingCondition;
    private final String inferenceImage;
    private final String modelPackageVersionArn;
    private final Instant creationTime;
    private final Instant lastModifiedTime;
    private final String failureReason;
    private final ModelArtifacts modelArtifacts;
    private final ModelDigests modelDigests;
    private final String roleArn;
    private final InputConfig inputConfig;
    private final OutputConfig outputConfig;
    private final NeoVpcConfig vpcConfig;
    private final DerivedInformation derivedInformation;

    private DescribeCompilationJobResponse(BuilderImpl builder) {
        super(builder);
        this.compilationJobName = builder.compilationJobName;
        this.compilationJobArn = builder.compilationJobArn;
        this.compilationJobStatus = builder.compilationJobStatus;
        this.compilationStartTime = builder.compilationStartTime;
        this.compilationEndTime = builder.compilationEndTime;
        this.stoppingCondition = builder.stoppingCondition;
        this.inferenceImage = builder.inferenceImage;
        this.modelPackageVersionArn = builder.modelPackageVersionArn;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.failureReason = builder.failureReason;
        this.modelArtifacts = builder.modelArtifacts;
        this.modelDigests = builder.modelDigests;
        this.roleArn = builder.roleArn;
        this.inputConfig = builder.inputConfig;
        this.outputConfig = builder.outputConfig;
        this.vpcConfig = builder.vpcConfig;
        this.derivedInformation = builder.derivedInformation;
    }

    public final String compilationJobName() {
        return this.compilationJobName;
    }

    public final String compilationJobArn() {
        return this.compilationJobArn;
    }

    public final CompilationJobStatus compilationJobStatus() {
        return CompilationJobStatus.fromValue(this.compilationJobStatus);
    }

    public final String compilationJobStatusAsString() {
        return this.compilationJobStatus;
    }

    public final Instant compilationStartTime() {
        return this.compilationStartTime;
    }

    public final Instant compilationEndTime() {
        return this.compilationEndTime;
    }

    public final StoppingCondition stoppingCondition() {
        return this.stoppingCondition;
    }

    public final String inferenceImage() {
        return this.inferenceImage;
    }

    public final String modelPackageVersionArn() {
        return this.modelPackageVersionArn;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final ModelArtifacts modelArtifacts() {
        return this.modelArtifacts;
    }

    public final ModelDigests modelDigests() {
        return this.modelDigests;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final InputConfig inputConfig() {
        return this.inputConfig;
    }

    public final OutputConfig outputConfig() {
        return this.outputConfig;
    }

    public final NeoVpcConfig vpcConfig() {
        return this.vpcConfig;
    }

    public final DerivedInformation derivedInformation() {
        return this.derivedInformation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.compilationJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.compilationJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.compilationJobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.compilationStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.compilationEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.stoppingCondition());
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceImage());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelPackageVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelArtifacts());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelDigests());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.derivedInformation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCompilationJobResponse)) {
            return false;
        }
        DescribeCompilationJobResponse other = (DescribeCompilationJobResponse)((Object)obj);
        return Objects.equals(this.compilationJobName(), other.compilationJobName()) && Objects.equals(this.compilationJobArn(), other.compilationJobArn()) && Objects.equals(this.compilationJobStatusAsString(), other.compilationJobStatusAsString()) && Objects.equals(this.compilationStartTime(), other.compilationStartTime()) && Objects.equals(this.compilationEndTime(), other.compilationEndTime()) && Objects.equals(this.stoppingCondition(), other.stoppingCondition()) && Objects.equals(this.inferenceImage(), other.inferenceImage()) && Objects.equals(this.modelPackageVersionArn(), other.modelPackageVersionArn()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.modelArtifacts(), other.modelArtifacts()) && Objects.equals(this.modelDigests(), other.modelDigests()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.inputConfig(), other.inputConfig()) && Objects.equals(this.outputConfig(), other.outputConfig()) && Objects.equals(this.vpcConfig(), other.vpcConfig()) && Objects.equals(this.derivedInformation(), other.derivedInformation());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeCompilationJobResponse").add("CompilationJobName", (Object)this.compilationJobName()).add("CompilationJobArn", (Object)this.compilationJobArn()).add("CompilationJobStatus", (Object)this.compilationJobStatusAsString()).add("CompilationStartTime", (Object)this.compilationStartTime()).add("CompilationEndTime", (Object)this.compilationEndTime()).add("StoppingCondition", (Object)this.stoppingCondition()).add("InferenceImage", (Object)this.inferenceImage()).add("ModelPackageVersionArn", (Object)this.modelPackageVersionArn()).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("FailureReason", (Object)this.failureReason()).add("ModelArtifacts", (Object)this.modelArtifacts()).add("ModelDigests", (Object)this.modelDigests()).add("RoleArn", (Object)this.roleArn()).add("InputConfig", (Object)this.inputConfig()).add("OutputConfig", (Object)this.outputConfig()).add("VpcConfig", (Object)this.vpcConfig()).add("DerivedInformation", (Object)this.derivedInformation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CompilationJobName": {
                return Optional.ofNullable(clazz.cast(this.compilationJobName()));
            }
            case "CompilationJobArn": {
                return Optional.ofNullable(clazz.cast(this.compilationJobArn()));
            }
            case "CompilationJobStatus": {
                return Optional.ofNullable(clazz.cast(this.compilationJobStatusAsString()));
            }
            case "CompilationStartTime": {
                return Optional.ofNullable(clazz.cast(this.compilationStartTime()));
            }
            case "CompilationEndTime": {
                return Optional.ofNullable(clazz.cast(this.compilationEndTime()));
            }
            case "StoppingCondition": {
                return Optional.ofNullable(clazz.cast(this.stoppingCondition()));
            }
            case "InferenceImage": {
                return Optional.ofNullable(clazz.cast(this.inferenceImage()));
            }
            case "ModelPackageVersionArn": {
                return Optional.ofNullable(clazz.cast(this.modelPackageVersionArn()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "ModelArtifacts": {
                return Optional.ofNullable(clazz.cast(this.modelArtifacts()));
            }
            case "ModelDigests": {
                return Optional.ofNullable(clazz.cast(this.modelDigests()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "InputConfig": {
                return Optional.ofNullable(clazz.cast(this.inputConfig()));
            }
            case "OutputConfig": {
                return Optional.ofNullable(clazz.cast(this.outputConfig()));
            }
            case "VpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
            case "DerivedInformation": {
                return Optional.ofNullable(clazz.cast(this.derivedInformation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CompilationJobName", COMPILATION_JOB_NAME_FIELD);
        map.put("CompilationJobArn", COMPILATION_JOB_ARN_FIELD);
        map.put("CompilationJobStatus", COMPILATION_JOB_STATUS_FIELD);
        map.put("CompilationStartTime", COMPILATION_START_TIME_FIELD);
        map.put("CompilationEndTime", COMPILATION_END_TIME_FIELD);
        map.put("StoppingCondition", STOPPING_CONDITION_FIELD);
        map.put("InferenceImage", INFERENCE_IMAGE_FIELD);
        map.put("ModelPackageVersionArn", MODEL_PACKAGE_VERSION_ARN_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("FailureReason", FAILURE_REASON_FIELD);
        map.put("ModelArtifacts", MODEL_ARTIFACTS_FIELD);
        map.put("ModelDigests", MODEL_DIGESTS_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("InputConfig", INPUT_CONFIG_FIELD);
        map.put("OutputConfig", OUTPUT_CONFIG_FIELD);
        map.put("VpcConfig", VPC_CONFIG_FIELD);
        map.put("DerivedInformation", DERIVED_INFORMATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeCompilationJobResponse, T> g) {
        return obj -> g.apply((DescribeCompilationJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String compilationJobName;
        private String compilationJobArn;
        private String compilationJobStatus;
        private Instant compilationStartTime;
        private Instant compilationEndTime;
        private StoppingCondition stoppingCondition;
        private String inferenceImage;
        private String modelPackageVersionArn;
        private Instant creationTime;
        private Instant lastModifiedTime;
        private String failureReason;
        private ModelArtifacts modelArtifacts;
        private ModelDigests modelDigests;
        private String roleArn;
        private InputConfig inputConfig;
        private OutputConfig outputConfig;
        private NeoVpcConfig vpcConfig;
        private DerivedInformation derivedInformation;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCompilationJobResponse model) {
            super(model);
            this.compilationJobName(model.compilationJobName);
            this.compilationJobArn(model.compilationJobArn);
            this.compilationJobStatus(model.compilationJobStatus);
            this.compilationStartTime(model.compilationStartTime);
            this.compilationEndTime(model.compilationEndTime);
            this.stoppingCondition(model.stoppingCondition);
            this.inferenceImage(model.inferenceImage);
            this.modelPackageVersionArn(model.modelPackageVersionArn);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.failureReason(model.failureReason);
            this.modelArtifacts(model.modelArtifacts);
            this.modelDigests(model.modelDigests);
            this.roleArn(model.roleArn);
            this.inputConfig(model.inputConfig);
            this.outputConfig(model.outputConfig);
            this.vpcConfig(model.vpcConfig);
            this.derivedInformation(model.derivedInformation);
        }

        public final String getCompilationJobName() {
            return this.compilationJobName;
        }

        public final void setCompilationJobName(String compilationJobName) {
            this.compilationJobName = compilationJobName;
        }

        @Override
        public final Builder compilationJobName(String compilationJobName) {
            this.compilationJobName = compilationJobName;
            return this;
        }

        public final String getCompilationJobArn() {
            return this.compilationJobArn;
        }

        public final void setCompilationJobArn(String compilationJobArn) {
            this.compilationJobArn = compilationJobArn;
        }

        @Override
        public final Builder compilationJobArn(String compilationJobArn) {
            this.compilationJobArn = compilationJobArn;
            return this;
        }

        public final String getCompilationJobStatus() {
            return this.compilationJobStatus;
        }

        public final void setCompilationJobStatus(String compilationJobStatus) {
            this.compilationJobStatus = compilationJobStatus;
        }

        @Override
        public final Builder compilationJobStatus(String compilationJobStatus) {
            this.compilationJobStatus = compilationJobStatus;
            return this;
        }

        @Override
        public final Builder compilationJobStatus(CompilationJobStatus compilationJobStatus) {
            this.compilationJobStatus(compilationJobStatus == null ? null : compilationJobStatus.toString());
            return this;
        }

        public final Instant getCompilationStartTime() {
            return this.compilationStartTime;
        }

        public final void setCompilationStartTime(Instant compilationStartTime) {
            this.compilationStartTime = compilationStartTime;
        }

        @Override
        public final Builder compilationStartTime(Instant compilationStartTime) {
            this.compilationStartTime = compilationStartTime;
            return this;
        }

        public final Instant getCompilationEndTime() {
            return this.compilationEndTime;
        }

        public final void setCompilationEndTime(Instant compilationEndTime) {
            this.compilationEndTime = compilationEndTime;
        }

        @Override
        public final Builder compilationEndTime(Instant compilationEndTime) {
            this.compilationEndTime = compilationEndTime;
            return this;
        }

        public final StoppingCondition.Builder getStoppingCondition() {
            return this.stoppingCondition != null ? this.stoppingCondition.toBuilder() : null;
        }

        public final void setStoppingCondition(StoppingCondition.BuilderImpl stoppingCondition) {
            this.stoppingCondition = stoppingCondition != null ? stoppingCondition.build() : null;
        }

        @Override
        public final Builder stoppingCondition(StoppingCondition stoppingCondition) {
            this.stoppingCondition = stoppingCondition;
            return this;
        }

        public final String getInferenceImage() {
            return this.inferenceImage;
        }

        public final void setInferenceImage(String inferenceImage) {
            this.inferenceImage = inferenceImage;
        }

        @Override
        public final Builder inferenceImage(String inferenceImage) {
            this.inferenceImage = inferenceImage;
            return this;
        }

        public final String getModelPackageVersionArn() {
            return this.modelPackageVersionArn;
        }

        public final void setModelPackageVersionArn(String modelPackageVersionArn) {
            this.modelPackageVersionArn = modelPackageVersionArn;
        }

        @Override
        public final Builder modelPackageVersionArn(String modelPackageVersionArn) {
            this.modelPackageVersionArn = modelPackageVersionArn;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final ModelArtifacts.Builder getModelArtifacts() {
            return this.modelArtifacts != null ? this.modelArtifacts.toBuilder() : null;
        }

        public final void setModelArtifacts(ModelArtifacts.BuilderImpl modelArtifacts) {
            this.modelArtifacts = modelArtifacts != null ? modelArtifacts.build() : null;
        }

        @Override
        public final Builder modelArtifacts(ModelArtifacts modelArtifacts) {
            this.modelArtifacts = modelArtifacts;
            return this;
        }

        public final ModelDigests.Builder getModelDigests() {
            return this.modelDigests != null ? this.modelDigests.toBuilder() : null;
        }

        public final void setModelDigests(ModelDigests.BuilderImpl modelDigests) {
            this.modelDigests = modelDigests != null ? modelDigests.build() : null;
        }

        @Override
        public final Builder modelDigests(ModelDigests modelDigests) {
            this.modelDigests = modelDigests;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final InputConfig.Builder getInputConfig() {
            return this.inputConfig != null ? this.inputConfig.toBuilder() : null;
        }

        public final void setInputConfig(InputConfig.BuilderImpl inputConfig) {
            this.inputConfig = inputConfig != null ? inputConfig.build() : null;
        }

        @Override
        public final Builder inputConfig(InputConfig inputConfig) {
            this.inputConfig = inputConfig;
            return this;
        }

        public final OutputConfig.Builder getOutputConfig() {
            return this.outputConfig != null ? this.outputConfig.toBuilder() : null;
        }

        public final void setOutputConfig(OutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        public final Builder outputConfig(OutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final NeoVpcConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(NeoVpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(NeoVpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final DerivedInformation.Builder getDerivedInformation() {
            return this.derivedInformation != null ? this.derivedInformation.toBuilder() : null;
        }

        public final void setDerivedInformation(DerivedInformation.BuilderImpl derivedInformation) {
            this.derivedInformation = derivedInformation != null ? derivedInformation.build() : null;
        }

        @Override
        public final Builder derivedInformation(DerivedInformation derivedInformation) {
            this.derivedInformation = derivedInformation;
            return this;
        }

        @Override
        public DescribeCompilationJobResponse build() {
            return new DescribeCompilationJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeCompilationJobResponse> {
        public Builder compilationJobName(String var1);

        public Builder compilationJobArn(String var1);

        public Builder compilationJobStatus(String var1);

        public Builder compilationJobStatus(CompilationJobStatus var1);

        public Builder compilationStartTime(Instant var1);

        public Builder compilationEndTime(Instant var1);

        public Builder stoppingCondition(StoppingCondition var1);

        default public Builder stoppingCondition(Consumer<StoppingCondition.Builder> stoppingCondition) {
            return this.stoppingCondition((StoppingCondition)((StoppingCondition.Builder)StoppingCondition.builder().applyMutation(stoppingCondition)).build());
        }

        public Builder inferenceImage(String var1);

        public Builder modelPackageVersionArn(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder failureReason(String var1);

        public Builder modelArtifacts(ModelArtifacts var1);

        default public Builder modelArtifacts(Consumer<ModelArtifacts.Builder> modelArtifacts) {
            return this.modelArtifacts((ModelArtifacts)((ModelArtifacts.Builder)ModelArtifacts.builder().applyMutation(modelArtifacts)).build());
        }

        public Builder modelDigests(ModelDigests var1);

        default public Builder modelDigests(Consumer<ModelDigests.Builder> modelDigests) {
            return this.modelDigests((ModelDigests)((ModelDigests.Builder)ModelDigests.builder().applyMutation(modelDigests)).build());
        }

        public Builder roleArn(String var1);

        public Builder inputConfig(InputConfig var1);

        default public Builder inputConfig(Consumer<InputConfig.Builder> inputConfig) {
            return this.inputConfig((InputConfig)((InputConfig.Builder)InputConfig.builder().applyMutation(inputConfig)).build());
        }

        public Builder outputConfig(OutputConfig var1);

        default public Builder outputConfig(Consumer<OutputConfig.Builder> outputConfig) {
            return this.outputConfig((OutputConfig)((OutputConfig.Builder)OutputConfig.builder().applyMutation(outputConfig)).build());
        }

        public Builder vpcConfig(NeoVpcConfig var1);

        default public Builder vpcConfig(Consumer<NeoVpcConfig.Builder> vpcConfig) {
            return this.vpcConfig((NeoVpcConfig)((NeoVpcConfig.Builder)NeoVpcConfig.builder().applyMutation(vpcConfig)).build());
        }

        public Builder derivedInformation(DerivedInformation var1);

        default public Builder derivedInformation(Consumer<DerivedInformation.Builder> derivedInformation) {
            return this.derivedInformation((DerivedInformation)((DerivedInformation.Builder)DerivedInformation.builder().applyMutation(derivedInformation)).build());
        }
    }
}

